// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivPagerJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivPager> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivPager {
            val logger = context.logger
            return DivPager(
                accessibility = JsonPropertyParser.readOptional(context, logger, data, "accessibility", component.divAccessibilityJsonEntityParser),
                alignmentHorizontal = JsonExpressionParser.readOptionalExpression(context, logger, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonExpressionParser.readOptionalExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING),
                alpha = JsonExpressionParser.readOptionalExpression(context, logger, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                animators = JsonPropertyParser.readOptionalList(context, logger, data, "animators", component.divAnimatorJsonEntityParser),
                background = JsonPropertyParser.readOptionalList(context, logger, data, "background", component.divBackgroundJsonEntityParser),
                border = JsonPropertyParser.readOptional(context, logger, data, "border", component.divBorderJsonEntityParser),
                columnSpan = JsonExpressionParser.readOptionalExpression(context, logger, data, "column_span", TYPE_HELPER_INT, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                defaultItem = JsonExpressionParser.readOptionalExpression(context, logger, data, "default_item", TYPE_HELPER_INT, NUMBER_TO_INT, DEFAULT_ITEM_VALIDATOR, DEFAULT_ITEM_DEFAULT_VALUE) ?: DEFAULT_ITEM_DEFAULT_VALUE,
                disappearActions = JsonPropertyParser.readOptionalList(context, logger, data, "disappear_actions", component.divDisappearActionJsonEntityParser),
                extensions = JsonPropertyParser.readOptionalList(context, logger, data, "extensions", component.divExtensionJsonEntityParser),
                focus = JsonPropertyParser.readOptional(context, logger, data, "focus", component.divFocusJsonEntityParser),
                functions = JsonPropertyParser.readOptionalList(context, logger, data, "functions", component.divFunctionJsonEntityParser),
                height = JsonPropertyParser.readOptional(context, logger, data, "height", component.divSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonPropertyParser.readOptional(context, logger, data, "id"),
                infiniteScroll = JsonExpressionParser.readOptionalExpression(context, logger, data, "infinite_scroll", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, INFINITE_SCROLL_DEFAULT_VALUE) ?: INFINITE_SCROLL_DEFAULT_VALUE,
                itemBuilder = JsonPropertyParser.readOptional(context, logger, data, "item_builder", component.divCollectionItemBuilderJsonEntityParser),
                itemSpacing = JsonPropertyParser.readOptional(context, logger, data, "item_spacing", component.divFixedSizeJsonEntityParser) ?: ITEM_SPACING_DEFAULT_VALUE,
                items = JsonPropertyParser.readOptionalList(context, logger, data, "items", component.divJsonEntityParser),
                layoutMode = JsonPropertyParser.read(context, logger, data, "layout_mode", component.divPagerLayoutModeJsonEntityParser),
                layoutProvider = JsonPropertyParser.readOptional(context, logger, data, "layout_provider", component.divLayoutProviderJsonEntityParser),
                margins = JsonPropertyParser.readOptional(context, logger, data, "margins", component.divEdgeInsetsJsonEntityParser),
                orientation = JsonExpressionParser.readOptionalExpression(context, logger, data, "orientation", TYPE_HELPER_ORIENTATION, DivPager.Orientation.FROM_STRING, ORIENTATION_DEFAULT_VALUE) ?: ORIENTATION_DEFAULT_VALUE,
                paddings = JsonPropertyParser.readOptional(context, logger, data, "paddings", component.divEdgeInsetsJsonEntityParser),
                pageTransformation = JsonPropertyParser.readOptional(context, logger, data, "page_transformation", component.divPageTransformationJsonEntityParser),
                restrictParentScroll = JsonExpressionParser.readOptionalExpression(context, logger, data, "restrict_parent_scroll", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, RESTRICT_PARENT_SCROLL_DEFAULT_VALUE) ?: RESTRICT_PARENT_SCROLL_DEFAULT_VALUE,
                reuseId = JsonExpressionParser.readOptionalExpression(context, logger, data, "reuse_id", TYPE_HELPER_STRING),
                rowSpan = JsonExpressionParser.readOptionalExpression(context, logger, data, "row_span", TYPE_HELPER_INT, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectedActions = JsonPropertyParser.readOptionalList(context, logger, data, "selected_actions", component.divActionJsonEntityParser),
                tooltips = JsonPropertyParser.readOptionalList(context, logger, data, "tooltips", component.divTooltipJsonEntityParser),
                transform = JsonPropertyParser.readOptional(context, logger, data, "transform", component.divTransformJsonEntityParser),
                transitionChange = JsonPropertyParser.readOptional(context, logger, data, "transition_change", component.divChangeTransitionJsonEntityParser),
                transitionIn = JsonPropertyParser.readOptional(context, logger, data, "transition_in", component.divAppearanceTransitionJsonEntityParser),
                transitionOut = JsonPropertyParser.readOptional(context, logger, data, "transition_out", component.divAppearanceTransitionJsonEntityParser),
                transitionTriggers = JsonPropertyParser.readOptionalList(context, logger, data, "transition_triggers", DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR),
                variableTriggers = JsonPropertyParser.readOptionalList(context, logger, data, "variable_triggers", component.divTriggerJsonEntityParser),
                variables = JsonPropertyParser.readOptionalList(context, logger, data, "variables", component.divVariableJsonEntityParser),
                visibility = JsonExpressionParser.readOptionalExpression(context, logger, data, "visibility", TYPE_HELPER_VISIBILITY, DivVisibility.FROM_STRING, VISIBILITY_DEFAULT_VALUE) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonPropertyParser.readOptional(context, logger, data, "visibility_action", component.divVisibilityActionJsonEntityParser),
                visibilityActions = JsonPropertyParser.readOptionalList(context, logger, data, "visibility_actions", component.divVisibilityActionJsonEntityParser),
                width = JsonPropertyParser.readOptional(context, logger, data, "width", component.divSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivPager): JSONObject {
            val data = JSONObject()
            data.write(key = "accessibility", value = component.divAccessibilityJsonEntityParser.value.serialize(context, value.accessibility))
            data.writeExpression(key = "alignment_horizontal", value = value.alignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeExpression(key = "alignment_vertical", value = value.alignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeExpression(key = "alpha", value = value.alpha)
            data.write(key = "animators", value = component.divAnimatorJsonEntityParser.value.serialize(context, value.animators))
            data.write(key = "background", value = component.divBackgroundJsonEntityParser.value.serialize(context, value.background))
            data.write(key = "border", value = component.divBorderJsonEntityParser.value.serialize(context, value.border))
            data.writeExpression(key = "column_span", value = value.columnSpan)
            data.writeExpression(key = "default_item", value = value.defaultItem)
            data.write(key = "disappear_actions", value = component.divDisappearActionJsonEntityParser.value.serialize(context, value.disappearActions))
            data.write(key = "extensions", value = component.divExtensionJsonEntityParser.value.serialize(context, value.extensions))
            data.write(key = "focus", value = component.divFocusJsonEntityParser.value.serialize(context, value.focus))
            data.write(key = "functions", value = component.divFunctionJsonEntityParser.value.serialize(context, value.functions))
            data.write(key = "height", value = component.divSizeJsonEntityParser.value.serialize(context, value.height))
            data.write(key = "id", value = value.id)
            data.writeExpression(key = "infinite_scroll", value = value.infiniteScroll)
            data.write(key = "item_builder", value = component.divCollectionItemBuilderJsonEntityParser.value.serialize(context, value.itemBuilder))
            data.write(key = "item_spacing", value = component.divFixedSizeJsonEntityParser.value.serialize(context, value.itemSpacing))
            data.write(key = "items", value = component.divJsonEntityParser.value.serialize(context, value.items))
            data.write(key = "layout_mode", value = component.divPagerLayoutModeJsonEntityParser.value.serialize(context, value.layoutMode))
            data.write(key = "layout_provider", value = component.divLayoutProviderJsonEntityParser.value.serialize(context, value.layoutProvider))
            data.write(key = "margins", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.margins))
            data.writeExpression(key = "orientation", value = value.orientation, converter = DivPager.Orientation.TO_STRING)
            data.write(key = "paddings", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.paddings))
            data.write(key = "page_transformation", value = component.divPageTransformationJsonEntityParser.value.serialize(context, value.pageTransformation))
            data.writeExpression(key = "restrict_parent_scroll", value = value.restrictParentScroll)
            data.writeExpression(key = "reuse_id", value = value.reuseId)
            data.writeExpression(key = "row_span", value = value.rowSpan)
            data.write(key = "selected_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.selectedActions))
            data.write(key = "tooltips", value = component.divTooltipJsonEntityParser.value.serialize(context, value.tooltips))
            data.write(key = "transform", value = component.divTransformJsonEntityParser.value.serialize(context, value.transform))
            data.write(key = "transition_change", value = component.divChangeTransitionJsonEntityParser.value.serialize(context, value.transitionChange))
            data.write(key = "transition_in", value = component.divAppearanceTransitionJsonEntityParser.value.serialize(context, value.transitionIn))
            data.write(key = "transition_out", value = component.divAppearanceTransitionJsonEntityParser.value.serialize(context, value.transitionOut))
            data.write(key = "transition_triggers", value = value.transitionTriggers, converter = DivTransitionTrigger.TO_STRING)
            data.write(key = "type", value = DivPager.TYPE)
            data.write(key = "variable_triggers", value = component.divTriggerJsonEntityParser.value.serialize(context, value.variableTriggers))
            data.write(key = "variables", value = component.divVariableJsonEntityParser.value.serialize(context, value.variables))
            data.writeExpression(key = "visibility", value = value.visibility, converter = DivVisibility.TO_STRING)
            data.write(key = "visibility_action", value = component.divVisibilityActionJsonEntityParser.value.serialize(context, value.visibilityAction))
            data.write(key = "visibility_actions", value = component.divVisibilityActionJsonEntityParser.value.serialize(context, value.visibilityActions))
            data.write(key = "width", value = component.divSizeJsonEntityParser.value.serialize(context, value.width))
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivPagerTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivPagerTemplate?, data: JSONObject): DivPagerTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivPagerTemplate(
                accessibility = JsonFieldParser.readOptionalField(context, logger, data, "accessibility", allowOverride, parent?.accessibility, component.divAccessibilityJsonTemplateParser),
                alignmentHorizontal = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, allowOverride, parent?.alignmentHorizontal, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, allowOverride, parent?.alignmentVertical, DivAlignmentVertical.FROM_STRING),
                alpha = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alpha", TYPE_HELPER_DOUBLE, allowOverride, parent?.alpha, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR),
                animators = JsonFieldParser.readOptionalListField(context, logger, data, "animators", allowOverride, parent?.animators, component.divAnimatorJsonTemplateParser),
                background = JsonFieldParser.readOptionalListField(context, logger, data, "background", allowOverride, parent?.background, component.divBackgroundJsonTemplateParser),
                border = JsonFieldParser.readOptionalField(context, logger, data, "border", allowOverride, parent?.border, component.divBorderJsonTemplateParser),
                columnSpan = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "column_span", TYPE_HELPER_INT, allowOverride, parent?.columnSpan, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                defaultItem = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "default_item", TYPE_HELPER_INT, allowOverride, parent?.defaultItem, NUMBER_TO_INT, DEFAULT_ITEM_VALIDATOR),
                disappearActions = JsonFieldParser.readOptionalListField(context, logger, data, "disappear_actions", allowOverride, parent?.disappearActions, component.divDisappearActionJsonTemplateParser),
                extensions = JsonFieldParser.readOptionalListField(context, logger, data, "extensions", allowOverride, parent?.extensions, component.divExtensionJsonTemplateParser),
                focus = JsonFieldParser.readOptionalField(context, logger, data, "focus", allowOverride, parent?.focus, component.divFocusJsonTemplateParser),
                functions = JsonFieldParser.readOptionalListField(context, logger, data, "functions", allowOverride, parent?.functions, component.divFunctionJsonTemplateParser),
                height = JsonFieldParser.readOptionalField(context, logger, data, "height", allowOverride, parent?.height, component.divSizeJsonTemplateParser),
                id = JsonFieldParser.readOptionalField(context, logger, data, "id", allowOverride, parent?.id),
                infiniteScroll = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "infinite_scroll", TYPE_HELPER_BOOLEAN, allowOverride, parent?.infiniteScroll, ANY_TO_BOOLEAN),
                itemBuilder = JsonFieldParser.readOptionalField(context, logger, data, "item_builder", allowOverride, parent?.itemBuilder, component.divCollectionItemBuilderJsonTemplateParser),
                itemSpacing = JsonFieldParser.readOptionalField(context, logger, data, "item_spacing", allowOverride, parent?.itemSpacing, component.divFixedSizeJsonTemplateParser),
                items = JsonFieldParser.readOptionalListField(context, logger, data, "items", allowOverride, parent?.items, component.divJsonTemplateParser),
                layoutMode = JsonFieldParser.readField(context, logger, data, "layout_mode", allowOverride, parent?.layoutMode, component.divPagerLayoutModeJsonTemplateParser),
                layoutProvider = JsonFieldParser.readOptionalField(context, logger, data, "layout_provider", allowOverride, parent?.layoutProvider, component.divLayoutProviderJsonTemplateParser),
                margins = JsonFieldParser.readOptionalField(context, logger, data, "margins", allowOverride, parent?.margins, component.divEdgeInsetsJsonTemplateParser),
                orientation = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "orientation", TYPE_HELPER_ORIENTATION, allowOverride, parent?.orientation, DivPager.Orientation.FROM_STRING),
                paddings = JsonFieldParser.readOptionalField(context, logger, data, "paddings", allowOverride, parent?.paddings, component.divEdgeInsetsJsonTemplateParser),
                pageTransformation = JsonFieldParser.readOptionalField(context, logger, data, "page_transformation", allowOverride, parent?.pageTransformation, component.divPageTransformationJsonTemplateParser),
                restrictParentScroll = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "restrict_parent_scroll", TYPE_HELPER_BOOLEAN, allowOverride, parent?.restrictParentScroll, ANY_TO_BOOLEAN),
                reuseId = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "reuse_id", TYPE_HELPER_STRING, allowOverride, parent?.reuseId),
                rowSpan = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "row_span", TYPE_HELPER_INT, allowOverride, parent?.rowSpan, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectedActions = JsonFieldParser.readOptionalListField(context, logger, data, "selected_actions", allowOverride, parent?.selectedActions, component.divActionJsonTemplateParser),
                tooltips = JsonFieldParser.readOptionalListField(context, logger, data, "tooltips", allowOverride, parent?.tooltips, component.divTooltipJsonTemplateParser),
                transform = JsonFieldParser.readOptionalField(context, logger, data, "transform", allowOverride, parent?.transform, component.divTransformJsonTemplateParser),
                transitionChange = JsonFieldParser.readOptionalField(context, logger, data, "transition_change", allowOverride, parent?.transitionChange, component.divChangeTransitionJsonTemplateParser),
                transitionIn = JsonFieldParser.readOptionalField(context, logger, data, "transition_in", allowOverride, parent?.transitionIn, component.divAppearanceTransitionJsonTemplateParser),
                transitionOut = JsonFieldParser.readOptionalField(context, logger, data, "transition_out", allowOverride, parent?.transitionOut, component.divAppearanceTransitionJsonTemplateParser),
                transitionTriggers = JsonFieldParser.readOptionalListField(context, logger, data, "transition_triggers", allowOverride, parent?.transitionTriggers, DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR.cast()),
                variableTriggers = JsonFieldParser.readOptionalListField(context, logger, data, "variable_triggers", allowOverride, parent?.variableTriggers, component.divTriggerJsonTemplateParser),
                variables = JsonFieldParser.readOptionalListField(context, logger, data, "variables", allowOverride, parent?.variables, component.divVariableJsonTemplateParser),
                visibility = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "visibility", TYPE_HELPER_VISIBILITY, allowOverride, parent?.visibility, DivVisibility.FROM_STRING),
                visibilityAction = JsonFieldParser.readOptionalField(context, logger, data, "visibility_action", allowOverride, parent?.visibilityAction, component.divVisibilityActionJsonTemplateParser),
                visibilityActions = JsonFieldParser.readOptionalListField(context, logger, data, "visibility_actions", allowOverride, parent?.visibilityActions, component.divVisibilityActionJsonTemplateParser),
                width = JsonFieldParser.readOptionalField(context, logger, data, "width", allowOverride, parent?.width, component.divSizeJsonTemplateParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivPagerTemplate): JSONObject {
            val data = JSONObject()
            data.writeField(key = "accessibility", field = value.accessibility, converter = component.divAccessibilityJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "alignment_horizontal", field = value.alignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeFieldWithExpression(key = "alignment_vertical", field = value.alignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeFieldWithExpression(key = "alpha", field = value.alpha)
            data.writeField(key = "animators", field = value.animators, converter = component.divAnimatorJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "background", field = value.background, converter = component.divBackgroundJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "border", field = value.border, converter = component.divBorderJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "column_span", field = value.columnSpan)
            data.writeFieldWithExpression(key = "default_item", field = value.defaultItem)
            data.writeField(key = "disappear_actions", field = value.disappearActions, converter = component.divDisappearActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "extensions", field = value.extensions, converter = component.divExtensionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "focus", field = value.focus, converter = component.divFocusJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "functions", field = value.functions, converter = component.divFunctionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "height", field = value.height, converter = component.divSizeJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "id", field = value.id)
            data.writeFieldWithExpression(key = "infinite_scroll", field = value.infiniteScroll)
            data.writeField(key = "item_builder", field = value.itemBuilder, converter = component.divCollectionItemBuilderJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "item_spacing", field = value.itemSpacing, converter = component.divFixedSizeJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "items", field = value.items, converter = component.divJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "layout_mode", field = value.layoutMode, converter = component.divPagerLayoutModeJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "layout_provider", field = value.layoutProvider, converter = component.divLayoutProviderJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "margins", field = value.margins, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "orientation", field = value.orientation, converter = DivPager.Orientation.TO_STRING)
            data.writeField(key = "paddings", field = value.paddings, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "page_transformation", field = value.pageTransformation, converter = component.divPageTransformationJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "restrict_parent_scroll", field = value.restrictParentScroll)
            data.writeFieldWithExpression(key = "reuse_id", field = value.reuseId)
            data.writeFieldWithExpression(key = "row_span", field = value.rowSpan)
            data.writeField(key = "selected_actions", field = value.selectedActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "tooltips", field = value.tooltips, converter = component.divTooltipJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transform", field = value.transform, converter = component.divTransformJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_change", field = value.transitionChange, converter = component.divChangeTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_in", field = value.transitionIn, converter = component.divAppearanceTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_out", field = value.transitionOut, converter = component.divAppearanceTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_triggers", field = value.transitionTriggers, converter = DivTransitionTrigger.TO_STRING)
            data.write(key = "type", value = DivPager.TYPE)
            data.writeField(key = "variable_triggers", field = value.variableTriggers, converter = component.divTriggerJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "variables", field = value.variables, converter = component.divVariableJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "visibility", field = value.visibility, converter = DivVisibility.TO_STRING)
            data.writeField(key = "visibility_action", field = value.visibilityAction, converter = component.divVisibilityActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "visibility_actions", field = value.visibilityActions, converter = component.divVisibilityActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "width", field = value.width, converter = component.divSizeJsonTemplateParser.value.asConverter(context))
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivPagerTemplate, DivPager> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivPagerTemplate, data: JSONObject): DivPager {
            val logger = context.logger
            return DivPager(
                accessibility = JsonFieldResolver.resolveOptional(context, logger, template.accessibility, data, "accessibility", component.divAccessibilityJsonTemplateResolver, component.divAccessibilityJsonEntityParser),
                alignmentHorizontal = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alignmentHorizontal, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alignmentVertical, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING),
                alpha = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alpha, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                animators = JsonFieldResolver.resolveOptionalList(context, logger, template.animators, data, "animators", component.divAnimatorJsonTemplateResolver, component.divAnimatorJsonEntityParser),
                background = JsonFieldResolver.resolveOptionalList(context, logger, template.background, data, "background", component.divBackgroundJsonTemplateResolver, component.divBackgroundJsonEntityParser),
                border = JsonFieldResolver.resolveOptional(context, logger, template.border, data, "border", component.divBorderJsonTemplateResolver, component.divBorderJsonEntityParser),
                columnSpan = JsonFieldResolver.resolveOptionalExpression(context, logger, template.columnSpan, data, "column_span", TYPE_HELPER_INT, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                defaultItem = JsonFieldResolver.resolveOptionalExpression(context, logger, template.defaultItem, data, "default_item", TYPE_HELPER_INT, NUMBER_TO_INT, DEFAULT_ITEM_VALIDATOR, DEFAULT_ITEM_DEFAULT_VALUE) ?: DEFAULT_ITEM_DEFAULT_VALUE,
                disappearActions = JsonFieldResolver.resolveOptionalList(context, logger, template.disappearActions, data, "disappear_actions", component.divDisappearActionJsonTemplateResolver, component.divDisappearActionJsonEntityParser),
                extensions = JsonFieldResolver.resolveOptionalList(context, logger, template.extensions, data, "extensions", component.divExtensionJsonTemplateResolver, component.divExtensionJsonEntityParser),
                focus = JsonFieldResolver.resolveOptional(context, logger, template.focus, data, "focus", component.divFocusJsonTemplateResolver, component.divFocusJsonEntityParser),
                functions = JsonFieldResolver.resolveOptionalList(context, logger, template.functions, data, "functions", component.divFunctionJsonTemplateResolver, component.divFunctionJsonEntityParser),
                height = JsonFieldResolver.resolveOptional(context, logger, template.height, data, "height", component.divSizeJsonTemplateResolver, component.divSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonFieldResolver.resolveOptional(context, logger, template.id, data, "id"),
                infiniteScroll = JsonFieldResolver.resolveOptionalExpression(context, logger, template.infiniteScroll, data, "infinite_scroll", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, INFINITE_SCROLL_DEFAULT_VALUE) ?: INFINITE_SCROLL_DEFAULT_VALUE,
                itemBuilder = JsonFieldResolver.resolveOptional(context, logger, template.itemBuilder, data, "item_builder", component.divCollectionItemBuilderJsonTemplateResolver, component.divCollectionItemBuilderJsonEntityParser),
                itemSpacing = JsonFieldResolver.resolveOptional(context, logger, template.itemSpacing, data, "item_spacing", component.divFixedSizeJsonTemplateResolver, component.divFixedSizeJsonEntityParser) ?: ITEM_SPACING_DEFAULT_VALUE,
                items = JsonFieldResolver.resolveOptionalList(context, logger, template.items, data, "items", component.divJsonTemplateResolver, component.divJsonEntityParser),
                layoutMode = JsonFieldResolver.resolve(context, logger, template.layoutMode, data, "layout_mode", component.divPagerLayoutModeJsonTemplateResolver, component.divPagerLayoutModeJsonEntityParser),
                layoutProvider = JsonFieldResolver.resolveOptional(context, logger, template.layoutProvider, data, "layout_provider", component.divLayoutProviderJsonTemplateResolver, component.divLayoutProviderJsonEntityParser),
                margins = JsonFieldResolver.resolveOptional(context, logger, template.margins, data, "margins", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                orientation = JsonFieldResolver.resolveOptionalExpression(context, logger, template.orientation, data, "orientation", TYPE_HELPER_ORIENTATION, DivPager.Orientation.FROM_STRING, ORIENTATION_DEFAULT_VALUE) ?: ORIENTATION_DEFAULT_VALUE,
                paddings = JsonFieldResolver.resolveOptional(context, logger, template.paddings, data, "paddings", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                pageTransformation = JsonFieldResolver.resolveOptional(context, logger, template.pageTransformation, data, "page_transformation", component.divPageTransformationJsonTemplateResolver, component.divPageTransformationJsonEntityParser),
                restrictParentScroll = JsonFieldResolver.resolveOptionalExpression(context, logger, template.restrictParentScroll, data, "restrict_parent_scroll", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, RESTRICT_PARENT_SCROLL_DEFAULT_VALUE) ?: RESTRICT_PARENT_SCROLL_DEFAULT_VALUE,
                reuseId = JsonFieldResolver.resolveOptionalExpression(context, logger, template.reuseId, data, "reuse_id", TYPE_HELPER_STRING),
                rowSpan = JsonFieldResolver.resolveOptionalExpression(context, logger, template.rowSpan, data, "row_span", TYPE_HELPER_INT, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectedActions = JsonFieldResolver.resolveOptionalList(context, logger, template.selectedActions, data, "selected_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                tooltips = JsonFieldResolver.resolveOptionalList(context, logger, template.tooltips, data, "tooltips", component.divTooltipJsonTemplateResolver, component.divTooltipJsonEntityParser),
                transform = JsonFieldResolver.resolveOptional(context, logger, template.transform, data, "transform", component.divTransformJsonTemplateResolver, component.divTransformJsonEntityParser),
                transitionChange = JsonFieldResolver.resolveOptional(context, logger, template.transitionChange, data, "transition_change", component.divChangeTransitionJsonTemplateResolver, component.divChangeTransitionJsonEntityParser),
                transitionIn = JsonFieldResolver.resolveOptional(context, logger, template.transitionIn, data, "transition_in", component.divAppearanceTransitionJsonTemplateResolver, component.divAppearanceTransitionJsonEntityParser),
                transitionOut = JsonFieldResolver.resolveOptional(context, logger, template.transitionOut, data, "transition_out", component.divAppearanceTransitionJsonTemplateResolver, component.divAppearanceTransitionJsonEntityParser),
                transitionTriggers = JsonFieldResolver.resolveOptionalList(context, logger, template.transitionTriggers, data, "transition_triggers", DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR),
                variableTriggers = JsonFieldResolver.resolveOptionalList(context, logger, template.variableTriggers, data, "variable_triggers", component.divTriggerJsonTemplateResolver, component.divTriggerJsonEntityParser),
                variables = JsonFieldResolver.resolveOptionalList(context, logger, template.variables, data, "variables", component.divVariableJsonTemplateResolver, component.divVariableJsonEntityParser),
                visibility = JsonFieldResolver.resolveOptionalExpression(context, logger, template.visibility, data, "visibility", TYPE_HELPER_VISIBILITY, DivVisibility.FROM_STRING, VISIBILITY_DEFAULT_VALUE) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonFieldResolver.resolveOptional(context, logger, template.visibilityAction, data, "visibility_action", component.divVisibilityActionJsonTemplateResolver, component.divVisibilityActionJsonEntityParser),
                visibilityActions = JsonFieldResolver.resolveOptionalList(context, logger, template.visibilityActions, data, "visibility_actions", component.divVisibilityActionJsonTemplateResolver, component.divVisibilityActionJsonEntityParser),
                width = JsonFieldResolver.resolveOptional(context, logger, template.width, data, "width", component.divSizeJsonTemplateResolver, component.divSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }
    }

    private companion object {

        @JvmField val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        @JvmField val DEFAULT_ITEM_DEFAULT_VALUE = Expression.constant(0L)
        @JvmField val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        @JvmField val INFINITE_SCROLL_DEFAULT_VALUE = Expression.constant(false)
        @JvmField val ITEM_SPACING_DEFAULT_VALUE = DivFixedSize(value = Expression.constant(0L))
        @JvmField val ORIENTATION_DEFAULT_VALUE = Expression.constant(DivPager.Orientation.HORIZONTAL)
        @JvmField val RESTRICT_PARENT_SCROLL_DEFAULT_VALUE = Expression.constant(false)
        @JvmField val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        @JvmField val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        @JvmField val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        @JvmField val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        @JvmField val TYPE_HELPER_ORIENTATION = TypeHelper.from(default = DivPager.Orientation.values().first()) { it is DivPager.Orientation }
        @JvmField val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmField val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        @JvmField val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val DEFAULT_ITEM_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
    }
}
