// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivSliderJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivSlider> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivSlider {
            val logger = context.logger
            return DivSlider(
                accessibility = JsonPropertyParser.readOptional(context, logger, data, "accessibility", component.divAccessibilityJsonEntityParser),
                alignmentHorizontal = JsonExpressionParser.readOptionalExpression(context, logger, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonExpressionParser.readOptionalExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING),
                alpha = JsonExpressionParser.readOptionalExpression(context, logger, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                animators = JsonPropertyParser.readOptionalList(context, logger, data, "animators", component.divAnimatorJsonEntityParser),
                background = JsonPropertyParser.readOptionalList(context, logger, data, "background", component.divBackgroundJsonEntityParser),
                border = JsonPropertyParser.readOptional(context, logger, data, "border", component.divBorderJsonEntityParser),
                columnSpan = JsonExpressionParser.readOptionalExpression(context, logger, data, "column_span", TYPE_HELPER_INT, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                disappearActions = JsonPropertyParser.readOptionalList(context, logger, data, "disappear_actions", component.divDisappearActionJsonEntityParser),
                extensions = JsonPropertyParser.readOptionalList(context, logger, data, "extensions", component.divExtensionJsonEntityParser),
                focus = JsonPropertyParser.readOptional(context, logger, data, "focus", component.divFocusJsonEntityParser),
                functions = JsonPropertyParser.readOptionalList(context, logger, data, "functions", component.divFunctionJsonEntityParser),
                height = JsonPropertyParser.readOptional(context, logger, data, "height", component.divSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonPropertyParser.readOptional(context, logger, data, "id"),
                layoutProvider = JsonPropertyParser.readOptional(context, logger, data, "layout_provider", component.divLayoutProviderJsonEntityParser),
                margins = JsonPropertyParser.readOptional(context, logger, data, "margins", component.divEdgeInsetsJsonEntityParser),
                maxValue = JsonExpressionParser.readOptionalExpression(context, logger, data, "max_value", TYPE_HELPER_INT, NUMBER_TO_INT, MAX_VALUE_DEFAULT_VALUE) ?: MAX_VALUE_DEFAULT_VALUE,
                minValue = JsonExpressionParser.readOptionalExpression(context, logger, data, "min_value", TYPE_HELPER_INT, NUMBER_TO_INT, MIN_VALUE_DEFAULT_VALUE) ?: MIN_VALUE_DEFAULT_VALUE,
                paddings = JsonPropertyParser.readOptional(context, logger, data, "paddings", component.divEdgeInsetsJsonEntityParser),
                ranges = JsonPropertyParser.readOptionalList(context, logger, data, "ranges", component.divSliderRangeJsonEntityParser),
                reuseId = JsonExpressionParser.readOptionalExpression(context, logger, data, "reuse_id", TYPE_HELPER_STRING),
                rowSpan = JsonExpressionParser.readOptionalExpression(context, logger, data, "row_span", TYPE_HELPER_INT, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                secondaryValueAccessibility = JsonPropertyParser.readOptional(context, logger, data, "secondary_value_accessibility", component.divAccessibilityJsonEntityParser),
                selectedActions = JsonPropertyParser.readOptionalList(context, logger, data, "selected_actions", component.divActionJsonEntityParser),
                thumbSecondaryStyle = JsonPropertyParser.readOptional(context, logger, data, "thumb_secondary_style", component.divDrawableJsonEntityParser),
                thumbSecondaryTextStyle = JsonPropertyParser.readOptional(context, logger, data, "thumb_secondary_text_style", component.divSliderTextStyleJsonEntityParser),
                thumbSecondaryValueVariable = JsonPropertyParser.readOptional(context, logger, data, "thumb_secondary_value_variable"),
                thumbStyle = JsonPropertyParser.read(context, logger, data, "thumb_style", component.divDrawableJsonEntityParser),
                thumbTextStyle = JsonPropertyParser.readOptional(context, logger, data, "thumb_text_style", component.divSliderTextStyleJsonEntityParser),
                thumbValueVariable = JsonPropertyParser.readOptional(context, logger, data, "thumb_value_variable"),
                tickMarkActiveStyle = JsonPropertyParser.readOptional(context, logger, data, "tick_mark_active_style", component.divDrawableJsonEntityParser),
                tickMarkInactiveStyle = JsonPropertyParser.readOptional(context, logger, data, "tick_mark_inactive_style", component.divDrawableJsonEntityParser),
                tooltips = JsonPropertyParser.readOptionalList(context, logger, data, "tooltips", component.divTooltipJsonEntityParser),
                trackActiveStyle = JsonPropertyParser.read(context, logger, data, "track_active_style", component.divDrawableJsonEntityParser),
                trackInactiveStyle = JsonPropertyParser.read(context, logger, data, "track_inactive_style", component.divDrawableJsonEntityParser),
                transform = JsonPropertyParser.readOptional(context, logger, data, "transform", component.divTransformJsonEntityParser),
                transitionChange = JsonPropertyParser.readOptional(context, logger, data, "transition_change", component.divChangeTransitionJsonEntityParser),
                transitionIn = JsonPropertyParser.readOptional(context, logger, data, "transition_in", component.divAppearanceTransitionJsonEntityParser),
                transitionOut = JsonPropertyParser.readOptional(context, logger, data, "transition_out", component.divAppearanceTransitionJsonEntityParser),
                transitionTriggers = JsonPropertyParser.readOptionalList(context, logger, data, "transition_triggers", DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR),
                variableTriggers = JsonPropertyParser.readOptionalList(context, logger, data, "variable_triggers", component.divTriggerJsonEntityParser),
                variables = JsonPropertyParser.readOptionalList(context, logger, data, "variables", component.divVariableJsonEntityParser),
                visibility = JsonExpressionParser.readOptionalExpression(context, logger, data, "visibility", TYPE_HELPER_VISIBILITY, DivVisibility.FROM_STRING, VISIBILITY_DEFAULT_VALUE) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonPropertyParser.readOptional(context, logger, data, "visibility_action", component.divVisibilityActionJsonEntityParser),
                visibilityActions = JsonPropertyParser.readOptionalList(context, logger, data, "visibility_actions", component.divVisibilityActionJsonEntityParser),
                width = JsonPropertyParser.readOptional(context, logger, data, "width", component.divSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivSlider): JSONObject {
            val data = JSONObject()
            data.write(key = "accessibility", value = component.divAccessibilityJsonEntityParser.value.serialize(context, value.accessibility))
            data.writeExpression(key = "alignment_horizontal", value = value.alignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeExpression(key = "alignment_vertical", value = value.alignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeExpression(key = "alpha", value = value.alpha)
            data.write(key = "animators", value = component.divAnimatorJsonEntityParser.value.serialize(context, value.animators))
            data.write(key = "background", value = component.divBackgroundJsonEntityParser.value.serialize(context, value.background))
            data.write(key = "border", value = component.divBorderJsonEntityParser.value.serialize(context, value.border))
            data.writeExpression(key = "column_span", value = value.columnSpan)
            data.write(key = "disappear_actions", value = component.divDisappearActionJsonEntityParser.value.serialize(context, value.disappearActions))
            data.write(key = "extensions", value = component.divExtensionJsonEntityParser.value.serialize(context, value.extensions))
            data.write(key = "focus", value = component.divFocusJsonEntityParser.value.serialize(context, value.focus))
            data.write(key = "functions", value = component.divFunctionJsonEntityParser.value.serialize(context, value.functions))
            data.write(key = "height", value = component.divSizeJsonEntityParser.value.serialize(context, value.height))
            data.write(key = "id", value = value.id)
            data.write(key = "layout_provider", value = component.divLayoutProviderJsonEntityParser.value.serialize(context, value.layoutProvider))
            data.write(key = "margins", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.margins))
            data.writeExpression(key = "max_value", value = value.maxValue)
            data.writeExpression(key = "min_value", value = value.minValue)
            data.write(key = "paddings", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.paddings))
            data.write(key = "ranges", value = component.divSliderRangeJsonEntityParser.value.serialize(context, value.ranges))
            data.writeExpression(key = "reuse_id", value = value.reuseId)
            data.writeExpression(key = "row_span", value = value.rowSpan)
            data.write(key = "secondary_value_accessibility", value = component.divAccessibilityJsonEntityParser.value.serialize(context, value.secondaryValueAccessibility))
            data.write(key = "selected_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.selectedActions))
            data.write(key = "thumb_secondary_style", value = component.divDrawableJsonEntityParser.value.serialize(context, value.thumbSecondaryStyle))
            data.write(key = "thumb_secondary_text_style", value = component.divSliderTextStyleJsonEntityParser.value.serialize(context, value.thumbSecondaryTextStyle))
            data.write(key = "thumb_secondary_value_variable", value = value.thumbSecondaryValueVariable)
            data.write(key = "thumb_style", value = component.divDrawableJsonEntityParser.value.serialize(context, value.thumbStyle))
            data.write(key = "thumb_text_style", value = component.divSliderTextStyleJsonEntityParser.value.serialize(context, value.thumbTextStyle))
            data.write(key = "thumb_value_variable", value = value.thumbValueVariable)
            data.write(key = "tick_mark_active_style", value = component.divDrawableJsonEntityParser.value.serialize(context, value.tickMarkActiveStyle))
            data.write(key = "tick_mark_inactive_style", value = component.divDrawableJsonEntityParser.value.serialize(context, value.tickMarkInactiveStyle))
            data.write(key = "tooltips", value = component.divTooltipJsonEntityParser.value.serialize(context, value.tooltips))
            data.write(key = "track_active_style", value = component.divDrawableJsonEntityParser.value.serialize(context, value.trackActiveStyle))
            data.write(key = "track_inactive_style", value = component.divDrawableJsonEntityParser.value.serialize(context, value.trackInactiveStyle))
            data.write(key = "transform", value = component.divTransformJsonEntityParser.value.serialize(context, value.transform))
            data.write(key = "transition_change", value = component.divChangeTransitionJsonEntityParser.value.serialize(context, value.transitionChange))
            data.write(key = "transition_in", value = component.divAppearanceTransitionJsonEntityParser.value.serialize(context, value.transitionIn))
            data.write(key = "transition_out", value = component.divAppearanceTransitionJsonEntityParser.value.serialize(context, value.transitionOut))
            data.write(key = "transition_triggers", value = value.transitionTriggers, converter = DivTransitionTrigger.TO_STRING)
            data.write(key = "type", value = DivSlider.TYPE)
            data.write(key = "variable_triggers", value = component.divTriggerJsonEntityParser.value.serialize(context, value.variableTriggers))
            data.write(key = "variables", value = component.divVariableJsonEntityParser.value.serialize(context, value.variables))
            data.writeExpression(key = "visibility", value = value.visibility, converter = DivVisibility.TO_STRING)
            data.write(key = "visibility_action", value = component.divVisibilityActionJsonEntityParser.value.serialize(context, value.visibilityAction))
            data.write(key = "visibility_actions", value = component.divVisibilityActionJsonEntityParser.value.serialize(context, value.visibilityActions))
            data.write(key = "width", value = component.divSizeJsonEntityParser.value.serialize(context, value.width))
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivSliderTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivSliderTemplate?, data: JSONObject): DivSliderTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivSliderTemplate(
                accessibility = JsonFieldParser.readOptionalField(context, logger, data, "accessibility", allowOverride, parent?.accessibility, component.divAccessibilityJsonTemplateParser),
                alignmentHorizontal = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, allowOverride, parent?.alignmentHorizontal, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, allowOverride, parent?.alignmentVertical, DivAlignmentVertical.FROM_STRING),
                alpha = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alpha", TYPE_HELPER_DOUBLE, allowOverride, parent?.alpha, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR),
                animators = JsonFieldParser.readOptionalListField(context, logger, data, "animators", allowOverride, parent?.animators, component.divAnimatorJsonTemplateParser),
                background = JsonFieldParser.readOptionalListField(context, logger, data, "background", allowOverride, parent?.background, component.divBackgroundJsonTemplateParser),
                border = JsonFieldParser.readOptionalField(context, logger, data, "border", allowOverride, parent?.border, component.divBorderJsonTemplateParser),
                columnSpan = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "column_span", TYPE_HELPER_INT, allowOverride, parent?.columnSpan, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                disappearActions = JsonFieldParser.readOptionalListField(context, logger, data, "disappear_actions", allowOverride, parent?.disappearActions, component.divDisappearActionJsonTemplateParser),
                extensions = JsonFieldParser.readOptionalListField(context, logger, data, "extensions", allowOverride, parent?.extensions, component.divExtensionJsonTemplateParser),
                focus = JsonFieldParser.readOptionalField(context, logger, data, "focus", allowOverride, parent?.focus, component.divFocusJsonTemplateParser),
                functions = JsonFieldParser.readOptionalListField(context, logger, data, "functions", allowOverride, parent?.functions, component.divFunctionJsonTemplateParser),
                height = JsonFieldParser.readOptionalField(context, logger, data, "height", allowOverride, parent?.height, component.divSizeJsonTemplateParser),
                id = JsonFieldParser.readOptionalField(context, logger, data, "id", allowOverride, parent?.id),
                layoutProvider = JsonFieldParser.readOptionalField(context, logger, data, "layout_provider", allowOverride, parent?.layoutProvider, component.divLayoutProviderJsonTemplateParser),
                margins = JsonFieldParser.readOptionalField(context, logger, data, "margins", allowOverride, parent?.margins, component.divEdgeInsetsJsonTemplateParser),
                maxValue = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "max_value", TYPE_HELPER_INT, allowOverride, parent?.maxValue, NUMBER_TO_INT),
                minValue = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "min_value", TYPE_HELPER_INT, allowOverride, parent?.minValue, NUMBER_TO_INT),
                paddings = JsonFieldParser.readOptionalField(context, logger, data, "paddings", allowOverride, parent?.paddings, component.divEdgeInsetsJsonTemplateParser),
                ranges = JsonFieldParser.readOptionalListField(context, logger, data, "ranges", allowOverride, parent?.ranges, component.divSliderRangeJsonTemplateParser),
                reuseId = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "reuse_id", TYPE_HELPER_STRING, allowOverride, parent?.reuseId),
                rowSpan = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "row_span", TYPE_HELPER_INT, allowOverride, parent?.rowSpan, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                secondaryValueAccessibility = JsonFieldParser.readOptionalField(context, logger, data, "secondary_value_accessibility", allowOverride, parent?.secondaryValueAccessibility, component.divAccessibilityJsonTemplateParser),
                selectedActions = JsonFieldParser.readOptionalListField(context, logger, data, "selected_actions", allowOverride, parent?.selectedActions, component.divActionJsonTemplateParser),
                thumbSecondaryStyle = JsonFieldParser.readOptionalField(context, logger, data, "thumb_secondary_style", allowOverride, parent?.thumbSecondaryStyle, component.divDrawableJsonTemplateParser),
                thumbSecondaryTextStyle = JsonFieldParser.readOptionalField(context, logger, data, "thumb_secondary_text_style", allowOverride, parent?.thumbSecondaryTextStyle, component.divSliderTextStyleJsonTemplateParser),
                thumbSecondaryValueVariable = JsonFieldParser.readOptionalField(context, logger, data, "thumb_secondary_value_variable", allowOverride, parent?.thumbSecondaryValueVariable),
                thumbStyle = JsonFieldParser.readField(context, logger, data, "thumb_style", allowOverride, parent?.thumbStyle, component.divDrawableJsonTemplateParser),
                thumbTextStyle = JsonFieldParser.readOptionalField(context, logger, data, "thumb_text_style", allowOverride, parent?.thumbTextStyle, component.divSliderTextStyleJsonTemplateParser),
                thumbValueVariable = JsonFieldParser.readOptionalField(context, logger, data, "thumb_value_variable", allowOverride, parent?.thumbValueVariable),
                tickMarkActiveStyle = JsonFieldParser.readOptionalField(context, logger, data, "tick_mark_active_style", allowOverride, parent?.tickMarkActiveStyle, component.divDrawableJsonTemplateParser),
                tickMarkInactiveStyle = JsonFieldParser.readOptionalField(context, logger, data, "tick_mark_inactive_style", allowOverride, parent?.tickMarkInactiveStyle, component.divDrawableJsonTemplateParser),
                tooltips = JsonFieldParser.readOptionalListField(context, logger, data, "tooltips", allowOverride, parent?.tooltips, component.divTooltipJsonTemplateParser),
                trackActiveStyle = JsonFieldParser.readField(context, logger, data, "track_active_style", allowOverride, parent?.trackActiveStyle, component.divDrawableJsonTemplateParser),
                trackInactiveStyle = JsonFieldParser.readField(context, logger, data, "track_inactive_style", allowOverride, parent?.trackInactiveStyle, component.divDrawableJsonTemplateParser),
                transform = JsonFieldParser.readOptionalField(context, logger, data, "transform", allowOverride, parent?.transform, component.divTransformJsonTemplateParser),
                transitionChange = JsonFieldParser.readOptionalField(context, logger, data, "transition_change", allowOverride, parent?.transitionChange, component.divChangeTransitionJsonTemplateParser),
                transitionIn = JsonFieldParser.readOptionalField(context, logger, data, "transition_in", allowOverride, parent?.transitionIn, component.divAppearanceTransitionJsonTemplateParser),
                transitionOut = JsonFieldParser.readOptionalField(context, logger, data, "transition_out", allowOverride, parent?.transitionOut, component.divAppearanceTransitionJsonTemplateParser),
                transitionTriggers = JsonFieldParser.readOptionalListField(context, logger, data, "transition_triggers", allowOverride, parent?.transitionTriggers, DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR.cast()),
                variableTriggers = JsonFieldParser.readOptionalListField(context, logger, data, "variable_triggers", allowOverride, parent?.variableTriggers, component.divTriggerJsonTemplateParser),
                variables = JsonFieldParser.readOptionalListField(context, logger, data, "variables", allowOverride, parent?.variables, component.divVariableJsonTemplateParser),
                visibility = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "visibility", TYPE_HELPER_VISIBILITY, allowOverride, parent?.visibility, DivVisibility.FROM_STRING),
                visibilityAction = JsonFieldParser.readOptionalField(context, logger, data, "visibility_action", allowOverride, parent?.visibilityAction, component.divVisibilityActionJsonTemplateParser),
                visibilityActions = JsonFieldParser.readOptionalListField(context, logger, data, "visibility_actions", allowOverride, parent?.visibilityActions, component.divVisibilityActionJsonTemplateParser),
                width = JsonFieldParser.readOptionalField(context, logger, data, "width", allowOverride, parent?.width, component.divSizeJsonTemplateParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivSliderTemplate): JSONObject {
            val data = JSONObject()
            data.writeField(key = "accessibility", field = value.accessibility, converter = component.divAccessibilityJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "alignment_horizontal", field = value.alignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeFieldWithExpression(key = "alignment_vertical", field = value.alignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeFieldWithExpression(key = "alpha", field = value.alpha)
            data.writeField(key = "animators", field = value.animators, converter = component.divAnimatorJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "background", field = value.background, converter = component.divBackgroundJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "border", field = value.border, converter = component.divBorderJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "column_span", field = value.columnSpan)
            data.writeField(key = "disappear_actions", field = value.disappearActions, converter = component.divDisappearActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "extensions", field = value.extensions, converter = component.divExtensionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "focus", field = value.focus, converter = component.divFocusJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "functions", field = value.functions, converter = component.divFunctionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "height", field = value.height, converter = component.divSizeJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "id", field = value.id)
            data.writeField(key = "layout_provider", field = value.layoutProvider, converter = component.divLayoutProviderJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "margins", field = value.margins, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "max_value", field = value.maxValue)
            data.writeFieldWithExpression(key = "min_value", field = value.minValue)
            data.writeField(key = "paddings", field = value.paddings, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "ranges", field = value.ranges, converter = component.divSliderRangeJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "reuse_id", field = value.reuseId)
            data.writeFieldWithExpression(key = "row_span", field = value.rowSpan)
            data.writeField(key = "secondary_value_accessibility", field = value.secondaryValueAccessibility, converter = component.divAccessibilityJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "selected_actions", field = value.selectedActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "thumb_secondary_style", field = value.thumbSecondaryStyle, converter = component.divDrawableJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "thumb_secondary_text_style", field = value.thumbSecondaryTextStyle, converter = component.divSliderTextStyleJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "thumb_secondary_value_variable", field = value.thumbSecondaryValueVariable)
            data.writeField(key = "thumb_style", field = value.thumbStyle, converter = component.divDrawableJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "thumb_text_style", field = value.thumbTextStyle, converter = component.divSliderTextStyleJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "thumb_value_variable", field = value.thumbValueVariable)
            data.writeField(key = "tick_mark_active_style", field = value.tickMarkActiveStyle, converter = component.divDrawableJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "tick_mark_inactive_style", field = value.tickMarkInactiveStyle, converter = component.divDrawableJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "tooltips", field = value.tooltips, converter = component.divTooltipJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "track_active_style", field = value.trackActiveStyle, converter = component.divDrawableJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "track_inactive_style", field = value.trackInactiveStyle, converter = component.divDrawableJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transform", field = value.transform, converter = component.divTransformJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_change", field = value.transitionChange, converter = component.divChangeTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_in", field = value.transitionIn, converter = component.divAppearanceTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_out", field = value.transitionOut, converter = component.divAppearanceTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_triggers", field = value.transitionTriggers, converter = DivTransitionTrigger.TO_STRING)
            data.write(key = "type", value = DivSlider.TYPE)
            data.writeField(key = "variable_triggers", field = value.variableTriggers, converter = component.divTriggerJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "variables", field = value.variables, converter = component.divVariableJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "visibility", field = value.visibility, converter = DivVisibility.TO_STRING)
            data.writeField(key = "visibility_action", field = value.visibilityAction, converter = component.divVisibilityActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "visibility_actions", field = value.visibilityActions, converter = component.divVisibilityActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "width", field = value.width, converter = component.divSizeJsonTemplateParser.value.asConverter(context))
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivSliderTemplate, DivSlider> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivSliderTemplate, data: JSONObject): DivSlider {
            val logger = context.logger
            return DivSlider(
                accessibility = JsonFieldResolver.resolveOptional(context, logger, template.accessibility, data, "accessibility", component.divAccessibilityJsonTemplateResolver, component.divAccessibilityJsonEntityParser),
                alignmentHorizontal = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alignmentHorizontal, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alignmentVertical, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING),
                alpha = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alpha, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                animators = JsonFieldResolver.resolveOptionalList(context, logger, template.animators, data, "animators", component.divAnimatorJsonTemplateResolver, component.divAnimatorJsonEntityParser),
                background = JsonFieldResolver.resolveOptionalList(context, logger, template.background, data, "background", component.divBackgroundJsonTemplateResolver, component.divBackgroundJsonEntityParser),
                border = JsonFieldResolver.resolveOptional(context, logger, template.border, data, "border", component.divBorderJsonTemplateResolver, component.divBorderJsonEntityParser),
                columnSpan = JsonFieldResolver.resolveOptionalExpression(context, logger, template.columnSpan, data, "column_span", TYPE_HELPER_INT, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                disappearActions = JsonFieldResolver.resolveOptionalList(context, logger, template.disappearActions, data, "disappear_actions", component.divDisappearActionJsonTemplateResolver, component.divDisappearActionJsonEntityParser),
                extensions = JsonFieldResolver.resolveOptionalList(context, logger, template.extensions, data, "extensions", component.divExtensionJsonTemplateResolver, component.divExtensionJsonEntityParser),
                focus = JsonFieldResolver.resolveOptional(context, logger, template.focus, data, "focus", component.divFocusJsonTemplateResolver, component.divFocusJsonEntityParser),
                functions = JsonFieldResolver.resolveOptionalList(context, logger, template.functions, data, "functions", component.divFunctionJsonTemplateResolver, component.divFunctionJsonEntityParser),
                height = JsonFieldResolver.resolveOptional(context, logger, template.height, data, "height", component.divSizeJsonTemplateResolver, component.divSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonFieldResolver.resolveOptional(context, logger, template.id, data, "id"),
                layoutProvider = JsonFieldResolver.resolveOptional(context, logger, template.layoutProvider, data, "layout_provider", component.divLayoutProviderJsonTemplateResolver, component.divLayoutProviderJsonEntityParser),
                margins = JsonFieldResolver.resolveOptional(context, logger, template.margins, data, "margins", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                maxValue = JsonFieldResolver.resolveOptionalExpression(context, logger, template.maxValue, data, "max_value", TYPE_HELPER_INT, NUMBER_TO_INT, MAX_VALUE_DEFAULT_VALUE) ?: MAX_VALUE_DEFAULT_VALUE,
                minValue = JsonFieldResolver.resolveOptionalExpression(context, logger, template.minValue, data, "min_value", TYPE_HELPER_INT, NUMBER_TO_INT, MIN_VALUE_DEFAULT_VALUE) ?: MIN_VALUE_DEFAULT_VALUE,
                paddings = JsonFieldResolver.resolveOptional(context, logger, template.paddings, data, "paddings", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                ranges = JsonFieldResolver.resolveOptionalList(context, logger, template.ranges, data, "ranges", component.divSliderRangeJsonTemplateResolver, component.divSliderRangeJsonEntityParser),
                reuseId = JsonFieldResolver.resolveOptionalExpression(context, logger, template.reuseId, data, "reuse_id", TYPE_HELPER_STRING),
                rowSpan = JsonFieldResolver.resolveOptionalExpression(context, logger, template.rowSpan, data, "row_span", TYPE_HELPER_INT, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                secondaryValueAccessibility = JsonFieldResolver.resolveOptional(context, logger, template.secondaryValueAccessibility, data, "secondary_value_accessibility", component.divAccessibilityJsonTemplateResolver, component.divAccessibilityJsonEntityParser),
                selectedActions = JsonFieldResolver.resolveOptionalList(context, logger, template.selectedActions, data, "selected_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                thumbSecondaryStyle = JsonFieldResolver.resolveOptional(context, logger, template.thumbSecondaryStyle, data, "thumb_secondary_style", component.divDrawableJsonTemplateResolver, component.divDrawableJsonEntityParser),
                thumbSecondaryTextStyle = JsonFieldResolver.resolveOptional(context, logger, template.thumbSecondaryTextStyle, data, "thumb_secondary_text_style", component.divSliderTextStyleJsonTemplateResolver, component.divSliderTextStyleJsonEntityParser),
                thumbSecondaryValueVariable = JsonFieldResolver.resolveOptional(context, logger, template.thumbSecondaryValueVariable, data, "thumb_secondary_value_variable"),
                thumbStyle = JsonFieldResolver.resolve(context, logger, template.thumbStyle, data, "thumb_style", component.divDrawableJsonTemplateResolver, component.divDrawableJsonEntityParser),
                thumbTextStyle = JsonFieldResolver.resolveOptional(context, logger, template.thumbTextStyle, data, "thumb_text_style", component.divSliderTextStyleJsonTemplateResolver, component.divSliderTextStyleJsonEntityParser),
                thumbValueVariable = JsonFieldResolver.resolveOptional(context, logger, template.thumbValueVariable, data, "thumb_value_variable"),
                tickMarkActiveStyle = JsonFieldResolver.resolveOptional(context, logger, template.tickMarkActiveStyle, data, "tick_mark_active_style", component.divDrawableJsonTemplateResolver, component.divDrawableJsonEntityParser),
                tickMarkInactiveStyle = JsonFieldResolver.resolveOptional(context, logger, template.tickMarkInactiveStyle, data, "tick_mark_inactive_style", component.divDrawableJsonTemplateResolver, component.divDrawableJsonEntityParser),
                tooltips = JsonFieldResolver.resolveOptionalList(context, logger, template.tooltips, data, "tooltips", component.divTooltipJsonTemplateResolver, component.divTooltipJsonEntityParser),
                trackActiveStyle = JsonFieldResolver.resolve(context, logger, template.trackActiveStyle, data, "track_active_style", component.divDrawableJsonTemplateResolver, component.divDrawableJsonEntityParser),
                trackInactiveStyle = JsonFieldResolver.resolve(context, logger, template.trackInactiveStyle, data, "track_inactive_style", component.divDrawableJsonTemplateResolver, component.divDrawableJsonEntityParser),
                transform = JsonFieldResolver.resolveOptional(context, logger, template.transform, data, "transform", component.divTransformJsonTemplateResolver, component.divTransformJsonEntityParser),
                transitionChange = JsonFieldResolver.resolveOptional(context, logger, template.transitionChange, data, "transition_change", component.divChangeTransitionJsonTemplateResolver, component.divChangeTransitionJsonEntityParser),
                transitionIn = JsonFieldResolver.resolveOptional(context, logger, template.transitionIn, data, "transition_in", component.divAppearanceTransitionJsonTemplateResolver, component.divAppearanceTransitionJsonEntityParser),
                transitionOut = JsonFieldResolver.resolveOptional(context, logger, template.transitionOut, data, "transition_out", component.divAppearanceTransitionJsonTemplateResolver, component.divAppearanceTransitionJsonEntityParser),
                transitionTriggers = JsonFieldResolver.resolveOptionalList(context, logger, template.transitionTriggers, data, "transition_triggers", DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR),
                variableTriggers = JsonFieldResolver.resolveOptionalList(context, logger, template.variableTriggers, data, "variable_triggers", component.divTriggerJsonTemplateResolver, component.divTriggerJsonEntityParser),
                variables = JsonFieldResolver.resolveOptionalList(context, logger, template.variables, data, "variables", component.divVariableJsonTemplateResolver, component.divVariableJsonEntityParser),
                visibility = JsonFieldResolver.resolveOptionalExpression(context, logger, template.visibility, data, "visibility", TYPE_HELPER_VISIBILITY, DivVisibility.FROM_STRING, VISIBILITY_DEFAULT_VALUE) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonFieldResolver.resolveOptional(context, logger, template.visibilityAction, data, "visibility_action", component.divVisibilityActionJsonTemplateResolver, component.divVisibilityActionJsonEntityParser),
                visibilityActions = JsonFieldResolver.resolveOptionalList(context, logger, template.visibilityActions, data, "visibility_actions", component.divVisibilityActionJsonTemplateResolver, component.divVisibilityActionJsonEntityParser),
                width = JsonFieldResolver.resolveOptional(context, logger, template.width, data, "width", component.divSizeJsonTemplateResolver, component.divSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }
    }

    private companion object {

        @JvmField val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        @JvmField val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        @JvmField val MAX_VALUE_DEFAULT_VALUE = Expression.constant(100L)
        @JvmField val MIN_VALUE_DEFAULT_VALUE = Expression.constant(0L)
        @JvmField val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        @JvmField val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        @JvmField val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        @JvmField val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        @JvmField val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmField val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        @JvmField val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
    }
}

internal class DivSliderTextStyleJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivSlider.TextStyle> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivSlider.TextStyle {
            val logger = context.logger
            return DivSlider.TextStyle(
                fontSize = JsonExpressionParser.readExpression(context, logger, data, "font_size", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_SIZE_VALIDATOR),
                fontSizeUnit = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_size_unit", TYPE_HELPER_FONT_SIZE_UNIT, DivSizeUnit.FROM_STRING, FONT_SIZE_UNIT_DEFAULT_VALUE) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                fontWeight = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_weight", TYPE_HELPER_FONT_WEIGHT, DivFontWeight.FROM_STRING, FONT_WEIGHT_DEFAULT_VALUE) ?: FONT_WEIGHT_DEFAULT_VALUE,
                fontWeightValue = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_weight_value", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_WEIGHT_VALUE_VALIDATOR),
                offset = JsonPropertyParser.readOptional(context, logger, data, "offset", component.divPointJsonEntityParser),
                textColor = JsonExpressionParser.readOptionalExpression(context, logger, data, "text_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, TEXT_COLOR_DEFAULT_VALUE) ?: TEXT_COLOR_DEFAULT_VALUE,
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivSlider.TextStyle): JSONObject {
            val data = JSONObject()
            data.writeExpression(key = "font_size", value = value.fontSize)
            data.writeExpression(key = "font_size_unit", value = value.fontSizeUnit, converter = DivSizeUnit.TO_STRING)
            data.writeExpression(key = "font_weight", value = value.fontWeight, converter = DivFontWeight.TO_STRING)
            data.writeExpression(key = "font_weight_value", value = value.fontWeightValue)
            data.write(key = "offset", value = component.divPointJsonEntityParser.value.serialize(context, value.offset))
            data.writeExpression(key = "text_color", value = value.textColor, converter = COLOR_INT_TO_STRING)
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivSliderTemplate.TextStyleTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivSliderTemplate.TextStyleTemplate?, data: JSONObject): DivSliderTemplate.TextStyleTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivSliderTemplate.TextStyleTemplate(
                fontSize = JsonFieldParser.readFieldWithExpression(context, logger, data, "font_size", TYPE_HELPER_INT, allowOverride, parent?.fontSize, NUMBER_TO_INT, FONT_SIZE_VALIDATOR),
                fontSizeUnit = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_size_unit", TYPE_HELPER_FONT_SIZE_UNIT, allowOverride, parent?.fontSizeUnit, DivSizeUnit.FROM_STRING),
                fontWeight = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_weight", TYPE_HELPER_FONT_WEIGHT, allowOverride, parent?.fontWeight, DivFontWeight.FROM_STRING),
                fontWeightValue = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_weight_value", TYPE_HELPER_INT, allowOverride, parent?.fontWeightValue, NUMBER_TO_INT, FONT_WEIGHT_VALUE_VALIDATOR),
                offset = JsonFieldParser.readOptionalField(context, logger, data, "offset", allowOverride, parent?.offset, component.divPointJsonTemplateParser),
                textColor = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "text_color", TYPE_HELPER_COLOR, allowOverride, parent?.textColor, STRING_TO_COLOR_INT),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivSliderTemplate.TextStyleTemplate): JSONObject {
            val data = JSONObject()
            data.writeFieldWithExpression(key = "font_size", field = value.fontSize)
            data.writeFieldWithExpression(key = "font_size_unit", field = value.fontSizeUnit, converter = DivSizeUnit.TO_STRING)
            data.writeFieldWithExpression(key = "font_weight", field = value.fontWeight, converter = DivFontWeight.TO_STRING)
            data.writeFieldWithExpression(key = "font_weight_value", field = value.fontWeightValue)
            data.writeField(key = "offset", field = value.offset, converter = component.divPointJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "text_color", field = value.textColor, converter = COLOR_INT_TO_STRING)
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivSliderTemplate.TextStyleTemplate, DivSlider.TextStyle> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivSliderTemplate.TextStyleTemplate, data: JSONObject): DivSlider.TextStyle {
            val logger = context.logger
            return DivSlider.TextStyle(
                fontSize = JsonFieldResolver.resolveExpression(context, logger, template.fontSize, data, "font_size", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_SIZE_VALIDATOR),
                fontSizeUnit = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontSizeUnit, data, "font_size_unit", TYPE_HELPER_FONT_SIZE_UNIT, DivSizeUnit.FROM_STRING, FONT_SIZE_UNIT_DEFAULT_VALUE) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                fontWeight = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontWeight, data, "font_weight", TYPE_HELPER_FONT_WEIGHT, DivFontWeight.FROM_STRING, FONT_WEIGHT_DEFAULT_VALUE) ?: FONT_WEIGHT_DEFAULT_VALUE,
                fontWeightValue = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontWeightValue, data, "font_weight_value", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_WEIGHT_VALUE_VALIDATOR),
                offset = JsonFieldResolver.resolveOptional(context, logger, template.offset, data, "offset", component.divPointJsonTemplateResolver, component.divPointJsonEntityParser),
                textColor = JsonFieldResolver.resolveOptionalExpression(context, logger, template.textColor, data, "text_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, TEXT_COLOR_DEFAULT_VALUE) ?: TEXT_COLOR_DEFAULT_VALUE,
            )
        }
    }

    private companion object {

        @JvmField val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)
        @JvmField val FONT_WEIGHT_DEFAULT_VALUE = Expression.constant(DivFontWeight.REGULAR)
        @JvmField val TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0xFF000000.toInt())

        @JvmField val TYPE_HELPER_FONT_SIZE_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }
        @JvmField val TYPE_HELPER_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }

        @JvmField val FONT_SIZE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val FONT_WEIGHT_VALUE_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
    }
}

internal class DivSliderRangeJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivSlider.Range> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivSlider.Range {
            val logger = context.logger
            return DivSlider.Range(
                end = JsonExpressionParser.readOptionalExpression(context, logger, data, "end", TYPE_HELPER_INT, NUMBER_TO_INT),
                margins = JsonPropertyParser.readOptional(context, logger, data, "margins", component.divEdgeInsetsJsonEntityParser),
                start = JsonExpressionParser.readOptionalExpression(context, logger, data, "start", TYPE_HELPER_INT, NUMBER_TO_INT),
                trackActiveStyle = JsonPropertyParser.readOptional(context, logger, data, "track_active_style", component.divDrawableJsonEntityParser),
                trackInactiveStyle = JsonPropertyParser.readOptional(context, logger, data, "track_inactive_style", component.divDrawableJsonEntityParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivSlider.Range): JSONObject {
            val data = JSONObject()
            data.writeExpression(key = "end", value = value.end)
            data.write(key = "margins", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.margins))
            data.writeExpression(key = "start", value = value.start)
            data.write(key = "track_active_style", value = component.divDrawableJsonEntityParser.value.serialize(context, value.trackActiveStyle))
            data.write(key = "track_inactive_style", value = component.divDrawableJsonEntityParser.value.serialize(context, value.trackInactiveStyle))
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivSliderTemplate.RangeTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivSliderTemplate.RangeTemplate?, data: JSONObject): DivSliderTemplate.RangeTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivSliderTemplate.RangeTemplate(
                end = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "end", TYPE_HELPER_INT, allowOverride, parent?.end, NUMBER_TO_INT),
                margins = JsonFieldParser.readOptionalField(context, logger, data, "margins", allowOverride, parent?.margins, component.divEdgeInsetsJsonTemplateParser),
                start = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "start", TYPE_HELPER_INT, allowOverride, parent?.start, NUMBER_TO_INT),
                trackActiveStyle = JsonFieldParser.readOptionalField(context, logger, data, "track_active_style", allowOverride, parent?.trackActiveStyle, component.divDrawableJsonTemplateParser),
                trackInactiveStyle = JsonFieldParser.readOptionalField(context, logger, data, "track_inactive_style", allowOverride, parent?.trackInactiveStyle, component.divDrawableJsonTemplateParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivSliderTemplate.RangeTemplate): JSONObject {
            val data = JSONObject()
            data.writeFieldWithExpression(key = "end", field = value.end)
            data.writeField(key = "margins", field = value.margins, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "start", field = value.start)
            data.writeField(key = "track_active_style", field = value.trackActiveStyle, converter = component.divDrawableJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "track_inactive_style", field = value.trackInactiveStyle, converter = component.divDrawableJsonTemplateParser.value.asConverter(context))
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivSliderTemplate.RangeTemplate, DivSlider.Range> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivSliderTemplate.RangeTemplate, data: JSONObject): DivSlider.Range {
            val logger = context.logger
            return DivSlider.Range(
                end = JsonFieldResolver.resolveOptionalExpression(context, logger, template.end, data, "end", TYPE_HELPER_INT, NUMBER_TO_INT),
                margins = JsonFieldResolver.resolveOptional(context, logger, template.margins, data, "margins", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                start = JsonFieldResolver.resolveOptionalExpression(context, logger, template.start, data, "start", TYPE_HELPER_INT, NUMBER_TO_INT),
                trackActiveStyle = JsonFieldResolver.resolveOptional(context, logger, template.trackActiveStyle, data, "track_active_style", component.divDrawableJsonTemplateResolver, component.divDrawableJsonEntityParser),
                trackInactiveStyle = JsonFieldResolver.resolveOptional(context, logger, template.trackInactiveStyle, data, "track_inactive_style", component.divDrawableJsonTemplateResolver, component.divDrawableJsonEntityParser),
            )
        }
    }
}
