// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivStateJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivState> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivState {
            val logger = context.logger
            return DivState(
                accessibility = JsonPropertyParser.readOptional(context, logger, data, "accessibility", component.divAccessibilityJsonEntityParser),
                alignmentHorizontal = JsonExpressionParser.readOptionalExpression(context, logger, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonExpressionParser.readOptionalExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING),
                alpha = JsonExpressionParser.readOptionalExpression(context, logger, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                animators = JsonPropertyParser.readOptionalList(context, logger, data, "animators", component.divAnimatorJsonEntityParser),
                background = JsonPropertyParser.readOptionalList(context, logger, data, "background", component.divBackgroundJsonEntityParser),
                border = JsonPropertyParser.readOptional(context, logger, data, "border", component.divBorderJsonEntityParser),
                clipToBounds = JsonExpressionParser.readOptionalExpression(context, logger, data, "clip_to_bounds", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, CLIP_TO_BOUNDS_DEFAULT_VALUE) ?: CLIP_TO_BOUNDS_DEFAULT_VALUE,
                columnSpan = JsonExpressionParser.readOptionalExpression(context, logger, data, "column_span", TYPE_HELPER_INT, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                defaultStateId = JsonExpressionParser.readOptionalExpression(context, logger, data, "default_state_id", TYPE_HELPER_STRING),
                disappearActions = JsonPropertyParser.readOptionalList(context, logger, data, "disappear_actions", component.divDisappearActionJsonEntityParser),
                divId = JsonPropertyParser.readOptional(context, logger, data, "div_id"),
                extensions = JsonPropertyParser.readOptionalList(context, logger, data, "extensions", component.divExtensionJsonEntityParser),
                focus = JsonPropertyParser.readOptional(context, logger, data, "focus", component.divFocusJsonEntityParser),
                functions = JsonPropertyParser.readOptionalList(context, logger, data, "functions", component.divFunctionJsonEntityParser),
                height = JsonPropertyParser.readOptional(context, logger, data, "height", component.divSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonPropertyParser.readOptional(context, logger, data, "id"),
                layoutProvider = JsonPropertyParser.readOptional(context, logger, data, "layout_provider", component.divLayoutProviderJsonEntityParser),
                margins = JsonPropertyParser.readOptional(context, logger, data, "margins", component.divEdgeInsetsJsonEntityParser),
                paddings = JsonPropertyParser.readOptional(context, logger, data, "paddings", component.divEdgeInsetsJsonEntityParser),
                reuseId = JsonExpressionParser.readOptionalExpression(context, logger, data, "reuse_id", TYPE_HELPER_STRING),
                rowSpan = JsonExpressionParser.readOptionalExpression(context, logger, data, "row_span", TYPE_HELPER_INT, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectedActions = JsonPropertyParser.readOptionalList(context, logger, data, "selected_actions", component.divActionJsonEntityParser),
                stateIdVariable = JsonPropertyParser.readOptional(context, logger, data, "state_id_variable"),
                states = JsonPropertyParser.readList(context, logger, data, "states", component.divStateStateJsonEntityParser, STATES_VALIDATOR),
                tooltips = JsonPropertyParser.readOptionalList(context, logger, data, "tooltips", component.divTooltipJsonEntityParser),
                transform = JsonPropertyParser.readOptional(context, logger, data, "transform", component.divTransformJsonEntityParser),
                transitionAnimationSelector = JsonExpressionParser.readOptionalExpression(context, logger, data, "transition_animation_selector", TYPE_HELPER_TRANSITION_ANIMATION_SELECTOR, DivTransitionSelector.FROM_STRING, TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE) ?: TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE,
                transitionChange = JsonPropertyParser.readOptional(context, logger, data, "transition_change", component.divChangeTransitionJsonEntityParser),
                transitionIn = JsonPropertyParser.readOptional(context, logger, data, "transition_in", component.divAppearanceTransitionJsonEntityParser),
                transitionOut = JsonPropertyParser.readOptional(context, logger, data, "transition_out", component.divAppearanceTransitionJsonEntityParser),
                transitionTriggers = JsonPropertyParser.readOptionalList(context, logger, data, "transition_triggers", DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR),
                variableTriggers = JsonPropertyParser.readOptionalList(context, logger, data, "variable_triggers", component.divTriggerJsonEntityParser),
                variables = JsonPropertyParser.readOptionalList(context, logger, data, "variables", component.divVariableJsonEntityParser),
                visibility = JsonExpressionParser.readOptionalExpression(context, logger, data, "visibility", TYPE_HELPER_VISIBILITY, DivVisibility.FROM_STRING, VISIBILITY_DEFAULT_VALUE) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonPropertyParser.readOptional(context, logger, data, "visibility_action", component.divVisibilityActionJsonEntityParser),
                visibilityActions = JsonPropertyParser.readOptionalList(context, logger, data, "visibility_actions", component.divVisibilityActionJsonEntityParser),
                width = JsonPropertyParser.readOptional(context, logger, data, "width", component.divSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivState): JSONObject {
            val data = JSONObject()
            data.write(key = "accessibility", value = component.divAccessibilityJsonEntityParser.value.serialize(context, value.accessibility))
            data.writeExpression(key = "alignment_horizontal", value = value.alignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeExpression(key = "alignment_vertical", value = value.alignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeExpression(key = "alpha", value = value.alpha)
            data.write(key = "animators", value = component.divAnimatorJsonEntityParser.value.serialize(context, value.animators))
            data.write(key = "background", value = component.divBackgroundJsonEntityParser.value.serialize(context, value.background))
            data.write(key = "border", value = component.divBorderJsonEntityParser.value.serialize(context, value.border))
            data.writeExpression(key = "clip_to_bounds", value = value.clipToBounds)
            data.writeExpression(key = "column_span", value = value.columnSpan)
            data.writeExpression(key = "default_state_id", value = value.defaultStateId)
            data.write(key = "disappear_actions", value = component.divDisappearActionJsonEntityParser.value.serialize(context, value.disappearActions))
            data.write(key = "div_id", value = value.divId)
            data.write(key = "extensions", value = component.divExtensionJsonEntityParser.value.serialize(context, value.extensions))
            data.write(key = "focus", value = component.divFocusJsonEntityParser.value.serialize(context, value.focus))
            data.write(key = "functions", value = component.divFunctionJsonEntityParser.value.serialize(context, value.functions))
            data.write(key = "height", value = component.divSizeJsonEntityParser.value.serialize(context, value.height))
            data.write(key = "id", value = value.id)
            data.write(key = "layout_provider", value = component.divLayoutProviderJsonEntityParser.value.serialize(context, value.layoutProvider))
            data.write(key = "margins", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.margins))
            data.write(key = "paddings", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.paddings))
            data.writeExpression(key = "reuse_id", value = value.reuseId)
            data.writeExpression(key = "row_span", value = value.rowSpan)
            data.write(key = "selected_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.selectedActions))
            data.write(key = "state_id_variable", value = value.stateIdVariable)
            data.write(key = "states", value = component.divStateStateJsonEntityParser.value.serialize(context, value.states))
            data.write(key = "tooltips", value = component.divTooltipJsonEntityParser.value.serialize(context, value.tooltips))
            data.write(key = "transform", value = component.divTransformJsonEntityParser.value.serialize(context, value.transform))
            data.writeExpression(key = "transition_animation_selector", value = value.transitionAnimationSelector, converter = DivTransitionSelector.TO_STRING)
            data.write(key = "transition_change", value = component.divChangeTransitionJsonEntityParser.value.serialize(context, value.transitionChange))
            data.write(key = "transition_in", value = component.divAppearanceTransitionJsonEntityParser.value.serialize(context, value.transitionIn))
            data.write(key = "transition_out", value = component.divAppearanceTransitionJsonEntityParser.value.serialize(context, value.transitionOut))
            data.write(key = "transition_triggers", value = value.transitionTriggers, converter = DivTransitionTrigger.TO_STRING)
            data.write(key = "type", value = DivState.TYPE)
            data.write(key = "variable_triggers", value = component.divTriggerJsonEntityParser.value.serialize(context, value.variableTriggers))
            data.write(key = "variables", value = component.divVariableJsonEntityParser.value.serialize(context, value.variables))
            data.writeExpression(key = "visibility", value = value.visibility, converter = DivVisibility.TO_STRING)
            data.write(key = "visibility_action", value = component.divVisibilityActionJsonEntityParser.value.serialize(context, value.visibilityAction))
            data.write(key = "visibility_actions", value = component.divVisibilityActionJsonEntityParser.value.serialize(context, value.visibilityActions))
            data.write(key = "width", value = component.divSizeJsonEntityParser.value.serialize(context, value.width))
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivStateTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivStateTemplate?, data: JSONObject): DivStateTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivStateTemplate(
                accessibility = JsonFieldParser.readOptionalField(context, logger, data, "accessibility", allowOverride, parent?.accessibility, component.divAccessibilityJsonTemplateParser),
                alignmentHorizontal = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, allowOverride, parent?.alignmentHorizontal, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, allowOverride, parent?.alignmentVertical, DivAlignmentVertical.FROM_STRING),
                alpha = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alpha", TYPE_HELPER_DOUBLE, allowOverride, parent?.alpha, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR),
                animators = JsonFieldParser.readOptionalListField(context, logger, data, "animators", allowOverride, parent?.animators, component.divAnimatorJsonTemplateParser),
                background = JsonFieldParser.readOptionalListField(context, logger, data, "background", allowOverride, parent?.background, component.divBackgroundJsonTemplateParser),
                border = JsonFieldParser.readOptionalField(context, logger, data, "border", allowOverride, parent?.border, component.divBorderJsonTemplateParser),
                clipToBounds = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "clip_to_bounds", TYPE_HELPER_BOOLEAN, allowOverride, parent?.clipToBounds, ANY_TO_BOOLEAN),
                columnSpan = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "column_span", TYPE_HELPER_INT, allowOverride, parent?.columnSpan, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                defaultStateId = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "default_state_id", TYPE_HELPER_STRING, allowOverride, parent?.defaultStateId),
                disappearActions = JsonFieldParser.readOptionalListField(context, logger, data, "disappear_actions", allowOverride, parent?.disappearActions, component.divDisappearActionJsonTemplateParser),
                divId = JsonFieldParser.readOptionalField(context, logger, data, "div_id", allowOverride, parent?.divId),
                extensions = JsonFieldParser.readOptionalListField(context, logger, data, "extensions", allowOverride, parent?.extensions, component.divExtensionJsonTemplateParser),
                focus = JsonFieldParser.readOptionalField(context, logger, data, "focus", allowOverride, parent?.focus, component.divFocusJsonTemplateParser),
                functions = JsonFieldParser.readOptionalListField(context, logger, data, "functions", allowOverride, parent?.functions, component.divFunctionJsonTemplateParser),
                height = JsonFieldParser.readOptionalField(context, logger, data, "height", allowOverride, parent?.height, component.divSizeJsonTemplateParser),
                id = JsonFieldParser.readOptionalField(context, logger, data, "id", allowOverride, parent?.id),
                layoutProvider = JsonFieldParser.readOptionalField(context, logger, data, "layout_provider", allowOverride, parent?.layoutProvider, component.divLayoutProviderJsonTemplateParser),
                margins = JsonFieldParser.readOptionalField(context, logger, data, "margins", allowOverride, parent?.margins, component.divEdgeInsetsJsonTemplateParser),
                paddings = JsonFieldParser.readOptionalField(context, logger, data, "paddings", allowOverride, parent?.paddings, component.divEdgeInsetsJsonTemplateParser),
                reuseId = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "reuse_id", TYPE_HELPER_STRING, allowOverride, parent?.reuseId),
                rowSpan = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "row_span", TYPE_HELPER_INT, allowOverride, parent?.rowSpan, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectedActions = JsonFieldParser.readOptionalListField(context, logger, data, "selected_actions", allowOverride, parent?.selectedActions, component.divActionJsonTemplateParser),
                stateIdVariable = JsonFieldParser.readOptionalField(context, logger, data, "state_id_variable", allowOverride, parent?.stateIdVariable),
                states = JsonFieldParser.readListField(context, logger, data, "states", allowOverride, parent?.states, component.divStateStateJsonTemplateParser, STATES_VALIDATOR.cast()),
                tooltips = JsonFieldParser.readOptionalListField(context, logger, data, "tooltips", allowOverride, parent?.tooltips, component.divTooltipJsonTemplateParser),
                transform = JsonFieldParser.readOptionalField(context, logger, data, "transform", allowOverride, parent?.transform, component.divTransformJsonTemplateParser),
                transitionAnimationSelector = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "transition_animation_selector", TYPE_HELPER_TRANSITION_ANIMATION_SELECTOR, allowOverride, parent?.transitionAnimationSelector, DivTransitionSelector.FROM_STRING),
                transitionChange = JsonFieldParser.readOptionalField(context, logger, data, "transition_change", allowOverride, parent?.transitionChange, component.divChangeTransitionJsonTemplateParser),
                transitionIn = JsonFieldParser.readOptionalField(context, logger, data, "transition_in", allowOverride, parent?.transitionIn, component.divAppearanceTransitionJsonTemplateParser),
                transitionOut = JsonFieldParser.readOptionalField(context, logger, data, "transition_out", allowOverride, parent?.transitionOut, component.divAppearanceTransitionJsonTemplateParser),
                transitionTriggers = JsonFieldParser.readOptionalListField(context, logger, data, "transition_triggers", allowOverride, parent?.transitionTriggers, DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR.cast()),
                variableTriggers = JsonFieldParser.readOptionalListField(context, logger, data, "variable_triggers", allowOverride, parent?.variableTriggers, component.divTriggerJsonTemplateParser),
                variables = JsonFieldParser.readOptionalListField(context, logger, data, "variables", allowOverride, parent?.variables, component.divVariableJsonTemplateParser),
                visibility = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "visibility", TYPE_HELPER_VISIBILITY, allowOverride, parent?.visibility, DivVisibility.FROM_STRING),
                visibilityAction = JsonFieldParser.readOptionalField(context, logger, data, "visibility_action", allowOverride, parent?.visibilityAction, component.divVisibilityActionJsonTemplateParser),
                visibilityActions = JsonFieldParser.readOptionalListField(context, logger, data, "visibility_actions", allowOverride, parent?.visibilityActions, component.divVisibilityActionJsonTemplateParser),
                width = JsonFieldParser.readOptionalField(context, logger, data, "width", allowOverride, parent?.width, component.divSizeJsonTemplateParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivStateTemplate): JSONObject {
            val data = JSONObject()
            data.writeField(key = "accessibility", field = value.accessibility, converter = component.divAccessibilityJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "alignment_horizontal", field = value.alignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeFieldWithExpression(key = "alignment_vertical", field = value.alignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeFieldWithExpression(key = "alpha", field = value.alpha)
            data.writeField(key = "animators", field = value.animators, converter = component.divAnimatorJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "background", field = value.background, converter = component.divBackgroundJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "border", field = value.border, converter = component.divBorderJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "clip_to_bounds", field = value.clipToBounds)
            data.writeFieldWithExpression(key = "column_span", field = value.columnSpan)
            data.writeFieldWithExpression(key = "default_state_id", field = value.defaultStateId)
            data.writeField(key = "disappear_actions", field = value.disappearActions, converter = component.divDisappearActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "div_id", field = value.divId)
            data.writeField(key = "extensions", field = value.extensions, converter = component.divExtensionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "focus", field = value.focus, converter = component.divFocusJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "functions", field = value.functions, converter = component.divFunctionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "height", field = value.height, converter = component.divSizeJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "id", field = value.id)
            data.writeField(key = "layout_provider", field = value.layoutProvider, converter = component.divLayoutProviderJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "margins", field = value.margins, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "paddings", field = value.paddings, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "reuse_id", field = value.reuseId)
            data.writeFieldWithExpression(key = "row_span", field = value.rowSpan)
            data.writeField(key = "selected_actions", field = value.selectedActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "state_id_variable", field = value.stateIdVariable)
            data.writeField(key = "states", field = value.states, converter = component.divStateStateJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "tooltips", field = value.tooltips, converter = component.divTooltipJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transform", field = value.transform, converter = component.divTransformJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "transition_animation_selector", field = value.transitionAnimationSelector, converter = DivTransitionSelector.TO_STRING)
            data.writeField(key = "transition_change", field = value.transitionChange, converter = component.divChangeTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_in", field = value.transitionIn, converter = component.divAppearanceTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_out", field = value.transitionOut, converter = component.divAppearanceTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_triggers", field = value.transitionTriggers, converter = DivTransitionTrigger.TO_STRING)
            data.write(key = "type", value = DivState.TYPE)
            data.writeField(key = "variable_triggers", field = value.variableTriggers, converter = component.divTriggerJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "variables", field = value.variables, converter = component.divVariableJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "visibility", field = value.visibility, converter = DivVisibility.TO_STRING)
            data.writeField(key = "visibility_action", field = value.visibilityAction, converter = component.divVisibilityActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "visibility_actions", field = value.visibilityActions, converter = component.divVisibilityActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "width", field = value.width, converter = component.divSizeJsonTemplateParser.value.asConverter(context))
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivStateTemplate, DivState> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivStateTemplate, data: JSONObject): DivState {
            val logger = context.logger
            return DivState(
                accessibility = JsonFieldResolver.resolveOptional(context, logger, template.accessibility, data, "accessibility", component.divAccessibilityJsonTemplateResolver, component.divAccessibilityJsonEntityParser),
                alignmentHorizontal = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alignmentHorizontal, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alignmentVertical, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING),
                alpha = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alpha, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                animators = JsonFieldResolver.resolveOptionalList(context, logger, template.animators, data, "animators", component.divAnimatorJsonTemplateResolver, component.divAnimatorJsonEntityParser),
                background = JsonFieldResolver.resolveOptionalList(context, logger, template.background, data, "background", component.divBackgroundJsonTemplateResolver, component.divBackgroundJsonEntityParser),
                border = JsonFieldResolver.resolveOptional(context, logger, template.border, data, "border", component.divBorderJsonTemplateResolver, component.divBorderJsonEntityParser),
                clipToBounds = JsonFieldResolver.resolveOptionalExpression(context, logger, template.clipToBounds, data, "clip_to_bounds", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, CLIP_TO_BOUNDS_DEFAULT_VALUE) ?: CLIP_TO_BOUNDS_DEFAULT_VALUE,
                columnSpan = JsonFieldResolver.resolveOptionalExpression(context, logger, template.columnSpan, data, "column_span", TYPE_HELPER_INT, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                defaultStateId = JsonFieldResolver.resolveOptionalExpression(context, logger, template.defaultStateId, data, "default_state_id", TYPE_HELPER_STRING),
                disappearActions = JsonFieldResolver.resolveOptionalList(context, logger, template.disappearActions, data, "disappear_actions", component.divDisappearActionJsonTemplateResolver, component.divDisappearActionJsonEntityParser),
                divId = JsonFieldResolver.resolveOptional(context, logger, template.divId, data, "div_id"),
                extensions = JsonFieldResolver.resolveOptionalList(context, logger, template.extensions, data, "extensions", component.divExtensionJsonTemplateResolver, component.divExtensionJsonEntityParser),
                focus = JsonFieldResolver.resolveOptional(context, logger, template.focus, data, "focus", component.divFocusJsonTemplateResolver, component.divFocusJsonEntityParser),
                functions = JsonFieldResolver.resolveOptionalList(context, logger, template.functions, data, "functions", component.divFunctionJsonTemplateResolver, component.divFunctionJsonEntityParser),
                height = JsonFieldResolver.resolveOptional(context, logger, template.height, data, "height", component.divSizeJsonTemplateResolver, component.divSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonFieldResolver.resolveOptional(context, logger, template.id, data, "id"),
                layoutProvider = JsonFieldResolver.resolveOptional(context, logger, template.layoutProvider, data, "layout_provider", component.divLayoutProviderJsonTemplateResolver, component.divLayoutProviderJsonEntityParser),
                margins = JsonFieldResolver.resolveOptional(context, logger, template.margins, data, "margins", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                paddings = JsonFieldResolver.resolveOptional(context, logger, template.paddings, data, "paddings", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                reuseId = JsonFieldResolver.resolveOptionalExpression(context, logger, template.reuseId, data, "reuse_id", TYPE_HELPER_STRING),
                rowSpan = JsonFieldResolver.resolveOptionalExpression(context, logger, template.rowSpan, data, "row_span", TYPE_HELPER_INT, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectedActions = JsonFieldResolver.resolveOptionalList(context, logger, template.selectedActions, data, "selected_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                stateIdVariable = JsonFieldResolver.resolveOptional(context, logger, template.stateIdVariable, data, "state_id_variable"),
                states = JsonFieldResolver.resolveList(context, logger, template.states, data, "states", component.divStateStateJsonTemplateResolver, component.divStateStateJsonEntityParser, STATES_VALIDATOR),
                tooltips = JsonFieldResolver.resolveOptionalList(context, logger, template.tooltips, data, "tooltips", component.divTooltipJsonTemplateResolver, component.divTooltipJsonEntityParser),
                transform = JsonFieldResolver.resolveOptional(context, logger, template.transform, data, "transform", component.divTransformJsonTemplateResolver, component.divTransformJsonEntityParser),
                transitionAnimationSelector = JsonFieldResolver.resolveOptionalExpression(context, logger, template.transitionAnimationSelector, data, "transition_animation_selector", TYPE_HELPER_TRANSITION_ANIMATION_SELECTOR, DivTransitionSelector.FROM_STRING, TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE) ?: TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE,
                transitionChange = JsonFieldResolver.resolveOptional(context, logger, template.transitionChange, data, "transition_change", component.divChangeTransitionJsonTemplateResolver, component.divChangeTransitionJsonEntityParser),
                transitionIn = JsonFieldResolver.resolveOptional(context, logger, template.transitionIn, data, "transition_in", component.divAppearanceTransitionJsonTemplateResolver, component.divAppearanceTransitionJsonEntityParser),
                transitionOut = JsonFieldResolver.resolveOptional(context, logger, template.transitionOut, data, "transition_out", component.divAppearanceTransitionJsonTemplateResolver, component.divAppearanceTransitionJsonEntityParser),
                transitionTriggers = JsonFieldResolver.resolveOptionalList(context, logger, template.transitionTriggers, data, "transition_triggers", DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR),
                variableTriggers = JsonFieldResolver.resolveOptionalList(context, logger, template.variableTriggers, data, "variable_triggers", component.divTriggerJsonTemplateResolver, component.divTriggerJsonEntityParser),
                variables = JsonFieldResolver.resolveOptionalList(context, logger, template.variables, data, "variables", component.divVariableJsonTemplateResolver, component.divVariableJsonEntityParser),
                visibility = JsonFieldResolver.resolveOptionalExpression(context, logger, template.visibility, data, "visibility", TYPE_HELPER_VISIBILITY, DivVisibility.FROM_STRING, VISIBILITY_DEFAULT_VALUE) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonFieldResolver.resolveOptional(context, logger, template.visibilityAction, data, "visibility_action", component.divVisibilityActionJsonTemplateResolver, component.divVisibilityActionJsonEntityParser),
                visibilityActions = JsonFieldResolver.resolveOptionalList(context, logger, template.visibilityActions, data, "visibility_actions", component.divVisibilityActionJsonTemplateResolver, component.divVisibilityActionJsonEntityParser),
                width = JsonFieldResolver.resolveOptional(context, logger, template.width, data, "width", component.divSizeJsonTemplateResolver, component.divSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }
    }

    private companion object {

        @JvmField val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        @JvmField val CLIP_TO_BOUNDS_DEFAULT_VALUE = Expression.constant(true)
        @JvmField val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        @JvmField val TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE = Expression.constant(DivTransitionSelector.STATE_CHANGE)
        @JvmField val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        @JvmField val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        @JvmField val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        @JvmField val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        @JvmField val TYPE_HELPER_TRANSITION_ANIMATION_SELECTOR = TypeHelper.from(default = DivTransitionSelector.values().first()) { it is DivTransitionSelector }
        @JvmField val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmField val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        @JvmField val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val STATES_VALIDATOR = ListValidator<DivState.State> { it: List<*> -> it.size >= 1 }
        @JvmField val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
    }
}

internal class DivStateStateJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivState.State> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivState.State {
            val logger = context.logger
            return DivState.State(
                animationIn = JsonPropertyParser.readOptional(context, logger, data, "animation_in", component.divAnimationJsonEntityParser),
                animationOut = JsonPropertyParser.readOptional(context, logger, data, "animation_out", component.divAnimationJsonEntityParser),
                div = JsonPropertyParser.readOptional(context, logger, data, "div", component.divJsonEntityParser),
                stateId = JsonPropertyParser.read(context, logger, data, "state_id"),
                swipeOutActions = JsonPropertyParser.readOptionalList(context, logger, data, "swipe_out_actions", component.divActionJsonEntityParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivState.State): JSONObject {
            val data = JSONObject()
            data.write(key = "animation_in", value = component.divAnimationJsonEntityParser.value.serialize(context, value.animationIn))
            data.write(key = "animation_out", value = component.divAnimationJsonEntityParser.value.serialize(context, value.animationOut))
            data.write(key = "div", value = component.divJsonEntityParser.value.serialize(context, value.div))
            data.write(key = "state_id", value = value.stateId)
            data.write(key = "swipe_out_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.swipeOutActions))
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivStateTemplate.StateTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivStateTemplate.StateTemplate?, data: JSONObject): DivStateTemplate.StateTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivStateTemplate.StateTemplate(
                animationIn = JsonFieldParser.readOptionalField(context, logger, data, "animation_in", allowOverride, parent?.animationIn, component.divAnimationJsonTemplateParser),
                animationOut = JsonFieldParser.readOptionalField(context, logger, data, "animation_out", allowOverride, parent?.animationOut, component.divAnimationJsonTemplateParser),
                div = JsonFieldParser.readOptionalField(context, logger, data, "div", allowOverride, parent?.div, component.divJsonTemplateParser),
                stateId = JsonFieldParser.readField(context, logger, data, "state_id", allowOverride, parent?.stateId),
                swipeOutActions = JsonFieldParser.readOptionalListField(context, logger, data, "swipe_out_actions", allowOverride, parent?.swipeOutActions, component.divActionJsonTemplateParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivStateTemplate.StateTemplate): JSONObject {
            val data = JSONObject()
            data.writeField(key = "animation_in", field = value.animationIn, converter = component.divAnimationJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "animation_out", field = value.animationOut, converter = component.divAnimationJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "div", field = value.div, converter = component.divJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "state_id", field = value.stateId)
            data.writeField(key = "swipe_out_actions", field = value.swipeOutActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivStateTemplate.StateTemplate, DivState.State> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivStateTemplate.StateTemplate, data: JSONObject): DivState.State {
            val logger = context.logger
            return DivState.State(
                animationIn = JsonFieldResolver.resolveOptional(context, logger, template.animationIn, data, "animation_in", component.divAnimationJsonTemplateResolver, component.divAnimationJsonEntityParser),
                animationOut = JsonFieldResolver.resolveOptional(context, logger, template.animationOut, data, "animation_out", component.divAnimationJsonTemplateResolver, component.divAnimationJsonEntityParser),
                div = JsonFieldResolver.resolveOptional(context, logger, template.div, data, "div", component.divJsonTemplateResolver, component.divJsonEntityParser),
                stateId = JsonFieldResolver.resolve(context, logger, template.stateId, data, "state_id"),
                swipeOutActions = JsonFieldResolver.resolveOptionalList(context, logger, template.swipeOutActions, data, "swipe_out_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
            )
        }
    }
}
