// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivTabsJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivTabs> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivTabs {
            val logger = context.logger
            return DivTabs(
                accessibility = JsonPropertyParser.readOptional(context, logger, data, "accessibility", component.divAccessibilityJsonEntityParser),
                alignmentHorizontal = JsonExpressionParser.readOptionalExpression(context, logger, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonExpressionParser.readOptionalExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING),
                alpha = JsonExpressionParser.readOptionalExpression(context, logger, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                animators = JsonPropertyParser.readOptionalList(context, logger, data, "animators", component.divAnimatorJsonEntityParser),
                background = JsonPropertyParser.readOptionalList(context, logger, data, "background", component.divBackgroundJsonEntityParser),
                border = JsonPropertyParser.readOptional(context, logger, data, "border", component.divBorderJsonEntityParser),
                columnSpan = JsonExpressionParser.readOptionalExpression(context, logger, data, "column_span", TYPE_HELPER_INT, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                disappearActions = JsonPropertyParser.readOptionalList(context, logger, data, "disappear_actions", component.divDisappearActionJsonEntityParser),
                dynamicHeight = JsonExpressionParser.readOptionalExpression(context, logger, data, "dynamic_height", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, DYNAMIC_HEIGHT_DEFAULT_VALUE) ?: DYNAMIC_HEIGHT_DEFAULT_VALUE,
                extensions = JsonPropertyParser.readOptionalList(context, logger, data, "extensions", component.divExtensionJsonEntityParser),
                focus = JsonPropertyParser.readOptional(context, logger, data, "focus", component.divFocusJsonEntityParser),
                functions = JsonPropertyParser.readOptionalList(context, logger, data, "functions", component.divFunctionJsonEntityParser),
                hasSeparator = JsonExpressionParser.readOptionalExpression(context, logger, data, "has_separator", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, HAS_SEPARATOR_DEFAULT_VALUE) ?: HAS_SEPARATOR_DEFAULT_VALUE,
                height = JsonPropertyParser.readOptional(context, logger, data, "height", component.divSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonPropertyParser.readOptional(context, logger, data, "id"),
                items = JsonPropertyParser.readList(context, logger, data, "items", component.divTabsItemJsonEntityParser, ITEMS_VALIDATOR),
                layoutProvider = JsonPropertyParser.readOptional(context, logger, data, "layout_provider", component.divLayoutProviderJsonEntityParser),
                margins = JsonPropertyParser.readOptional(context, logger, data, "margins", component.divEdgeInsetsJsonEntityParser),
                paddings = JsonPropertyParser.readOptional(context, logger, data, "paddings", component.divEdgeInsetsJsonEntityParser),
                restrictParentScroll = JsonExpressionParser.readOptionalExpression(context, logger, data, "restrict_parent_scroll", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, RESTRICT_PARENT_SCROLL_DEFAULT_VALUE) ?: RESTRICT_PARENT_SCROLL_DEFAULT_VALUE,
                reuseId = JsonExpressionParser.readOptionalExpression(context, logger, data, "reuse_id", TYPE_HELPER_STRING),
                rowSpan = JsonExpressionParser.readOptionalExpression(context, logger, data, "row_span", TYPE_HELPER_INT, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectedActions = JsonPropertyParser.readOptionalList(context, logger, data, "selected_actions", component.divActionJsonEntityParser),
                selectedTab = JsonExpressionParser.readOptionalExpression(context, logger, data, "selected_tab", TYPE_HELPER_INT, NUMBER_TO_INT, SELECTED_TAB_VALIDATOR, SELECTED_TAB_DEFAULT_VALUE) ?: SELECTED_TAB_DEFAULT_VALUE,
                separatorColor = JsonExpressionParser.readOptionalExpression(context, logger, data, "separator_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, SEPARATOR_COLOR_DEFAULT_VALUE) ?: SEPARATOR_COLOR_DEFAULT_VALUE,
                separatorPaddings = JsonPropertyParser.readOptional(context, logger, data, "separator_paddings", component.divEdgeInsetsJsonEntityParser) ?: SEPARATOR_PADDINGS_DEFAULT_VALUE,
                switchTabsByContentSwipeEnabled = JsonExpressionParser.readOptionalExpression(context, logger, data, "switch_tabs_by_content_swipe_enabled", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, SWITCH_TABS_BY_CONTENT_SWIPE_ENABLED_DEFAULT_VALUE) ?: SWITCH_TABS_BY_CONTENT_SWIPE_ENABLED_DEFAULT_VALUE,
                tabTitleDelimiter = JsonPropertyParser.readOptional(context, logger, data, "tab_title_delimiter", component.divTabsTabTitleDelimiterJsonEntityParser),
                tabTitleStyle = JsonPropertyParser.readOptional(context, logger, data, "tab_title_style", component.divTabsTabTitleStyleJsonEntityParser),
                titlePaddings = JsonPropertyParser.readOptional(context, logger, data, "title_paddings", component.divEdgeInsetsJsonEntityParser) ?: TITLE_PADDINGS_DEFAULT_VALUE,
                tooltips = JsonPropertyParser.readOptionalList(context, logger, data, "tooltips", component.divTooltipJsonEntityParser),
                transform = JsonPropertyParser.readOptional(context, logger, data, "transform", component.divTransformJsonEntityParser),
                transitionChange = JsonPropertyParser.readOptional(context, logger, data, "transition_change", component.divChangeTransitionJsonEntityParser),
                transitionIn = JsonPropertyParser.readOptional(context, logger, data, "transition_in", component.divAppearanceTransitionJsonEntityParser),
                transitionOut = JsonPropertyParser.readOptional(context, logger, data, "transition_out", component.divAppearanceTransitionJsonEntityParser),
                transitionTriggers = JsonPropertyParser.readOptionalList(context, logger, data, "transition_triggers", DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR),
                variableTriggers = JsonPropertyParser.readOptionalList(context, logger, data, "variable_triggers", component.divTriggerJsonEntityParser),
                variables = JsonPropertyParser.readOptionalList(context, logger, data, "variables", component.divVariableJsonEntityParser),
                visibility = JsonExpressionParser.readOptionalExpression(context, logger, data, "visibility", TYPE_HELPER_VISIBILITY, DivVisibility.FROM_STRING, VISIBILITY_DEFAULT_VALUE) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonPropertyParser.readOptional(context, logger, data, "visibility_action", component.divVisibilityActionJsonEntityParser),
                visibilityActions = JsonPropertyParser.readOptionalList(context, logger, data, "visibility_actions", component.divVisibilityActionJsonEntityParser),
                width = JsonPropertyParser.readOptional(context, logger, data, "width", component.divSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTabs): JSONObject {
            val data = JSONObject()
            data.write(key = "accessibility", value = component.divAccessibilityJsonEntityParser.value.serialize(context, value.accessibility))
            data.writeExpression(key = "alignment_horizontal", value = value.alignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeExpression(key = "alignment_vertical", value = value.alignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeExpression(key = "alpha", value = value.alpha)
            data.write(key = "animators", value = component.divAnimatorJsonEntityParser.value.serialize(context, value.animators))
            data.write(key = "background", value = component.divBackgroundJsonEntityParser.value.serialize(context, value.background))
            data.write(key = "border", value = component.divBorderJsonEntityParser.value.serialize(context, value.border))
            data.writeExpression(key = "column_span", value = value.columnSpan)
            data.write(key = "disappear_actions", value = component.divDisappearActionJsonEntityParser.value.serialize(context, value.disappearActions))
            data.writeExpression(key = "dynamic_height", value = value.dynamicHeight)
            data.write(key = "extensions", value = component.divExtensionJsonEntityParser.value.serialize(context, value.extensions))
            data.write(key = "focus", value = component.divFocusJsonEntityParser.value.serialize(context, value.focus))
            data.write(key = "functions", value = component.divFunctionJsonEntityParser.value.serialize(context, value.functions))
            data.writeExpression(key = "has_separator", value = value.hasSeparator)
            data.write(key = "height", value = component.divSizeJsonEntityParser.value.serialize(context, value.height))
            data.write(key = "id", value = value.id)
            data.write(key = "items", value = component.divTabsItemJsonEntityParser.value.serialize(context, value.items))
            data.write(key = "layout_provider", value = component.divLayoutProviderJsonEntityParser.value.serialize(context, value.layoutProvider))
            data.write(key = "margins", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.margins))
            data.write(key = "paddings", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.paddings))
            data.writeExpression(key = "restrict_parent_scroll", value = value.restrictParentScroll)
            data.writeExpression(key = "reuse_id", value = value.reuseId)
            data.writeExpression(key = "row_span", value = value.rowSpan)
            data.write(key = "selected_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.selectedActions))
            data.writeExpression(key = "selected_tab", value = value.selectedTab)
            data.writeExpression(key = "separator_color", value = value.separatorColor, converter = COLOR_INT_TO_STRING)
            data.write(key = "separator_paddings", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.separatorPaddings))
            data.writeExpression(key = "switch_tabs_by_content_swipe_enabled", value = value.switchTabsByContentSwipeEnabled)
            data.write(key = "tab_title_delimiter", value = component.divTabsTabTitleDelimiterJsonEntityParser.value.serialize(context, value.tabTitleDelimiter))
            data.write(key = "tab_title_style", value = component.divTabsTabTitleStyleJsonEntityParser.value.serialize(context, value.tabTitleStyle))
            data.write(key = "title_paddings", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.titlePaddings))
            data.write(key = "tooltips", value = component.divTooltipJsonEntityParser.value.serialize(context, value.tooltips))
            data.write(key = "transform", value = component.divTransformJsonEntityParser.value.serialize(context, value.transform))
            data.write(key = "transition_change", value = component.divChangeTransitionJsonEntityParser.value.serialize(context, value.transitionChange))
            data.write(key = "transition_in", value = component.divAppearanceTransitionJsonEntityParser.value.serialize(context, value.transitionIn))
            data.write(key = "transition_out", value = component.divAppearanceTransitionJsonEntityParser.value.serialize(context, value.transitionOut))
            data.write(key = "transition_triggers", value = value.transitionTriggers, converter = DivTransitionTrigger.TO_STRING)
            data.write(key = "type", value = DivTabs.TYPE)
            data.write(key = "variable_triggers", value = component.divTriggerJsonEntityParser.value.serialize(context, value.variableTriggers))
            data.write(key = "variables", value = component.divVariableJsonEntityParser.value.serialize(context, value.variables))
            data.writeExpression(key = "visibility", value = value.visibility, converter = DivVisibility.TO_STRING)
            data.write(key = "visibility_action", value = component.divVisibilityActionJsonEntityParser.value.serialize(context, value.visibilityAction))
            data.write(key = "visibility_actions", value = component.divVisibilityActionJsonEntityParser.value.serialize(context, value.visibilityActions))
            data.write(key = "width", value = component.divSizeJsonEntityParser.value.serialize(context, value.width))
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivTabsTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivTabsTemplate?, data: JSONObject): DivTabsTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivTabsTemplate(
                accessibility = JsonFieldParser.readOptionalField(context, logger, data, "accessibility", allowOverride, parent?.accessibility, component.divAccessibilityJsonTemplateParser),
                alignmentHorizontal = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, allowOverride, parent?.alignmentHorizontal, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, allowOverride, parent?.alignmentVertical, DivAlignmentVertical.FROM_STRING),
                alpha = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alpha", TYPE_HELPER_DOUBLE, allowOverride, parent?.alpha, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR),
                animators = JsonFieldParser.readOptionalListField(context, logger, data, "animators", allowOverride, parent?.animators, component.divAnimatorJsonTemplateParser),
                background = JsonFieldParser.readOptionalListField(context, logger, data, "background", allowOverride, parent?.background, component.divBackgroundJsonTemplateParser),
                border = JsonFieldParser.readOptionalField(context, logger, data, "border", allowOverride, parent?.border, component.divBorderJsonTemplateParser),
                columnSpan = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "column_span", TYPE_HELPER_INT, allowOverride, parent?.columnSpan, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                disappearActions = JsonFieldParser.readOptionalListField(context, logger, data, "disappear_actions", allowOverride, parent?.disappearActions, component.divDisappearActionJsonTemplateParser),
                dynamicHeight = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "dynamic_height", TYPE_HELPER_BOOLEAN, allowOverride, parent?.dynamicHeight, ANY_TO_BOOLEAN),
                extensions = JsonFieldParser.readOptionalListField(context, logger, data, "extensions", allowOverride, parent?.extensions, component.divExtensionJsonTemplateParser),
                focus = JsonFieldParser.readOptionalField(context, logger, data, "focus", allowOverride, parent?.focus, component.divFocusJsonTemplateParser),
                functions = JsonFieldParser.readOptionalListField(context, logger, data, "functions", allowOverride, parent?.functions, component.divFunctionJsonTemplateParser),
                hasSeparator = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "has_separator", TYPE_HELPER_BOOLEAN, allowOverride, parent?.hasSeparator, ANY_TO_BOOLEAN),
                height = JsonFieldParser.readOptionalField(context, logger, data, "height", allowOverride, parent?.height, component.divSizeJsonTemplateParser),
                id = JsonFieldParser.readOptionalField(context, logger, data, "id", allowOverride, parent?.id),
                items = JsonFieldParser.readListField(context, logger, data, "items", allowOverride, parent?.items, component.divTabsItemJsonTemplateParser, ITEMS_VALIDATOR.cast()),
                layoutProvider = JsonFieldParser.readOptionalField(context, logger, data, "layout_provider", allowOverride, parent?.layoutProvider, component.divLayoutProviderJsonTemplateParser),
                margins = JsonFieldParser.readOptionalField(context, logger, data, "margins", allowOverride, parent?.margins, component.divEdgeInsetsJsonTemplateParser),
                paddings = JsonFieldParser.readOptionalField(context, logger, data, "paddings", allowOverride, parent?.paddings, component.divEdgeInsetsJsonTemplateParser),
                restrictParentScroll = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "restrict_parent_scroll", TYPE_HELPER_BOOLEAN, allowOverride, parent?.restrictParentScroll, ANY_TO_BOOLEAN),
                reuseId = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "reuse_id", TYPE_HELPER_STRING, allowOverride, parent?.reuseId),
                rowSpan = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "row_span", TYPE_HELPER_INT, allowOverride, parent?.rowSpan, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectedActions = JsonFieldParser.readOptionalListField(context, logger, data, "selected_actions", allowOverride, parent?.selectedActions, component.divActionJsonTemplateParser),
                selectedTab = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "selected_tab", TYPE_HELPER_INT, allowOverride, parent?.selectedTab, NUMBER_TO_INT, SELECTED_TAB_VALIDATOR),
                separatorColor = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "separator_color", TYPE_HELPER_COLOR, allowOverride, parent?.separatorColor, STRING_TO_COLOR_INT),
                separatorPaddings = JsonFieldParser.readOptionalField(context, logger, data, "separator_paddings", allowOverride, parent?.separatorPaddings, component.divEdgeInsetsJsonTemplateParser),
                switchTabsByContentSwipeEnabled = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "switch_tabs_by_content_swipe_enabled", TYPE_HELPER_BOOLEAN, allowOverride, parent?.switchTabsByContentSwipeEnabled, ANY_TO_BOOLEAN),
                tabTitleDelimiter = JsonFieldParser.readOptionalField(context, logger, data, "tab_title_delimiter", allowOverride, parent?.tabTitleDelimiter, component.divTabsTabTitleDelimiterJsonTemplateParser),
                tabTitleStyle = JsonFieldParser.readOptionalField(context, logger, data, "tab_title_style", allowOverride, parent?.tabTitleStyle, component.divTabsTabTitleStyleJsonTemplateParser),
                titlePaddings = JsonFieldParser.readOptionalField(context, logger, data, "title_paddings", allowOverride, parent?.titlePaddings, component.divEdgeInsetsJsonTemplateParser),
                tooltips = JsonFieldParser.readOptionalListField(context, logger, data, "tooltips", allowOverride, parent?.tooltips, component.divTooltipJsonTemplateParser),
                transform = JsonFieldParser.readOptionalField(context, logger, data, "transform", allowOverride, parent?.transform, component.divTransformJsonTemplateParser),
                transitionChange = JsonFieldParser.readOptionalField(context, logger, data, "transition_change", allowOverride, parent?.transitionChange, component.divChangeTransitionJsonTemplateParser),
                transitionIn = JsonFieldParser.readOptionalField(context, logger, data, "transition_in", allowOverride, parent?.transitionIn, component.divAppearanceTransitionJsonTemplateParser),
                transitionOut = JsonFieldParser.readOptionalField(context, logger, data, "transition_out", allowOverride, parent?.transitionOut, component.divAppearanceTransitionJsonTemplateParser),
                transitionTriggers = JsonFieldParser.readOptionalListField(context, logger, data, "transition_triggers", allowOverride, parent?.transitionTriggers, DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR.cast()),
                variableTriggers = JsonFieldParser.readOptionalListField(context, logger, data, "variable_triggers", allowOverride, parent?.variableTriggers, component.divTriggerJsonTemplateParser),
                variables = JsonFieldParser.readOptionalListField(context, logger, data, "variables", allowOverride, parent?.variables, component.divVariableJsonTemplateParser),
                visibility = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "visibility", TYPE_HELPER_VISIBILITY, allowOverride, parent?.visibility, DivVisibility.FROM_STRING),
                visibilityAction = JsonFieldParser.readOptionalField(context, logger, data, "visibility_action", allowOverride, parent?.visibilityAction, component.divVisibilityActionJsonTemplateParser),
                visibilityActions = JsonFieldParser.readOptionalListField(context, logger, data, "visibility_actions", allowOverride, parent?.visibilityActions, component.divVisibilityActionJsonTemplateParser),
                width = JsonFieldParser.readOptionalField(context, logger, data, "width", allowOverride, parent?.width, component.divSizeJsonTemplateParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTabsTemplate): JSONObject {
            val data = JSONObject()
            data.writeField(key = "accessibility", field = value.accessibility, converter = component.divAccessibilityJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "alignment_horizontal", field = value.alignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeFieldWithExpression(key = "alignment_vertical", field = value.alignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeFieldWithExpression(key = "alpha", field = value.alpha)
            data.writeField(key = "animators", field = value.animators, converter = component.divAnimatorJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "background", field = value.background, converter = component.divBackgroundJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "border", field = value.border, converter = component.divBorderJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "column_span", field = value.columnSpan)
            data.writeField(key = "disappear_actions", field = value.disappearActions, converter = component.divDisappearActionJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "dynamic_height", field = value.dynamicHeight)
            data.writeField(key = "extensions", field = value.extensions, converter = component.divExtensionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "focus", field = value.focus, converter = component.divFocusJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "functions", field = value.functions, converter = component.divFunctionJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "has_separator", field = value.hasSeparator)
            data.writeField(key = "height", field = value.height, converter = component.divSizeJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "id", field = value.id)
            data.writeField(key = "items", field = value.items, converter = component.divTabsItemJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "layout_provider", field = value.layoutProvider, converter = component.divLayoutProviderJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "margins", field = value.margins, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "paddings", field = value.paddings, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "restrict_parent_scroll", field = value.restrictParentScroll)
            data.writeFieldWithExpression(key = "reuse_id", field = value.reuseId)
            data.writeFieldWithExpression(key = "row_span", field = value.rowSpan)
            data.writeField(key = "selected_actions", field = value.selectedActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "selected_tab", field = value.selectedTab)
            data.writeFieldWithExpression(key = "separator_color", field = value.separatorColor, converter = COLOR_INT_TO_STRING)
            data.writeField(key = "separator_paddings", field = value.separatorPaddings, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "switch_tabs_by_content_swipe_enabled", field = value.switchTabsByContentSwipeEnabled)
            data.writeField(key = "tab_title_delimiter", field = value.tabTitleDelimiter, converter = component.divTabsTabTitleDelimiterJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "tab_title_style", field = value.tabTitleStyle, converter = component.divTabsTabTitleStyleJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "title_paddings", field = value.titlePaddings, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "tooltips", field = value.tooltips, converter = component.divTooltipJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transform", field = value.transform, converter = component.divTransformJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_change", field = value.transitionChange, converter = component.divChangeTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_in", field = value.transitionIn, converter = component.divAppearanceTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_out", field = value.transitionOut, converter = component.divAppearanceTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_triggers", field = value.transitionTriggers, converter = DivTransitionTrigger.TO_STRING)
            data.write(key = "type", value = DivTabs.TYPE)
            data.writeField(key = "variable_triggers", field = value.variableTriggers, converter = component.divTriggerJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "variables", field = value.variables, converter = component.divVariableJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "visibility", field = value.visibility, converter = DivVisibility.TO_STRING)
            data.writeField(key = "visibility_action", field = value.visibilityAction, converter = component.divVisibilityActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "visibility_actions", field = value.visibilityActions, converter = component.divVisibilityActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "width", field = value.width, converter = component.divSizeJsonTemplateParser.value.asConverter(context))
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivTabsTemplate, DivTabs> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivTabsTemplate, data: JSONObject): DivTabs {
            val logger = context.logger
            return DivTabs(
                accessibility = JsonFieldResolver.resolveOptional(context, logger, template.accessibility, data, "accessibility", component.divAccessibilityJsonTemplateResolver, component.divAccessibilityJsonEntityParser),
                alignmentHorizontal = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alignmentHorizontal, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alignmentVertical, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING),
                alpha = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alpha, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                animators = JsonFieldResolver.resolveOptionalList(context, logger, template.animators, data, "animators", component.divAnimatorJsonTemplateResolver, component.divAnimatorJsonEntityParser),
                background = JsonFieldResolver.resolveOptionalList(context, logger, template.background, data, "background", component.divBackgroundJsonTemplateResolver, component.divBackgroundJsonEntityParser),
                border = JsonFieldResolver.resolveOptional(context, logger, template.border, data, "border", component.divBorderJsonTemplateResolver, component.divBorderJsonEntityParser),
                columnSpan = JsonFieldResolver.resolveOptionalExpression(context, logger, template.columnSpan, data, "column_span", TYPE_HELPER_INT, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                disappearActions = JsonFieldResolver.resolveOptionalList(context, logger, template.disappearActions, data, "disappear_actions", component.divDisappearActionJsonTemplateResolver, component.divDisappearActionJsonEntityParser),
                dynamicHeight = JsonFieldResolver.resolveOptionalExpression(context, logger, template.dynamicHeight, data, "dynamic_height", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, DYNAMIC_HEIGHT_DEFAULT_VALUE) ?: DYNAMIC_HEIGHT_DEFAULT_VALUE,
                extensions = JsonFieldResolver.resolveOptionalList(context, logger, template.extensions, data, "extensions", component.divExtensionJsonTemplateResolver, component.divExtensionJsonEntityParser),
                focus = JsonFieldResolver.resolveOptional(context, logger, template.focus, data, "focus", component.divFocusJsonTemplateResolver, component.divFocusJsonEntityParser),
                functions = JsonFieldResolver.resolveOptionalList(context, logger, template.functions, data, "functions", component.divFunctionJsonTemplateResolver, component.divFunctionJsonEntityParser),
                hasSeparator = JsonFieldResolver.resolveOptionalExpression(context, logger, template.hasSeparator, data, "has_separator", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, HAS_SEPARATOR_DEFAULT_VALUE) ?: HAS_SEPARATOR_DEFAULT_VALUE,
                height = JsonFieldResolver.resolveOptional(context, logger, template.height, data, "height", component.divSizeJsonTemplateResolver, component.divSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonFieldResolver.resolveOptional(context, logger, template.id, data, "id"),
                items = JsonFieldResolver.resolveList(context, logger, template.items, data, "items", component.divTabsItemJsonTemplateResolver, component.divTabsItemJsonEntityParser, ITEMS_VALIDATOR),
                layoutProvider = JsonFieldResolver.resolveOptional(context, logger, template.layoutProvider, data, "layout_provider", component.divLayoutProviderJsonTemplateResolver, component.divLayoutProviderJsonEntityParser),
                margins = JsonFieldResolver.resolveOptional(context, logger, template.margins, data, "margins", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                paddings = JsonFieldResolver.resolveOptional(context, logger, template.paddings, data, "paddings", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                restrictParentScroll = JsonFieldResolver.resolveOptionalExpression(context, logger, template.restrictParentScroll, data, "restrict_parent_scroll", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, RESTRICT_PARENT_SCROLL_DEFAULT_VALUE) ?: RESTRICT_PARENT_SCROLL_DEFAULT_VALUE,
                reuseId = JsonFieldResolver.resolveOptionalExpression(context, logger, template.reuseId, data, "reuse_id", TYPE_HELPER_STRING),
                rowSpan = JsonFieldResolver.resolveOptionalExpression(context, logger, template.rowSpan, data, "row_span", TYPE_HELPER_INT, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectedActions = JsonFieldResolver.resolveOptionalList(context, logger, template.selectedActions, data, "selected_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                selectedTab = JsonFieldResolver.resolveOptionalExpression(context, logger, template.selectedTab, data, "selected_tab", TYPE_HELPER_INT, NUMBER_TO_INT, SELECTED_TAB_VALIDATOR, SELECTED_TAB_DEFAULT_VALUE) ?: SELECTED_TAB_DEFAULT_VALUE,
                separatorColor = JsonFieldResolver.resolveOptionalExpression(context, logger, template.separatorColor, data, "separator_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, SEPARATOR_COLOR_DEFAULT_VALUE) ?: SEPARATOR_COLOR_DEFAULT_VALUE,
                separatorPaddings = JsonFieldResolver.resolveOptional(context, logger, template.separatorPaddings, data, "separator_paddings", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser) ?: SEPARATOR_PADDINGS_DEFAULT_VALUE,
                switchTabsByContentSwipeEnabled = JsonFieldResolver.resolveOptionalExpression(context, logger, template.switchTabsByContentSwipeEnabled, data, "switch_tabs_by_content_swipe_enabled", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, SWITCH_TABS_BY_CONTENT_SWIPE_ENABLED_DEFAULT_VALUE) ?: SWITCH_TABS_BY_CONTENT_SWIPE_ENABLED_DEFAULT_VALUE,
                tabTitleDelimiter = JsonFieldResolver.resolveOptional(context, logger, template.tabTitleDelimiter, data, "tab_title_delimiter", component.divTabsTabTitleDelimiterJsonTemplateResolver, component.divTabsTabTitleDelimiterJsonEntityParser),
                tabTitleStyle = JsonFieldResolver.resolveOptional(context, logger, template.tabTitleStyle, data, "tab_title_style", component.divTabsTabTitleStyleJsonTemplateResolver, component.divTabsTabTitleStyleJsonEntityParser),
                titlePaddings = JsonFieldResolver.resolveOptional(context, logger, template.titlePaddings, data, "title_paddings", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser) ?: TITLE_PADDINGS_DEFAULT_VALUE,
                tooltips = JsonFieldResolver.resolveOptionalList(context, logger, template.tooltips, data, "tooltips", component.divTooltipJsonTemplateResolver, component.divTooltipJsonEntityParser),
                transform = JsonFieldResolver.resolveOptional(context, logger, template.transform, data, "transform", component.divTransformJsonTemplateResolver, component.divTransformJsonEntityParser),
                transitionChange = JsonFieldResolver.resolveOptional(context, logger, template.transitionChange, data, "transition_change", component.divChangeTransitionJsonTemplateResolver, component.divChangeTransitionJsonEntityParser),
                transitionIn = JsonFieldResolver.resolveOptional(context, logger, template.transitionIn, data, "transition_in", component.divAppearanceTransitionJsonTemplateResolver, component.divAppearanceTransitionJsonEntityParser),
                transitionOut = JsonFieldResolver.resolveOptional(context, logger, template.transitionOut, data, "transition_out", component.divAppearanceTransitionJsonTemplateResolver, component.divAppearanceTransitionJsonEntityParser),
                transitionTriggers = JsonFieldResolver.resolveOptionalList(context, logger, template.transitionTriggers, data, "transition_triggers", DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR),
                variableTriggers = JsonFieldResolver.resolveOptionalList(context, logger, template.variableTriggers, data, "variable_triggers", component.divTriggerJsonTemplateResolver, component.divTriggerJsonEntityParser),
                variables = JsonFieldResolver.resolveOptionalList(context, logger, template.variables, data, "variables", component.divVariableJsonTemplateResolver, component.divVariableJsonEntityParser),
                visibility = JsonFieldResolver.resolveOptionalExpression(context, logger, template.visibility, data, "visibility", TYPE_HELPER_VISIBILITY, DivVisibility.FROM_STRING, VISIBILITY_DEFAULT_VALUE) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonFieldResolver.resolveOptional(context, logger, template.visibilityAction, data, "visibility_action", component.divVisibilityActionJsonTemplateResolver, component.divVisibilityActionJsonEntityParser),
                visibilityActions = JsonFieldResolver.resolveOptionalList(context, logger, template.visibilityActions, data, "visibility_actions", component.divVisibilityActionJsonTemplateResolver, component.divVisibilityActionJsonEntityParser),
                width = JsonFieldResolver.resolveOptional(context, logger, template.width, data, "width", component.divSizeJsonTemplateResolver, component.divSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }
    }

    private companion object {

        @JvmField val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        @JvmField val DYNAMIC_HEIGHT_DEFAULT_VALUE = Expression.constant(false)
        @JvmField val HAS_SEPARATOR_DEFAULT_VALUE = Expression.constant(false)
        @JvmField val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        @JvmField val RESTRICT_PARENT_SCROLL_DEFAULT_VALUE = Expression.constant(false)
        @JvmField val SELECTED_TAB_DEFAULT_VALUE = Expression.constant(0L)
        @JvmField val SEPARATOR_COLOR_DEFAULT_VALUE = Expression.constant(0x14000000.toInt())
        @JvmField val SEPARATOR_PADDINGS_DEFAULT_VALUE = DivEdgeInsets(bottom = Expression.constant(0L), left = Expression.constant(12L), right = Expression.constant(12L), top = Expression.constant(0L))
        @JvmField val SWITCH_TABS_BY_CONTENT_SWIPE_ENABLED_DEFAULT_VALUE = Expression.constant(true)
        @JvmField val TITLE_PADDINGS_DEFAULT_VALUE = DivEdgeInsets(bottom = Expression.constant(8L), left = Expression.constant(12L), right = Expression.constant(12L), top = Expression.constant(0L))
        @JvmField val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        @JvmField val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        @JvmField val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        @JvmField val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        @JvmField val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmField val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        @JvmField val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val ITEMS_VALIDATOR = ListValidator<DivTabs.Item> { it: List<*> -> it.size >= 1 }
        @JvmField val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val SELECTED_TAB_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
    }
}

internal class DivTabsTabTitleStyleJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivTabs.TabTitleStyle> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivTabs.TabTitleStyle {
            val logger = context.logger
            return DivTabs.TabTitleStyle(
                activeBackgroundColor = JsonExpressionParser.readOptionalExpression(context, logger, data, "active_background_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, ACTIVE_BACKGROUND_COLOR_DEFAULT_VALUE) ?: ACTIVE_BACKGROUND_COLOR_DEFAULT_VALUE,
                activeFontWeight = JsonExpressionParser.readOptionalExpression(context, logger, data, "active_font_weight", TYPE_HELPER_ACTIVE_FONT_WEIGHT, DivFontWeight.FROM_STRING),
                activeTextColor = JsonExpressionParser.readOptionalExpression(context, logger, data, "active_text_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, ACTIVE_TEXT_COLOR_DEFAULT_VALUE) ?: ACTIVE_TEXT_COLOR_DEFAULT_VALUE,
                animationDuration = JsonExpressionParser.readOptionalExpression(context, logger, data, "animation_duration", TYPE_HELPER_INT, NUMBER_TO_INT, ANIMATION_DURATION_VALIDATOR, ANIMATION_DURATION_DEFAULT_VALUE) ?: ANIMATION_DURATION_DEFAULT_VALUE,
                animationType = JsonExpressionParser.readOptionalExpression(context, logger, data, "animation_type", TYPE_HELPER_ANIMATION_TYPE, DivTabs.TabTitleStyle.AnimationType.FROM_STRING, ANIMATION_TYPE_DEFAULT_VALUE) ?: ANIMATION_TYPE_DEFAULT_VALUE,
                cornerRadius = JsonExpressionParser.readOptionalExpression(context, logger, data, "corner_radius", TYPE_HELPER_INT, NUMBER_TO_INT, CORNER_RADIUS_VALIDATOR),
                cornersRadius = JsonPropertyParser.readOptional(context, logger, data, "corners_radius", component.divCornersRadiusJsonEntityParser),
                fontFamily = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_family", TYPE_HELPER_STRING),
                fontSize = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_size", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_SIZE_VALIDATOR, FONT_SIZE_DEFAULT_VALUE) ?: FONT_SIZE_DEFAULT_VALUE,
                fontSizeUnit = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_size_unit", TYPE_HELPER_FONT_SIZE_UNIT, DivSizeUnit.FROM_STRING, FONT_SIZE_UNIT_DEFAULT_VALUE) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                fontWeight = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_weight", TYPE_HELPER_FONT_WEIGHT, DivFontWeight.FROM_STRING, FONT_WEIGHT_DEFAULT_VALUE) ?: FONT_WEIGHT_DEFAULT_VALUE,
                inactiveBackgroundColor = JsonExpressionParser.readOptionalExpression(context, logger, data, "inactive_background_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
                inactiveFontWeight = JsonExpressionParser.readOptionalExpression(context, logger, data, "inactive_font_weight", TYPE_HELPER_INACTIVE_FONT_WEIGHT, DivFontWeight.FROM_STRING),
                inactiveTextColor = JsonExpressionParser.readOptionalExpression(context, logger, data, "inactive_text_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, INACTIVE_TEXT_COLOR_DEFAULT_VALUE) ?: INACTIVE_TEXT_COLOR_DEFAULT_VALUE,
                itemSpacing = JsonExpressionParser.readOptionalExpression(context, logger, data, "item_spacing", TYPE_HELPER_INT, NUMBER_TO_INT, ITEM_SPACING_VALIDATOR, ITEM_SPACING_DEFAULT_VALUE) ?: ITEM_SPACING_DEFAULT_VALUE,
                letterSpacing = JsonExpressionParser.readOptionalExpression(context, logger, data, "letter_spacing", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, LETTER_SPACING_DEFAULT_VALUE) ?: LETTER_SPACING_DEFAULT_VALUE,
                lineHeight = JsonExpressionParser.readOptionalExpression(context, logger, data, "line_height", TYPE_HELPER_INT, NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR),
                paddings = JsonPropertyParser.readOptional(context, logger, data, "paddings", component.divEdgeInsetsJsonEntityParser) ?: PADDINGS_DEFAULT_VALUE,
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTabs.TabTitleStyle): JSONObject {
            val data = JSONObject()
            data.writeExpression(key = "active_background_color", value = value.activeBackgroundColor, converter = COLOR_INT_TO_STRING)
            data.writeExpression(key = "active_font_weight", value = value.activeFontWeight, converter = DivFontWeight.TO_STRING)
            data.writeExpression(key = "active_text_color", value = value.activeTextColor, converter = COLOR_INT_TO_STRING)
            data.writeExpression(key = "animation_duration", value = value.animationDuration)
            data.writeExpression(key = "animation_type", value = value.animationType, converter = DivTabs.TabTitleStyle.AnimationType.TO_STRING)
            data.writeExpression(key = "corner_radius", value = value.cornerRadius)
            data.write(key = "corners_radius", value = component.divCornersRadiusJsonEntityParser.value.serialize(context, value.cornersRadius))
            data.writeExpression(key = "font_family", value = value.fontFamily)
            data.writeExpression(key = "font_size", value = value.fontSize)
            data.writeExpression(key = "font_size_unit", value = value.fontSizeUnit, converter = DivSizeUnit.TO_STRING)
            data.writeExpression(key = "font_weight", value = value.fontWeight, converter = DivFontWeight.TO_STRING)
            data.writeExpression(key = "inactive_background_color", value = value.inactiveBackgroundColor, converter = COLOR_INT_TO_STRING)
            data.writeExpression(key = "inactive_font_weight", value = value.inactiveFontWeight, converter = DivFontWeight.TO_STRING)
            data.writeExpression(key = "inactive_text_color", value = value.inactiveTextColor, converter = COLOR_INT_TO_STRING)
            data.writeExpression(key = "item_spacing", value = value.itemSpacing)
            data.writeExpression(key = "letter_spacing", value = value.letterSpacing)
            data.writeExpression(key = "line_height", value = value.lineHeight)
            data.write(key = "paddings", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.paddings))
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivTabsTemplate.TabTitleStyleTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivTabsTemplate.TabTitleStyleTemplate?, data: JSONObject): DivTabsTemplate.TabTitleStyleTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivTabsTemplate.TabTitleStyleTemplate(
                activeBackgroundColor = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "active_background_color", TYPE_HELPER_COLOR, allowOverride, parent?.activeBackgroundColor, STRING_TO_COLOR_INT),
                activeFontWeight = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "active_font_weight", TYPE_HELPER_ACTIVE_FONT_WEIGHT, allowOverride, parent?.activeFontWeight, DivFontWeight.FROM_STRING),
                activeTextColor = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "active_text_color", TYPE_HELPER_COLOR, allowOverride, parent?.activeTextColor, STRING_TO_COLOR_INT),
                animationDuration = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "animation_duration", TYPE_HELPER_INT, allowOverride, parent?.animationDuration, NUMBER_TO_INT, ANIMATION_DURATION_VALIDATOR),
                animationType = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "animation_type", TYPE_HELPER_ANIMATION_TYPE, allowOverride, parent?.animationType, DivTabs.TabTitleStyle.AnimationType.FROM_STRING),
                cornerRadius = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "corner_radius", TYPE_HELPER_INT, allowOverride, parent?.cornerRadius, NUMBER_TO_INT, CORNER_RADIUS_VALIDATOR),
                cornersRadius = JsonFieldParser.readOptionalField(context, logger, data, "corners_radius", allowOverride, parent?.cornersRadius, component.divCornersRadiusJsonTemplateParser),
                fontFamily = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_family", TYPE_HELPER_STRING, allowOverride, parent?.fontFamily),
                fontSize = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_size", TYPE_HELPER_INT, allowOverride, parent?.fontSize, NUMBER_TO_INT, FONT_SIZE_VALIDATOR),
                fontSizeUnit = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_size_unit", TYPE_HELPER_FONT_SIZE_UNIT, allowOverride, parent?.fontSizeUnit, DivSizeUnit.FROM_STRING),
                fontWeight = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_weight", TYPE_HELPER_FONT_WEIGHT, allowOverride, parent?.fontWeight, DivFontWeight.FROM_STRING),
                inactiveBackgroundColor = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "inactive_background_color", TYPE_HELPER_COLOR, allowOverride, parent?.inactiveBackgroundColor, STRING_TO_COLOR_INT),
                inactiveFontWeight = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "inactive_font_weight", TYPE_HELPER_INACTIVE_FONT_WEIGHT, allowOverride, parent?.inactiveFontWeight, DivFontWeight.FROM_STRING),
                inactiveTextColor = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "inactive_text_color", TYPE_HELPER_COLOR, allowOverride, parent?.inactiveTextColor, STRING_TO_COLOR_INT),
                itemSpacing = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "item_spacing", TYPE_HELPER_INT, allowOverride, parent?.itemSpacing, NUMBER_TO_INT, ITEM_SPACING_VALIDATOR),
                letterSpacing = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "letter_spacing", TYPE_HELPER_DOUBLE, allowOverride, parent?.letterSpacing, NUMBER_TO_DOUBLE),
                lineHeight = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "line_height", TYPE_HELPER_INT, allowOverride, parent?.lineHeight, NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR),
                paddings = JsonFieldParser.readOptionalField(context, logger, data, "paddings", allowOverride, parent?.paddings, component.divEdgeInsetsJsonTemplateParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTabsTemplate.TabTitleStyleTemplate): JSONObject {
            val data = JSONObject()
            data.writeFieldWithExpression(key = "active_background_color", field = value.activeBackgroundColor, converter = COLOR_INT_TO_STRING)
            data.writeFieldWithExpression(key = "active_font_weight", field = value.activeFontWeight, converter = DivFontWeight.TO_STRING)
            data.writeFieldWithExpression(key = "active_text_color", field = value.activeTextColor, converter = COLOR_INT_TO_STRING)
            data.writeFieldWithExpression(key = "animation_duration", field = value.animationDuration)
            data.writeFieldWithExpression(key = "animation_type", field = value.animationType, converter = DivTabs.TabTitleStyle.AnimationType.TO_STRING)
            data.writeFieldWithExpression(key = "corner_radius", field = value.cornerRadius)
            data.writeField(key = "corners_radius", field = value.cornersRadius, converter = component.divCornersRadiusJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "font_family", field = value.fontFamily)
            data.writeFieldWithExpression(key = "font_size", field = value.fontSize)
            data.writeFieldWithExpression(key = "font_size_unit", field = value.fontSizeUnit, converter = DivSizeUnit.TO_STRING)
            data.writeFieldWithExpression(key = "font_weight", field = value.fontWeight, converter = DivFontWeight.TO_STRING)
            data.writeFieldWithExpression(key = "inactive_background_color", field = value.inactiveBackgroundColor, converter = COLOR_INT_TO_STRING)
            data.writeFieldWithExpression(key = "inactive_font_weight", field = value.inactiveFontWeight, converter = DivFontWeight.TO_STRING)
            data.writeFieldWithExpression(key = "inactive_text_color", field = value.inactiveTextColor, converter = COLOR_INT_TO_STRING)
            data.writeFieldWithExpression(key = "item_spacing", field = value.itemSpacing)
            data.writeFieldWithExpression(key = "letter_spacing", field = value.letterSpacing)
            data.writeFieldWithExpression(key = "line_height", field = value.lineHeight)
            data.writeField(key = "paddings", field = value.paddings, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivTabsTemplate.TabTitleStyleTemplate, DivTabs.TabTitleStyle> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivTabsTemplate.TabTitleStyleTemplate, data: JSONObject): DivTabs.TabTitleStyle {
            val logger = context.logger
            return DivTabs.TabTitleStyle(
                activeBackgroundColor = JsonFieldResolver.resolveOptionalExpression(context, logger, template.activeBackgroundColor, data, "active_background_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, ACTIVE_BACKGROUND_COLOR_DEFAULT_VALUE) ?: ACTIVE_BACKGROUND_COLOR_DEFAULT_VALUE,
                activeFontWeight = JsonFieldResolver.resolveOptionalExpression(context, logger, template.activeFontWeight, data, "active_font_weight", TYPE_HELPER_ACTIVE_FONT_WEIGHT, DivFontWeight.FROM_STRING),
                activeTextColor = JsonFieldResolver.resolveOptionalExpression(context, logger, template.activeTextColor, data, "active_text_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, ACTIVE_TEXT_COLOR_DEFAULT_VALUE) ?: ACTIVE_TEXT_COLOR_DEFAULT_VALUE,
                animationDuration = JsonFieldResolver.resolveOptionalExpression(context, logger, template.animationDuration, data, "animation_duration", TYPE_HELPER_INT, NUMBER_TO_INT, ANIMATION_DURATION_VALIDATOR, ANIMATION_DURATION_DEFAULT_VALUE) ?: ANIMATION_DURATION_DEFAULT_VALUE,
                animationType = JsonFieldResolver.resolveOptionalExpression(context, logger, template.animationType, data, "animation_type", TYPE_HELPER_ANIMATION_TYPE, DivTabs.TabTitleStyle.AnimationType.FROM_STRING, ANIMATION_TYPE_DEFAULT_VALUE) ?: ANIMATION_TYPE_DEFAULT_VALUE,
                cornerRadius = JsonFieldResolver.resolveOptionalExpression(context, logger, template.cornerRadius, data, "corner_radius", TYPE_HELPER_INT, NUMBER_TO_INT, CORNER_RADIUS_VALIDATOR),
                cornersRadius = JsonFieldResolver.resolveOptional(context, logger, template.cornersRadius, data, "corners_radius", component.divCornersRadiusJsonTemplateResolver, component.divCornersRadiusJsonEntityParser),
                fontFamily = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontFamily, data, "font_family", TYPE_HELPER_STRING),
                fontSize = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontSize, data, "font_size", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_SIZE_VALIDATOR, FONT_SIZE_DEFAULT_VALUE) ?: FONT_SIZE_DEFAULT_VALUE,
                fontSizeUnit = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontSizeUnit, data, "font_size_unit", TYPE_HELPER_FONT_SIZE_UNIT, DivSizeUnit.FROM_STRING, FONT_SIZE_UNIT_DEFAULT_VALUE) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                fontWeight = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontWeight, data, "font_weight", TYPE_HELPER_FONT_WEIGHT, DivFontWeight.FROM_STRING, FONT_WEIGHT_DEFAULT_VALUE) ?: FONT_WEIGHT_DEFAULT_VALUE,
                inactiveBackgroundColor = JsonFieldResolver.resolveOptionalExpression(context, logger, template.inactiveBackgroundColor, data, "inactive_background_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
                inactiveFontWeight = JsonFieldResolver.resolveOptionalExpression(context, logger, template.inactiveFontWeight, data, "inactive_font_weight", TYPE_HELPER_INACTIVE_FONT_WEIGHT, DivFontWeight.FROM_STRING),
                inactiveTextColor = JsonFieldResolver.resolveOptionalExpression(context, logger, template.inactiveTextColor, data, "inactive_text_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, INACTIVE_TEXT_COLOR_DEFAULT_VALUE) ?: INACTIVE_TEXT_COLOR_DEFAULT_VALUE,
                itemSpacing = JsonFieldResolver.resolveOptionalExpression(context, logger, template.itemSpacing, data, "item_spacing", TYPE_HELPER_INT, NUMBER_TO_INT, ITEM_SPACING_VALIDATOR, ITEM_SPACING_DEFAULT_VALUE) ?: ITEM_SPACING_DEFAULT_VALUE,
                letterSpacing = JsonFieldResolver.resolveOptionalExpression(context, logger, template.letterSpacing, data, "letter_spacing", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, LETTER_SPACING_DEFAULT_VALUE) ?: LETTER_SPACING_DEFAULT_VALUE,
                lineHeight = JsonFieldResolver.resolveOptionalExpression(context, logger, template.lineHeight, data, "line_height", TYPE_HELPER_INT, NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR),
                paddings = JsonFieldResolver.resolveOptional(context, logger, template.paddings, data, "paddings", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser) ?: PADDINGS_DEFAULT_VALUE,
            )
        }
    }

    private companion object {

        @JvmField val ACTIVE_BACKGROUND_COLOR_DEFAULT_VALUE = Expression.constant(0xFFFFDC60.toInt())
        @JvmField val ACTIVE_TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0xCC000000.toInt())
        @JvmField val ANIMATION_DURATION_DEFAULT_VALUE = Expression.constant(300L)
        @JvmField val ANIMATION_TYPE_DEFAULT_VALUE = Expression.constant(DivTabs.TabTitleStyle.AnimationType.SLIDE)
        @JvmField val FONT_SIZE_DEFAULT_VALUE = Expression.constant(12L)
        @JvmField val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)
        @JvmField val FONT_WEIGHT_DEFAULT_VALUE = Expression.constant(DivFontWeight.REGULAR)
        @JvmField val INACTIVE_TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0x80000000.toInt())
        @JvmField val ITEM_SPACING_DEFAULT_VALUE = Expression.constant(0L)
        @JvmField val LETTER_SPACING_DEFAULT_VALUE = Expression.constant(0.0)
        @JvmField val PADDINGS_DEFAULT_VALUE = DivEdgeInsets(bottom = Expression.constant(6L), left = Expression.constant(8L), right = Expression.constant(8L), top = Expression.constant(6L))

        @JvmField val TYPE_HELPER_ACTIVE_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }
        @JvmField val TYPE_HELPER_ANIMATION_TYPE = TypeHelper.from(default = DivTabs.TabTitleStyle.AnimationType.values().first()) { it is DivTabs.TabTitleStyle.AnimationType }
        @JvmField val TYPE_HELPER_FONT_SIZE_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }
        @JvmField val TYPE_HELPER_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }
        @JvmField val TYPE_HELPER_INACTIVE_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }

        @JvmField val ANIMATION_DURATION_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val CORNER_RADIUS_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val FONT_SIZE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val ITEM_SPACING_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val LINE_HEIGHT_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
    }
}

internal class DivTabsTabTitleDelimiterJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivTabs.TabTitleDelimiter> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivTabs.TabTitleDelimiter {
            val logger = context.logger
            return DivTabs.TabTitleDelimiter(
                height = JsonPropertyParser.readOptional(context, logger, data, "height", component.divFixedSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                imageUrl = JsonExpressionParser.readExpression(context, logger, data, "image_url", TYPE_HELPER_URI, ANY_TO_URI),
                width = JsonPropertyParser.readOptional(context, logger, data, "width", component.divFixedSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTabs.TabTitleDelimiter): JSONObject {
            val data = JSONObject()
            data.write(key = "height", value = component.divFixedSizeJsonEntityParser.value.serialize(context, value.height))
            data.writeExpression(key = "image_url", value = value.imageUrl, converter = URI_TO_STRING)
            data.write(key = "width", value = component.divFixedSizeJsonEntityParser.value.serialize(context, value.width))
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivTabsTemplate.TabTitleDelimiterTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivTabsTemplate.TabTitleDelimiterTemplate?, data: JSONObject): DivTabsTemplate.TabTitleDelimiterTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivTabsTemplate.TabTitleDelimiterTemplate(
                height = JsonFieldParser.readOptionalField(context, logger, data, "height", allowOverride, parent?.height, component.divFixedSizeJsonTemplateParser),
                imageUrl = JsonFieldParser.readFieldWithExpression(context, logger, data, "image_url", TYPE_HELPER_URI, allowOverride, parent?.imageUrl, ANY_TO_URI),
                width = JsonFieldParser.readOptionalField(context, logger, data, "width", allowOverride, parent?.width, component.divFixedSizeJsonTemplateParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTabsTemplate.TabTitleDelimiterTemplate): JSONObject {
            val data = JSONObject()
            data.writeField(key = "height", field = value.height, converter = component.divFixedSizeJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "image_url", field = value.imageUrl, converter = URI_TO_STRING)
            data.writeField(key = "width", field = value.width, converter = component.divFixedSizeJsonTemplateParser.value.asConverter(context))
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivTabsTemplate.TabTitleDelimiterTemplate, DivTabs.TabTitleDelimiter> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivTabsTemplate.TabTitleDelimiterTemplate, data: JSONObject): DivTabs.TabTitleDelimiter {
            val logger = context.logger
            return DivTabs.TabTitleDelimiter(
                height = JsonFieldResolver.resolveOptional(context, logger, template.height, data, "height", component.divFixedSizeJsonTemplateResolver, component.divFixedSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                imageUrl = JsonFieldResolver.resolveExpression(context, logger, template.imageUrl, data, "image_url", TYPE_HELPER_URI, ANY_TO_URI),
                width = JsonFieldResolver.resolveOptional(context, logger, template.width, data, "width", component.divFixedSizeJsonTemplateResolver, component.divFixedSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }
    }

    private companion object {

        @JvmField val HEIGHT_DEFAULT_VALUE = DivFixedSize(value = Expression.constant(12L))
        @JvmField val WIDTH_DEFAULT_VALUE = DivFixedSize(value = Expression.constant(12L))
    }
}

internal class DivTabsItemJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivTabs.Item> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivTabs.Item {
            val logger = context.logger
            return DivTabs.Item(
                div = JsonPropertyParser.read(context, logger, data, "div", component.divJsonEntityParser),
                title = JsonExpressionParser.readExpression(context, logger, data, "title", TYPE_HELPER_STRING),
                titleClickAction = JsonPropertyParser.readOptional(context, logger, data, "title_click_action", component.divActionJsonEntityParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTabs.Item): JSONObject {
            val data = JSONObject()
            data.write(key = "div", value = component.divJsonEntityParser.value.serialize(context, value.div))
            data.writeExpression(key = "title", value = value.title)
            data.write(key = "title_click_action", value = component.divActionJsonEntityParser.value.serialize(context, value.titleClickAction))
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivTabsTemplate.ItemTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivTabsTemplate.ItemTemplate?, data: JSONObject): DivTabsTemplate.ItemTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivTabsTemplate.ItemTemplate(
                div = JsonFieldParser.readField(context, logger, data, "div", allowOverride, parent?.div, component.divJsonTemplateParser),
                title = JsonFieldParser.readFieldWithExpression(context, logger, data, "title", TYPE_HELPER_STRING, allowOverride, parent?.title),
                titleClickAction = JsonFieldParser.readOptionalField(context, logger, data, "title_click_action", allowOverride, parent?.titleClickAction, component.divActionJsonTemplateParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTabsTemplate.ItemTemplate): JSONObject {
            val data = JSONObject()
            data.writeField(key = "div", field = value.div, converter = component.divJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "title", field = value.title)
            data.writeField(key = "title_click_action", field = value.titleClickAction, converter = component.divActionJsonTemplateParser.value.asConverter(context))
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivTabsTemplate.ItemTemplate, DivTabs.Item> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivTabsTemplate.ItemTemplate, data: JSONObject): DivTabs.Item {
            val logger = context.logger
            return DivTabs.Item(
                div = JsonFieldResolver.resolve(context, logger, template.div, data, "div", component.divJsonTemplateResolver, component.divJsonEntityParser),
                title = JsonFieldResolver.resolveExpression(context, logger, template.title, data, "title", TYPE_HELPER_STRING),
                titleClickAction = JsonFieldResolver.resolveOptional(context, logger, template.titleClickAction, data, "title_click_action", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
            )
        }
    }
}
