// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivTextJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivText> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivText {
            val logger = context.logger
            return DivText(
                accessibility = JsonPropertyParser.readOptional(context, logger, data, "accessibility", component.divAccessibilityJsonEntityParser),
                action = JsonPropertyParser.readOptional(context, logger, data, "action", component.divActionJsonEntityParser),
                actionAnimation = JsonPropertyParser.readOptional(context, logger, data, "action_animation", component.divAnimationJsonEntityParser) ?: ACTION_ANIMATION_DEFAULT_VALUE,
                actions = JsonPropertyParser.readOptionalList(context, logger, data, "actions", component.divActionJsonEntityParser),
                alignmentHorizontal = JsonExpressionParser.readOptionalExpression(context, logger, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonExpressionParser.readOptionalExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING),
                alpha = JsonExpressionParser.readOptionalExpression(context, logger, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                animators = JsonPropertyParser.readOptionalList(context, logger, data, "animators", component.divAnimatorJsonEntityParser),
                autoEllipsize = JsonExpressionParser.readOptionalExpression(context, logger, data, "auto_ellipsize", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN),
                background = JsonPropertyParser.readOptionalList(context, logger, data, "background", component.divBackgroundJsonEntityParser),
                border = JsonPropertyParser.readOptional(context, logger, data, "border", component.divBorderJsonEntityParser),
                columnSpan = JsonExpressionParser.readOptionalExpression(context, logger, data, "column_span", TYPE_HELPER_INT, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                disappearActions = JsonPropertyParser.readOptionalList(context, logger, data, "disappear_actions", component.divDisappearActionJsonEntityParser),
                doubletapActions = JsonPropertyParser.readOptionalList(context, logger, data, "doubletap_actions", component.divActionJsonEntityParser),
                ellipsis = JsonPropertyParser.readOptional(context, logger, data, "ellipsis", component.divTextEllipsisJsonEntityParser),
                extensions = JsonPropertyParser.readOptionalList(context, logger, data, "extensions", component.divExtensionJsonEntityParser),
                focus = JsonPropertyParser.readOptional(context, logger, data, "focus", component.divFocusJsonEntityParser),
                focusedTextColor = JsonExpressionParser.readOptionalExpression(context, logger, data, "focused_text_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
                fontFamily = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_family", TYPE_HELPER_STRING),
                fontFeatureSettings = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_feature_settings", TYPE_HELPER_STRING),
                fontSize = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_size", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_SIZE_VALIDATOR, FONT_SIZE_DEFAULT_VALUE) ?: FONT_SIZE_DEFAULT_VALUE,
                fontSizeUnit = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_size_unit", TYPE_HELPER_FONT_SIZE_UNIT, DivSizeUnit.FROM_STRING, FONT_SIZE_UNIT_DEFAULT_VALUE) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                fontWeight = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_weight", TYPE_HELPER_FONT_WEIGHT, DivFontWeight.FROM_STRING, FONT_WEIGHT_DEFAULT_VALUE) ?: FONT_WEIGHT_DEFAULT_VALUE,
                fontWeightValue = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_weight_value", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_WEIGHT_VALUE_VALIDATOR),
                functions = JsonPropertyParser.readOptionalList(context, logger, data, "functions", component.divFunctionJsonEntityParser),
                height = JsonPropertyParser.readOptional(context, logger, data, "height", component.divSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                hoverEndActions = JsonPropertyParser.readOptionalList(context, logger, data, "hover_end_actions", component.divActionJsonEntityParser),
                hoverStartActions = JsonPropertyParser.readOptionalList(context, logger, data, "hover_start_actions", component.divActionJsonEntityParser),
                id = JsonPropertyParser.readOptional(context, logger, data, "id"),
                images = JsonPropertyParser.readOptionalList(context, logger, data, "images", component.divTextImageJsonEntityParser),
                layoutProvider = JsonPropertyParser.readOptional(context, logger, data, "layout_provider", component.divLayoutProviderJsonEntityParser),
                letterSpacing = JsonExpressionParser.readOptionalExpression(context, logger, data, "letter_spacing", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, LETTER_SPACING_DEFAULT_VALUE) ?: LETTER_SPACING_DEFAULT_VALUE,
                lineHeight = JsonExpressionParser.readOptionalExpression(context, logger, data, "line_height", TYPE_HELPER_INT, NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR),
                longtapActions = JsonPropertyParser.readOptionalList(context, logger, data, "longtap_actions", component.divActionJsonEntityParser),
                margins = JsonPropertyParser.readOptional(context, logger, data, "margins", component.divEdgeInsetsJsonEntityParser),
                maxLines = JsonExpressionParser.readOptionalExpression(context, logger, data, "max_lines", TYPE_HELPER_INT, NUMBER_TO_INT, MAX_LINES_VALIDATOR),
                minHiddenLines = JsonExpressionParser.readOptionalExpression(context, logger, data, "min_hidden_lines", TYPE_HELPER_INT, NUMBER_TO_INT, MIN_HIDDEN_LINES_VALIDATOR),
                paddings = JsonPropertyParser.readOptional(context, logger, data, "paddings", component.divEdgeInsetsJsonEntityParser),
                pressEndActions = JsonPropertyParser.readOptionalList(context, logger, data, "press_end_actions", component.divActionJsonEntityParser),
                pressStartActions = JsonPropertyParser.readOptionalList(context, logger, data, "press_start_actions", component.divActionJsonEntityParser),
                ranges = JsonPropertyParser.readOptionalList(context, logger, data, "ranges", component.divTextRangeJsonEntityParser),
                reuseId = JsonExpressionParser.readOptionalExpression(context, logger, data, "reuse_id", TYPE_HELPER_STRING),
                rowSpan = JsonExpressionParser.readOptionalExpression(context, logger, data, "row_span", TYPE_HELPER_INT, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectable = JsonExpressionParser.readOptionalExpression(context, logger, data, "selectable", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, SELECTABLE_DEFAULT_VALUE) ?: SELECTABLE_DEFAULT_VALUE,
                selectedActions = JsonPropertyParser.readOptionalList(context, logger, data, "selected_actions", component.divActionJsonEntityParser),
                strike = JsonExpressionParser.readOptionalExpression(context, logger, data, "strike", TYPE_HELPER_STRIKE, DivLineStyle.FROM_STRING, STRIKE_DEFAULT_VALUE) ?: STRIKE_DEFAULT_VALUE,
                text = JsonExpressionParser.readExpression(context, logger, data, "text", TYPE_HELPER_STRING),
                textAlignmentHorizontal = JsonExpressionParser.readOptionalExpression(context, logger, data, "text_alignment_horizontal", TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING, TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE) ?: TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE,
                textAlignmentVertical = JsonExpressionParser.readOptionalExpression(context, logger, data, "text_alignment_vertical", TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING, TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE) ?: TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE,
                textColor = JsonExpressionParser.readOptionalExpression(context, logger, data, "text_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, TEXT_COLOR_DEFAULT_VALUE) ?: TEXT_COLOR_DEFAULT_VALUE,
                textGradient = JsonPropertyParser.readOptional(context, logger, data, "text_gradient", component.divTextGradientJsonEntityParser),
                textShadow = JsonPropertyParser.readOptional(context, logger, data, "text_shadow", component.divShadowJsonEntityParser),
                tightenWidth = JsonExpressionParser.readOptionalExpression(context, logger, data, "tighten_width", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, TIGHTEN_WIDTH_DEFAULT_VALUE) ?: TIGHTEN_WIDTH_DEFAULT_VALUE,
                tooltips = JsonPropertyParser.readOptionalList(context, logger, data, "tooltips", component.divTooltipJsonEntityParser),
                transform = JsonPropertyParser.readOptional(context, logger, data, "transform", component.divTransformJsonEntityParser),
                transitionChange = JsonPropertyParser.readOptional(context, logger, data, "transition_change", component.divChangeTransitionJsonEntityParser),
                transitionIn = JsonPropertyParser.readOptional(context, logger, data, "transition_in", component.divAppearanceTransitionJsonEntityParser),
                transitionOut = JsonPropertyParser.readOptional(context, logger, data, "transition_out", component.divAppearanceTransitionJsonEntityParser),
                transitionTriggers = JsonPropertyParser.readOptionalList(context, logger, data, "transition_triggers", DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR),
                underline = JsonExpressionParser.readOptionalExpression(context, logger, data, "underline", TYPE_HELPER_UNDERLINE, DivLineStyle.FROM_STRING, UNDERLINE_DEFAULT_VALUE) ?: UNDERLINE_DEFAULT_VALUE,
                variableTriggers = JsonPropertyParser.readOptionalList(context, logger, data, "variable_triggers", component.divTriggerJsonEntityParser),
                variables = JsonPropertyParser.readOptionalList(context, logger, data, "variables", component.divVariableJsonEntityParser),
                visibility = JsonExpressionParser.readOptionalExpression(context, logger, data, "visibility", TYPE_HELPER_VISIBILITY, DivVisibility.FROM_STRING, VISIBILITY_DEFAULT_VALUE) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonPropertyParser.readOptional(context, logger, data, "visibility_action", component.divVisibilityActionJsonEntityParser),
                visibilityActions = JsonPropertyParser.readOptionalList(context, logger, data, "visibility_actions", component.divVisibilityActionJsonEntityParser),
                width = JsonPropertyParser.readOptional(context, logger, data, "width", component.divSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivText): JSONObject {
            val data = JSONObject()
            data.write(key = "accessibility", value = component.divAccessibilityJsonEntityParser.value.serialize(context, value.accessibility))
            data.write(key = "action", value = component.divActionJsonEntityParser.value.serialize(context, value.action))
            data.write(key = "action_animation", value = component.divAnimationJsonEntityParser.value.serialize(context, value.actionAnimation))
            data.write(key = "actions", value = component.divActionJsonEntityParser.value.serialize(context, value.actions))
            data.writeExpression(key = "alignment_horizontal", value = value.alignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeExpression(key = "alignment_vertical", value = value.alignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeExpression(key = "alpha", value = value.alpha)
            data.write(key = "animators", value = component.divAnimatorJsonEntityParser.value.serialize(context, value.animators))
            data.writeExpression(key = "auto_ellipsize", value = value.autoEllipsize)
            data.write(key = "background", value = component.divBackgroundJsonEntityParser.value.serialize(context, value.background))
            data.write(key = "border", value = component.divBorderJsonEntityParser.value.serialize(context, value.border))
            data.writeExpression(key = "column_span", value = value.columnSpan)
            data.write(key = "disappear_actions", value = component.divDisappearActionJsonEntityParser.value.serialize(context, value.disappearActions))
            data.write(key = "doubletap_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.doubletapActions))
            data.write(key = "ellipsis", value = component.divTextEllipsisJsonEntityParser.value.serialize(context, value.ellipsis))
            data.write(key = "extensions", value = component.divExtensionJsonEntityParser.value.serialize(context, value.extensions))
            data.write(key = "focus", value = component.divFocusJsonEntityParser.value.serialize(context, value.focus))
            data.writeExpression(key = "focused_text_color", value = value.focusedTextColor, converter = COLOR_INT_TO_STRING)
            data.writeExpression(key = "font_family", value = value.fontFamily)
            data.writeExpression(key = "font_feature_settings", value = value.fontFeatureSettings)
            data.writeExpression(key = "font_size", value = value.fontSize)
            data.writeExpression(key = "font_size_unit", value = value.fontSizeUnit, converter = DivSizeUnit.TO_STRING)
            data.writeExpression(key = "font_weight", value = value.fontWeight, converter = DivFontWeight.TO_STRING)
            data.writeExpression(key = "font_weight_value", value = value.fontWeightValue)
            data.write(key = "functions", value = component.divFunctionJsonEntityParser.value.serialize(context, value.functions))
            data.write(key = "height", value = component.divSizeJsonEntityParser.value.serialize(context, value.height))
            data.write(key = "hover_end_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.hoverEndActions))
            data.write(key = "hover_start_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.hoverStartActions))
            data.write(key = "id", value = value.id)
            data.write(key = "images", value = component.divTextImageJsonEntityParser.value.serialize(context, value.images))
            data.write(key = "layout_provider", value = component.divLayoutProviderJsonEntityParser.value.serialize(context, value.layoutProvider))
            data.writeExpression(key = "letter_spacing", value = value.letterSpacing)
            data.writeExpression(key = "line_height", value = value.lineHeight)
            data.write(key = "longtap_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.longtapActions))
            data.write(key = "margins", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.margins))
            data.writeExpression(key = "max_lines", value = value.maxLines)
            data.writeExpression(key = "min_hidden_lines", value = value.minHiddenLines)
            data.write(key = "paddings", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.paddings))
            data.write(key = "press_end_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.pressEndActions))
            data.write(key = "press_start_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.pressStartActions))
            data.write(key = "ranges", value = component.divTextRangeJsonEntityParser.value.serialize(context, value.ranges))
            data.writeExpression(key = "reuse_id", value = value.reuseId)
            data.writeExpression(key = "row_span", value = value.rowSpan)
            data.writeExpression(key = "selectable", value = value.selectable)
            data.write(key = "selected_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.selectedActions))
            data.writeExpression(key = "strike", value = value.strike, converter = DivLineStyle.TO_STRING)
            data.writeExpression(key = "text", value = value.text)
            data.writeExpression(key = "text_alignment_horizontal", value = value.textAlignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeExpression(key = "text_alignment_vertical", value = value.textAlignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeExpression(key = "text_color", value = value.textColor, converter = COLOR_INT_TO_STRING)
            data.write(key = "text_gradient", value = component.divTextGradientJsonEntityParser.value.serialize(context, value.textGradient))
            data.write(key = "text_shadow", value = component.divShadowJsonEntityParser.value.serialize(context, value.textShadow))
            data.writeExpression(key = "tighten_width", value = value.tightenWidth)
            data.write(key = "tooltips", value = component.divTooltipJsonEntityParser.value.serialize(context, value.tooltips))
            data.write(key = "transform", value = component.divTransformJsonEntityParser.value.serialize(context, value.transform))
            data.write(key = "transition_change", value = component.divChangeTransitionJsonEntityParser.value.serialize(context, value.transitionChange))
            data.write(key = "transition_in", value = component.divAppearanceTransitionJsonEntityParser.value.serialize(context, value.transitionIn))
            data.write(key = "transition_out", value = component.divAppearanceTransitionJsonEntityParser.value.serialize(context, value.transitionOut))
            data.write(key = "transition_triggers", value = value.transitionTriggers, converter = DivTransitionTrigger.TO_STRING)
            data.write(key = "type", value = DivText.TYPE)
            data.writeExpression(key = "underline", value = value.underline, converter = DivLineStyle.TO_STRING)
            data.write(key = "variable_triggers", value = component.divTriggerJsonEntityParser.value.serialize(context, value.variableTriggers))
            data.write(key = "variables", value = component.divVariableJsonEntityParser.value.serialize(context, value.variables))
            data.writeExpression(key = "visibility", value = value.visibility, converter = DivVisibility.TO_STRING)
            data.write(key = "visibility_action", value = component.divVisibilityActionJsonEntityParser.value.serialize(context, value.visibilityAction))
            data.write(key = "visibility_actions", value = component.divVisibilityActionJsonEntityParser.value.serialize(context, value.visibilityActions))
            data.write(key = "width", value = component.divSizeJsonEntityParser.value.serialize(context, value.width))
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivTextTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivTextTemplate?, data: JSONObject): DivTextTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivTextTemplate(
                accessibility = JsonFieldParser.readOptionalField(context, logger, data, "accessibility", allowOverride, parent?.accessibility, component.divAccessibilityJsonTemplateParser),
                action = JsonFieldParser.readOptionalField(context, logger, data, "action", allowOverride, parent?.action, component.divActionJsonTemplateParser),
                actionAnimation = JsonFieldParser.readOptionalField(context, logger, data, "action_animation", allowOverride, parent?.actionAnimation, component.divAnimationJsonTemplateParser),
                actions = JsonFieldParser.readOptionalListField(context, logger, data, "actions", allowOverride, parent?.actions, component.divActionJsonTemplateParser),
                alignmentHorizontal = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, allowOverride, parent?.alignmentHorizontal, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, allowOverride, parent?.alignmentVertical, DivAlignmentVertical.FROM_STRING),
                alpha = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alpha", TYPE_HELPER_DOUBLE, allowOverride, parent?.alpha, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR),
                animators = JsonFieldParser.readOptionalListField(context, logger, data, "animators", allowOverride, parent?.animators, component.divAnimatorJsonTemplateParser),
                autoEllipsize = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "auto_ellipsize", TYPE_HELPER_BOOLEAN, allowOverride, parent?.autoEllipsize, ANY_TO_BOOLEAN),
                background = JsonFieldParser.readOptionalListField(context, logger, data, "background", allowOverride, parent?.background, component.divBackgroundJsonTemplateParser),
                border = JsonFieldParser.readOptionalField(context, logger, data, "border", allowOverride, parent?.border, component.divBorderJsonTemplateParser),
                columnSpan = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "column_span", TYPE_HELPER_INT, allowOverride, parent?.columnSpan, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                disappearActions = JsonFieldParser.readOptionalListField(context, logger, data, "disappear_actions", allowOverride, parent?.disappearActions, component.divDisappearActionJsonTemplateParser),
                doubletapActions = JsonFieldParser.readOptionalListField(context, logger, data, "doubletap_actions", allowOverride, parent?.doubletapActions, component.divActionJsonTemplateParser),
                ellipsis = JsonFieldParser.readOptionalField(context, logger, data, "ellipsis", allowOverride, parent?.ellipsis, component.divTextEllipsisJsonTemplateParser),
                extensions = JsonFieldParser.readOptionalListField(context, logger, data, "extensions", allowOverride, parent?.extensions, component.divExtensionJsonTemplateParser),
                focus = JsonFieldParser.readOptionalField(context, logger, data, "focus", allowOverride, parent?.focus, component.divFocusJsonTemplateParser),
                focusedTextColor = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "focused_text_color", TYPE_HELPER_COLOR, allowOverride, parent?.focusedTextColor, STRING_TO_COLOR_INT),
                fontFamily = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_family", TYPE_HELPER_STRING, allowOverride, parent?.fontFamily),
                fontFeatureSettings = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_feature_settings", TYPE_HELPER_STRING, allowOverride, parent?.fontFeatureSettings),
                fontSize = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_size", TYPE_HELPER_INT, allowOverride, parent?.fontSize, NUMBER_TO_INT, FONT_SIZE_VALIDATOR),
                fontSizeUnit = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_size_unit", TYPE_HELPER_FONT_SIZE_UNIT, allowOverride, parent?.fontSizeUnit, DivSizeUnit.FROM_STRING),
                fontWeight = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_weight", TYPE_HELPER_FONT_WEIGHT, allowOverride, parent?.fontWeight, DivFontWeight.FROM_STRING),
                fontWeightValue = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_weight_value", TYPE_HELPER_INT, allowOverride, parent?.fontWeightValue, NUMBER_TO_INT, FONT_WEIGHT_VALUE_VALIDATOR),
                functions = JsonFieldParser.readOptionalListField(context, logger, data, "functions", allowOverride, parent?.functions, component.divFunctionJsonTemplateParser),
                height = JsonFieldParser.readOptionalField(context, logger, data, "height", allowOverride, parent?.height, component.divSizeJsonTemplateParser),
                hoverEndActions = JsonFieldParser.readOptionalListField(context, logger, data, "hover_end_actions", allowOverride, parent?.hoverEndActions, component.divActionJsonTemplateParser),
                hoverStartActions = JsonFieldParser.readOptionalListField(context, logger, data, "hover_start_actions", allowOverride, parent?.hoverStartActions, component.divActionJsonTemplateParser),
                id = JsonFieldParser.readOptionalField(context, logger, data, "id", allowOverride, parent?.id),
                images = JsonFieldParser.readOptionalListField(context, logger, data, "images", allowOverride, parent?.images, component.divTextImageJsonTemplateParser),
                layoutProvider = JsonFieldParser.readOptionalField(context, logger, data, "layout_provider", allowOverride, parent?.layoutProvider, component.divLayoutProviderJsonTemplateParser),
                letterSpacing = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "letter_spacing", TYPE_HELPER_DOUBLE, allowOverride, parent?.letterSpacing, NUMBER_TO_DOUBLE),
                lineHeight = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "line_height", TYPE_HELPER_INT, allowOverride, parent?.lineHeight, NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR),
                longtapActions = JsonFieldParser.readOptionalListField(context, logger, data, "longtap_actions", allowOverride, parent?.longtapActions, component.divActionJsonTemplateParser),
                margins = JsonFieldParser.readOptionalField(context, logger, data, "margins", allowOverride, parent?.margins, component.divEdgeInsetsJsonTemplateParser),
                maxLines = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "max_lines", TYPE_HELPER_INT, allowOverride, parent?.maxLines, NUMBER_TO_INT, MAX_LINES_VALIDATOR),
                minHiddenLines = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "min_hidden_lines", TYPE_HELPER_INT, allowOverride, parent?.minHiddenLines, NUMBER_TO_INT, MIN_HIDDEN_LINES_VALIDATOR),
                paddings = JsonFieldParser.readOptionalField(context, logger, data, "paddings", allowOverride, parent?.paddings, component.divEdgeInsetsJsonTemplateParser),
                pressEndActions = JsonFieldParser.readOptionalListField(context, logger, data, "press_end_actions", allowOverride, parent?.pressEndActions, component.divActionJsonTemplateParser),
                pressStartActions = JsonFieldParser.readOptionalListField(context, logger, data, "press_start_actions", allowOverride, parent?.pressStartActions, component.divActionJsonTemplateParser),
                ranges = JsonFieldParser.readOptionalListField(context, logger, data, "ranges", allowOverride, parent?.ranges, component.divTextRangeJsonTemplateParser),
                reuseId = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "reuse_id", TYPE_HELPER_STRING, allowOverride, parent?.reuseId),
                rowSpan = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "row_span", TYPE_HELPER_INT, allowOverride, parent?.rowSpan, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectable = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "selectable", TYPE_HELPER_BOOLEAN, allowOverride, parent?.selectable, ANY_TO_BOOLEAN),
                selectedActions = JsonFieldParser.readOptionalListField(context, logger, data, "selected_actions", allowOverride, parent?.selectedActions, component.divActionJsonTemplateParser),
                strike = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "strike", TYPE_HELPER_STRIKE, allowOverride, parent?.strike, DivLineStyle.FROM_STRING),
                text = JsonFieldParser.readFieldWithExpression(context, logger, data, "text", TYPE_HELPER_STRING, allowOverride, parent?.text),
                textAlignmentHorizontal = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "text_alignment_horizontal", TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL, allowOverride, parent?.textAlignmentHorizontal, DivAlignmentHorizontal.FROM_STRING),
                textAlignmentVertical = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "text_alignment_vertical", TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL, allowOverride, parent?.textAlignmentVertical, DivAlignmentVertical.FROM_STRING),
                textColor = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "text_color", TYPE_HELPER_COLOR, allowOverride, parent?.textColor, STRING_TO_COLOR_INT),
                textGradient = JsonFieldParser.readOptionalField(context, logger, data, "text_gradient", allowOverride, parent?.textGradient, component.divTextGradientJsonTemplateParser),
                textShadow = JsonFieldParser.readOptionalField(context, logger, data, "text_shadow", allowOverride, parent?.textShadow, component.divShadowJsonTemplateParser),
                tightenWidth = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "tighten_width", TYPE_HELPER_BOOLEAN, allowOverride, parent?.tightenWidth, ANY_TO_BOOLEAN),
                tooltips = JsonFieldParser.readOptionalListField(context, logger, data, "tooltips", allowOverride, parent?.tooltips, component.divTooltipJsonTemplateParser),
                transform = JsonFieldParser.readOptionalField(context, logger, data, "transform", allowOverride, parent?.transform, component.divTransformJsonTemplateParser),
                transitionChange = JsonFieldParser.readOptionalField(context, logger, data, "transition_change", allowOverride, parent?.transitionChange, component.divChangeTransitionJsonTemplateParser),
                transitionIn = JsonFieldParser.readOptionalField(context, logger, data, "transition_in", allowOverride, parent?.transitionIn, component.divAppearanceTransitionJsonTemplateParser),
                transitionOut = JsonFieldParser.readOptionalField(context, logger, data, "transition_out", allowOverride, parent?.transitionOut, component.divAppearanceTransitionJsonTemplateParser),
                transitionTriggers = JsonFieldParser.readOptionalListField(context, logger, data, "transition_triggers", allowOverride, parent?.transitionTriggers, DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR.cast()),
                underline = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "underline", TYPE_HELPER_UNDERLINE, allowOverride, parent?.underline, DivLineStyle.FROM_STRING),
                variableTriggers = JsonFieldParser.readOptionalListField(context, logger, data, "variable_triggers", allowOverride, parent?.variableTriggers, component.divTriggerJsonTemplateParser),
                variables = JsonFieldParser.readOptionalListField(context, logger, data, "variables", allowOverride, parent?.variables, component.divVariableJsonTemplateParser),
                visibility = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "visibility", TYPE_HELPER_VISIBILITY, allowOverride, parent?.visibility, DivVisibility.FROM_STRING),
                visibilityAction = JsonFieldParser.readOptionalField(context, logger, data, "visibility_action", allowOverride, parent?.visibilityAction, component.divVisibilityActionJsonTemplateParser),
                visibilityActions = JsonFieldParser.readOptionalListField(context, logger, data, "visibility_actions", allowOverride, parent?.visibilityActions, component.divVisibilityActionJsonTemplateParser),
                width = JsonFieldParser.readOptionalField(context, logger, data, "width", allowOverride, parent?.width, component.divSizeJsonTemplateParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTextTemplate): JSONObject {
            val data = JSONObject()
            data.writeField(key = "accessibility", field = value.accessibility, converter = component.divAccessibilityJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "action", field = value.action, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "action_animation", field = value.actionAnimation, converter = component.divAnimationJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "actions", field = value.actions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "alignment_horizontal", field = value.alignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeFieldWithExpression(key = "alignment_vertical", field = value.alignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeFieldWithExpression(key = "alpha", field = value.alpha)
            data.writeField(key = "animators", field = value.animators, converter = component.divAnimatorJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "auto_ellipsize", field = value.autoEllipsize)
            data.writeField(key = "background", field = value.background, converter = component.divBackgroundJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "border", field = value.border, converter = component.divBorderJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "column_span", field = value.columnSpan)
            data.writeField(key = "disappear_actions", field = value.disappearActions, converter = component.divDisappearActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "doubletap_actions", field = value.doubletapActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "ellipsis", field = value.ellipsis, converter = component.divTextEllipsisJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "extensions", field = value.extensions, converter = component.divExtensionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "focus", field = value.focus, converter = component.divFocusJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "focused_text_color", field = value.focusedTextColor, converter = COLOR_INT_TO_STRING)
            data.writeFieldWithExpression(key = "font_family", field = value.fontFamily)
            data.writeFieldWithExpression(key = "font_feature_settings", field = value.fontFeatureSettings)
            data.writeFieldWithExpression(key = "font_size", field = value.fontSize)
            data.writeFieldWithExpression(key = "font_size_unit", field = value.fontSizeUnit, converter = DivSizeUnit.TO_STRING)
            data.writeFieldWithExpression(key = "font_weight", field = value.fontWeight, converter = DivFontWeight.TO_STRING)
            data.writeFieldWithExpression(key = "font_weight_value", field = value.fontWeightValue)
            data.writeField(key = "functions", field = value.functions, converter = component.divFunctionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "height", field = value.height, converter = component.divSizeJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "hover_end_actions", field = value.hoverEndActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "hover_start_actions", field = value.hoverStartActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "id", field = value.id)
            data.writeField(key = "images", field = value.images, converter = component.divTextImageJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "layout_provider", field = value.layoutProvider, converter = component.divLayoutProviderJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "letter_spacing", field = value.letterSpacing)
            data.writeFieldWithExpression(key = "line_height", field = value.lineHeight)
            data.writeField(key = "longtap_actions", field = value.longtapActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "margins", field = value.margins, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "max_lines", field = value.maxLines)
            data.writeFieldWithExpression(key = "min_hidden_lines", field = value.minHiddenLines)
            data.writeField(key = "paddings", field = value.paddings, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "press_end_actions", field = value.pressEndActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "press_start_actions", field = value.pressStartActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "ranges", field = value.ranges, converter = component.divTextRangeJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "reuse_id", field = value.reuseId)
            data.writeFieldWithExpression(key = "row_span", field = value.rowSpan)
            data.writeFieldWithExpression(key = "selectable", field = value.selectable)
            data.writeField(key = "selected_actions", field = value.selectedActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "strike", field = value.strike, converter = DivLineStyle.TO_STRING)
            data.writeFieldWithExpression(key = "text", field = value.text)
            data.writeFieldWithExpression(key = "text_alignment_horizontal", field = value.textAlignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeFieldWithExpression(key = "text_alignment_vertical", field = value.textAlignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeFieldWithExpression(key = "text_color", field = value.textColor, converter = COLOR_INT_TO_STRING)
            data.writeField(key = "text_gradient", field = value.textGradient, converter = component.divTextGradientJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "text_shadow", field = value.textShadow, converter = component.divShadowJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "tighten_width", field = value.tightenWidth)
            data.writeField(key = "tooltips", field = value.tooltips, converter = component.divTooltipJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transform", field = value.transform, converter = component.divTransformJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_change", field = value.transitionChange, converter = component.divChangeTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_in", field = value.transitionIn, converter = component.divAppearanceTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_out", field = value.transitionOut, converter = component.divAppearanceTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_triggers", field = value.transitionTriggers, converter = DivTransitionTrigger.TO_STRING)
            data.write(key = "type", value = DivText.TYPE)
            data.writeFieldWithExpression(key = "underline", field = value.underline, converter = DivLineStyle.TO_STRING)
            data.writeField(key = "variable_triggers", field = value.variableTriggers, converter = component.divTriggerJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "variables", field = value.variables, converter = component.divVariableJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "visibility", field = value.visibility, converter = DivVisibility.TO_STRING)
            data.writeField(key = "visibility_action", field = value.visibilityAction, converter = component.divVisibilityActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "visibility_actions", field = value.visibilityActions, converter = component.divVisibilityActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "width", field = value.width, converter = component.divSizeJsonTemplateParser.value.asConverter(context))
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivTextTemplate, DivText> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivTextTemplate, data: JSONObject): DivText {
            val logger = context.logger
            return DivText(
                accessibility = JsonFieldResolver.resolveOptional(context, logger, template.accessibility, data, "accessibility", component.divAccessibilityJsonTemplateResolver, component.divAccessibilityJsonEntityParser),
                action = JsonFieldResolver.resolveOptional(context, logger, template.action, data, "action", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                actionAnimation = JsonFieldResolver.resolveOptional(context, logger, template.actionAnimation, data, "action_animation", component.divAnimationJsonTemplateResolver, component.divAnimationJsonEntityParser) ?: ACTION_ANIMATION_DEFAULT_VALUE,
                actions = JsonFieldResolver.resolveOptionalList(context, logger, template.actions, data, "actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                alignmentHorizontal = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alignmentHorizontal, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alignmentVertical, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING),
                alpha = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alpha, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                animators = JsonFieldResolver.resolveOptionalList(context, logger, template.animators, data, "animators", component.divAnimatorJsonTemplateResolver, component.divAnimatorJsonEntityParser),
                autoEllipsize = JsonFieldResolver.resolveOptionalExpression(context, logger, template.autoEllipsize, data, "auto_ellipsize", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN),
                background = JsonFieldResolver.resolveOptionalList(context, logger, template.background, data, "background", component.divBackgroundJsonTemplateResolver, component.divBackgroundJsonEntityParser),
                border = JsonFieldResolver.resolveOptional(context, logger, template.border, data, "border", component.divBorderJsonTemplateResolver, component.divBorderJsonEntityParser),
                columnSpan = JsonFieldResolver.resolveOptionalExpression(context, logger, template.columnSpan, data, "column_span", TYPE_HELPER_INT, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                disappearActions = JsonFieldResolver.resolveOptionalList(context, logger, template.disappearActions, data, "disappear_actions", component.divDisappearActionJsonTemplateResolver, component.divDisappearActionJsonEntityParser),
                doubletapActions = JsonFieldResolver.resolveOptionalList(context, logger, template.doubletapActions, data, "doubletap_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                ellipsis = JsonFieldResolver.resolveOptional(context, logger, template.ellipsis, data, "ellipsis", component.divTextEllipsisJsonTemplateResolver, component.divTextEllipsisJsonEntityParser),
                extensions = JsonFieldResolver.resolveOptionalList(context, logger, template.extensions, data, "extensions", component.divExtensionJsonTemplateResolver, component.divExtensionJsonEntityParser),
                focus = JsonFieldResolver.resolveOptional(context, logger, template.focus, data, "focus", component.divFocusJsonTemplateResolver, component.divFocusJsonEntityParser),
                focusedTextColor = JsonFieldResolver.resolveOptionalExpression(context, logger, template.focusedTextColor, data, "focused_text_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
                fontFamily = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontFamily, data, "font_family", TYPE_HELPER_STRING),
                fontFeatureSettings = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontFeatureSettings, data, "font_feature_settings", TYPE_HELPER_STRING),
                fontSize = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontSize, data, "font_size", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_SIZE_VALIDATOR, FONT_SIZE_DEFAULT_VALUE) ?: FONT_SIZE_DEFAULT_VALUE,
                fontSizeUnit = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontSizeUnit, data, "font_size_unit", TYPE_HELPER_FONT_SIZE_UNIT, DivSizeUnit.FROM_STRING, FONT_SIZE_UNIT_DEFAULT_VALUE) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                fontWeight = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontWeight, data, "font_weight", TYPE_HELPER_FONT_WEIGHT, DivFontWeight.FROM_STRING, FONT_WEIGHT_DEFAULT_VALUE) ?: FONT_WEIGHT_DEFAULT_VALUE,
                fontWeightValue = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontWeightValue, data, "font_weight_value", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_WEIGHT_VALUE_VALIDATOR),
                functions = JsonFieldResolver.resolveOptionalList(context, logger, template.functions, data, "functions", component.divFunctionJsonTemplateResolver, component.divFunctionJsonEntityParser),
                height = JsonFieldResolver.resolveOptional(context, logger, template.height, data, "height", component.divSizeJsonTemplateResolver, component.divSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                hoverEndActions = JsonFieldResolver.resolveOptionalList(context, logger, template.hoverEndActions, data, "hover_end_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                hoverStartActions = JsonFieldResolver.resolveOptionalList(context, logger, template.hoverStartActions, data, "hover_start_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                id = JsonFieldResolver.resolveOptional(context, logger, template.id, data, "id"),
                images = JsonFieldResolver.resolveOptionalList(context, logger, template.images, data, "images", component.divTextImageJsonTemplateResolver, component.divTextImageJsonEntityParser),
                layoutProvider = JsonFieldResolver.resolveOptional(context, logger, template.layoutProvider, data, "layout_provider", component.divLayoutProviderJsonTemplateResolver, component.divLayoutProviderJsonEntityParser),
                letterSpacing = JsonFieldResolver.resolveOptionalExpression(context, logger, template.letterSpacing, data, "letter_spacing", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, LETTER_SPACING_DEFAULT_VALUE) ?: LETTER_SPACING_DEFAULT_VALUE,
                lineHeight = JsonFieldResolver.resolveOptionalExpression(context, logger, template.lineHeight, data, "line_height", TYPE_HELPER_INT, NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR),
                longtapActions = JsonFieldResolver.resolveOptionalList(context, logger, template.longtapActions, data, "longtap_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                margins = JsonFieldResolver.resolveOptional(context, logger, template.margins, data, "margins", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                maxLines = JsonFieldResolver.resolveOptionalExpression(context, logger, template.maxLines, data, "max_lines", TYPE_HELPER_INT, NUMBER_TO_INT, MAX_LINES_VALIDATOR),
                minHiddenLines = JsonFieldResolver.resolveOptionalExpression(context, logger, template.minHiddenLines, data, "min_hidden_lines", TYPE_HELPER_INT, NUMBER_TO_INT, MIN_HIDDEN_LINES_VALIDATOR),
                paddings = JsonFieldResolver.resolveOptional(context, logger, template.paddings, data, "paddings", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                pressEndActions = JsonFieldResolver.resolveOptionalList(context, logger, template.pressEndActions, data, "press_end_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                pressStartActions = JsonFieldResolver.resolveOptionalList(context, logger, template.pressStartActions, data, "press_start_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                ranges = JsonFieldResolver.resolveOptionalList(context, logger, template.ranges, data, "ranges", component.divTextRangeJsonTemplateResolver, component.divTextRangeJsonEntityParser),
                reuseId = JsonFieldResolver.resolveOptionalExpression(context, logger, template.reuseId, data, "reuse_id", TYPE_HELPER_STRING),
                rowSpan = JsonFieldResolver.resolveOptionalExpression(context, logger, template.rowSpan, data, "row_span", TYPE_HELPER_INT, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectable = JsonFieldResolver.resolveOptionalExpression(context, logger, template.selectable, data, "selectable", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, SELECTABLE_DEFAULT_VALUE) ?: SELECTABLE_DEFAULT_VALUE,
                selectedActions = JsonFieldResolver.resolveOptionalList(context, logger, template.selectedActions, data, "selected_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                strike = JsonFieldResolver.resolveOptionalExpression(context, logger, template.strike, data, "strike", TYPE_HELPER_STRIKE, DivLineStyle.FROM_STRING, STRIKE_DEFAULT_VALUE) ?: STRIKE_DEFAULT_VALUE,
                text = JsonFieldResolver.resolveExpression(context, logger, template.text, data, "text", TYPE_HELPER_STRING),
                textAlignmentHorizontal = JsonFieldResolver.resolveOptionalExpression(context, logger, template.textAlignmentHorizontal, data, "text_alignment_horizontal", TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING, TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE) ?: TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE,
                textAlignmentVertical = JsonFieldResolver.resolveOptionalExpression(context, logger, template.textAlignmentVertical, data, "text_alignment_vertical", TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING, TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE) ?: TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE,
                textColor = JsonFieldResolver.resolveOptionalExpression(context, logger, template.textColor, data, "text_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, TEXT_COLOR_DEFAULT_VALUE) ?: TEXT_COLOR_DEFAULT_VALUE,
                textGradient = JsonFieldResolver.resolveOptional(context, logger, template.textGradient, data, "text_gradient", component.divTextGradientJsonTemplateResolver, component.divTextGradientJsonEntityParser),
                textShadow = JsonFieldResolver.resolveOptional(context, logger, template.textShadow, data, "text_shadow", component.divShadowJsonTemplateResolver, component.divShadowJsonEntityParser),
                tightenWidth = JsonFieldResolver.resolveOptionalExpression(context, logger, template.tightenWidth, data, "tighten_width", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, TIGHTEN_WIDTH_DEFAULT_VALUE) ?: TIGHTEN_WIDTH_DEFAULT_VALUE,
                tooltips = JsonFieldResolver.resolveOptionalList(context, logger, template.tooltips, data, "tooltips", component.divTooltipJsonTemplateResolver, component.divTooltipJsonEntityParser),
                transform = JsonFieldResolver.resolveOptional(context, logger, template.transform, data, "transform", component.divTransformJsonTemplateResolver, component.divTransformJsonEntityParser),
                transitionChange = JsonFieldResolver.resolveOptional(context, logger, template.transitionChange, data, "transition_change", component.divChangeTransitionJsonTemplateResolver, component.divChangeTransitionJsonEntityParser),
                transitionIn = JsonFieldResolver.resolveOptional(context, logger, template.transitionIn, data, "transition_in", component.divAppearanceTransitionJsonTemplateResolver, component.divAppearanceTransitionJsonEntityParser),
                transitionOut = JsonFieldResolver.resolveOptional(context, logger, template.transitionOut, data, "transition_out", component.divAppearanceTransitionJsonTemplateResolver, component.divAppearanceTransitionJsonEntityParser),
                transitionTriggers = JsonFieldResolver.resolveOptionalList(context, logger, template.transitionTriggers, data, "transition_triggers", DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR),
                underline = JsonFieldResolver.resolveOptionalExpression(context, logger, template.underline, data, "underline", TYPE_HELPER_UNDERLINE, DivLineStyle.FROM_STRING, UNDERLINE_DEFAULT_VALUE) ?: UNDERLINE_DEFAULT_VALUE,
                variableTriggers = JsonFieldResolver.resolveOptionalList(context, logger, template.variableTriggers, data, "variable_triggers", component.divTriggerJsonTemplateResolver, component.divTriggerJsonEntityParser),
                variables = JsonFieldResolver.resolveOptionalList(context, logger, template.variables, data, "variables", component.divVariableJsonTemplateResolver, component.divVariableJsonEntityParser),
                visibility = JsonFieldResolver.resolveOptionalExpression(context, logger, template.visibility, data, "visibility", TYPE_HELPER_VISIBILITY, DivVisibility.FROM_STRING, VISIBILITY_DEFAULT_VALUE) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonFieldResolver.resolveOptional(context, logger, template.visibilityAction, data, "visibility_action", component.divVisibilityActionJsonTemplateResolver, component.divVisibilityActionJsonEntityParser),
                visibilityActions = JsonFieldResolver.resolveOptionalList(context, logger, template.visibilityActions, data, "visibility_actions", component.divVisibilityActionJsonTemplateResolver, component.divVisibilityActionJsonEntityParser),
                width = JsonFieldResolver.resolveOptional(context, logger, template.width, data, "width", component.divSizeJsonTemplateResolver, component.divSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }
    }

    private companion object {

        @JvmField val ACTION_ANIMATION_DEFAULT_VALUE = DivAnimation(duration = Expression.constant(100L), endValue = Expression.constant(0.6), name = Expression.constant(DivAnimation.Name.FADE), startValue = Expression.constant(1.0))
        @JvmField val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        @JvmField val FONT_SIZE_DEFAULT_VALUE = Expression.constant(12L)
        @JvmField val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)
        @JvmField val FONT_WEIGHT_DEFAULT_VALUE = Expression.constant(DivFontWeight.REGULAR)
        @JvmField val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        @JvmField val LETTER_SPACING_DEFAULT_VALUE = Expression.constant(0.0)
        @JvmField val SELECTABLE_DEFAULT_VALUE = Expression.constant(false)
        @JvmField val STRIKE_DEFAULT_VALUE = Expression.constant(DivLineStyle.NONE)
        @JvmField val TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE = Expression.constant(DivAlignmentHorizontal.START)
        @JvmField val TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE = Expression.constant(DivAlignmentVertical.TOP)
        @JvmField val TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0xFF000000.toInt())
        @JvmField val TIGHTEN_WIDTH_DEFAULT_VALUE = Expression.constant(false)
        @JvmField val UNDERLINE_DEFAULT_VALUE = Expression.constant(DivLineStyle.NONE)
        @JvmField val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        @JvmField val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        @JvmField val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        @JvmField val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        @JvmField val TYPE_HELPER_FONT_SIZE_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }
        @JvmField val TYPE_HELPER_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }
        @JvmField val TYPE_HELPER_STRIKE = TypeHelper.from(default = DivLineStyle.values().first()) { it is DivLineStyle }
        @JvmField val TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        @JvmField val TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        @JvmField val TYPE_HELPER_UNDERLINE = TypeHelper.from(default = DivLineStyle.values().first()) { it is DivLineStyle }
        @JvmField val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmField val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        @JvmField val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val FONT_SIZE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val FONT_WEIGHT_VALUE_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
        @JvmField val LINE_HEIGHT_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val MAX_LINES_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val MIN_HIDDEN_LINES_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
    }
}

internal class DivTextRangeJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivText.Range> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivText.Range {
            val logger = context.logger
            return DivText.Range(
                actions = JsonPropertyParser.readOptionalList(context, logger, data, "actions", component.divActionJsonEntityParser),
                alignmentVertical = JsonExpressionParser.readOptionalExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivTextAlignmentVertical.FROM_STRING),
                background = JsonPropertyParser.readOptional(context, logger, data, "background", component.divTextRangeBackgroundJsonEntityParser),
                border = JsonPropertyParser.readOptional(context, logger, data, "border", component.divTextRangeBorderJsonEntityParser),
                end = JsonExpressionParser.readOptionalExpression(context, logger, data, "end", TYPE_HELPER_INT, NUMBER_TO_INT, END_VALIDATOR),
                fontFamily = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_family", TYPE_HELPER_STRING),
                fontFeatureSettings = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_feature_settings", TYPE_HELPER_STRING),
                fontSize = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_size", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_SIZE_VALIDATOR),
                fontSizeUnit = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_size_unit", TYPE_HELPER_FONT_SIZE_UNIT, DivSizeUnit.FROM_STRING, FONT_SIZE_UNIT_DEFAULT_VALUE) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                fontWeight = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_weight", TYPE_HELPER_FONT_WEIGHT, DivFontWeight.FROM_STRING),
                fontWeightValue = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_weight_value", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_WEIGHT_VALUE_VALIDATOR),
                letterSpacing = JsonExpressionParser.readOptionalExpression(context, logger, data, "letter_spacing", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE),
                lineHeight = JsonExpressionParser.readOptionalExpression(context, logger, data, "line_height", TYPE_HELPER_INT, NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR),
                mask = JsonPropertyParser.readOptional(context, logger, data, "mask", component.divTextRangeMaskJsonEntityParser),
                start = JsonExpressionParser.readOptionalExpression(context, logger, data, "start", TYPE_HELPER_INT, NUMBER_TO_INT, START_VALIDATOR, START_DEFAULT_VALUE) ?: START_DEFAULT_VALUE,
                strike = JsonExpressionParser.readOptionalExpression(context, logger, data, "strike", TYPE_HELPER_STRIKE, DivLineStyle.FROM_STRING),
                textColor = JsonExpressionParser.readOptionalExpression(context, logger, data, "text_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
                textShadow = JsonPropertyParser.readOptional(context, logger, data, "text_shadow", component.divShadowJsonEntityParser),
                topOffset = JsonExpressionParser.readOptionalExpression(context, logger, data, "top_offset", TYPE_HELPER_INT, NUMBER_TO_INT, TOP_OFFSET_VALIDATOR),
                underline = JsonExpressionParser.readOptionalExpression(context, logger, data, "underline", TYPE_HELPER_UNDERLINE, DivLineStyle.FROM_STRING),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivText.Range): JSONObject {
            val data = JSONObject()
            data.write(key = "actions", value = component.divActionJsonEntityParser.value.serialize(context, value.actions))
            data.writeExpression(key = "alignment_vertical", value = value.alignmentVertical, converter = DivTextAlignmentVertical.TO_STRING)
            data.write(key = "background", value = component.divTextRangeBackgroundJsonEntityParser.value.serialize(context, value.background))
            data.write(key = "border", value = component.divTextRangeBorderJsonEntityParser.value.serialize(context, value.border))
            data.writeExpression(key = "end", value = value.end)
            data.writeExpression(key = "font_family", value = value.fontFamily)
            data.writeExpression(key = "font_feature_settings", value = value.fontFeatureSettings)
            data.writeExpression(key = "font_size", value = value.fontSize)
            data.writeExpression(key = "font_size_unit", value = value.fontSizeUnit, converter = DivSizeUnit.TO_STRING)
            data.writeExpression(key = "font_weight", value = value.fontWeight, converter = DivFontWeight.TO_STRING)
            data.writeExpression(key = "font_weight_value", value = value.fontWeightValue)
            data.writeExpression(key = "letter_spacing", value = value.letterSpacing)
            data.writeExpression(key = "line_height", value = value.lineHeight)
            data.write(key = "mask", value = component.divTextRangeMaskJsonEntityParser.value.serialize(context, value.mask))
            data.writeExpression(key = "start", value = value.start)
            data.writeExpression(key = "strike", value = value.strike, converter = DivLineStyle.TO_STRING)
            data.writeExpression(key = "text_color", value = value.textColor, converter = COLOR_INT_TO_STRING)
            data.write(key = "text_shadow", value = component.divShadowJsonEntityParser.value.serialize(context, value.textShadow))
            data.writeExpression(key = "top_offset", value = value.topOffset)
            data.writeExpression(key = "underline", value = value.underline, converter = DivLineStyle.TO_STRING)
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivTextTemplate.RangeTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivTextTemplate.RangeTemplate?, data: JSONObject): DivTextTemplate.RangeTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivTextTemplate.RangeTemplate(
                actions = JsonFieldParser.readOptionalListField(context, logger, data, "actions", allowOverride, parent?.actions, component.divActionJsonTemplateParser),
                alignmentVertical = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, allowOverride, parent?.alignmentVertical, DivTextAlignmentVertical.FROM_STRING),
                background = JsonFieldParser.readOptionalField(context, logger, data, "background", allowOverride, parent?.background, component.divTextRangeBackgroundJsonTemplateParser),
                border = JsonFieldParser.readOptionalField(context, logger, data, "border", allowOverride, parent?.border, component.divTextRangeBorderJsonTemplateParser),
                end = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "end", TYPE_HELPER_INT, allowOverride, parent?.end, NUMBER_TO_INT, END_VALIDATOR),
                fontFamily = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_family", TYPE_HELPER_STRING, allowOverride, parent?.fontFamily),
                fontFeatureSettings = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_feature_settings", TYPE_HELPER_STRING, allowOverride, parent?.fontFeatureSettings),
                fontSize = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_size", TYPE_HELPER_INT, allowOverride, parent?.fontSize, NUMBER_TO_INT, FONT_SIZE_VALIDATOR),
                fontSizeUnit = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_size_unit", TYPE_HELPER_FONT_SIZE_UNIT, allowOverride, parent?.fontSizeUnit, DivSizeUnit.FROM_STRING),
                fontWeight = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_weight", TYPE_HELPER_FONT_WEIGHT, allowOverride, parent?.fontWeight, DivFontWeight.FROM_STRING),
                fontWeightValue = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_weight_value", TYPE_HELPER_INT, allowOverride, parent?.fontWeightValue, NUMBER_TO_INT, FONT_WEIGHT_VALUE_VALIDATOR),
                letterSpacing = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "letter_spacing", TYPE_HELPER_DOUBLE, allowOverride, parent?.letterSpacing, NUMBER_TO_DOUBLE),
                lineHeight = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "line_height", TYPE_HELPER_INT, allowOverride, parent?.lineHeight, NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR),
                mask = JsonFieldParser.readOptionalField(context, logger, data, "mask", allowOverride, parent?.mask, component.divTextRangeMaskJsonTemplateParser),
                start = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "start", TYPE_HELPER_INT, allowOverride, parent?.start, NUMBER_TO_INT, START_VALIDATOR),
                strike = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "strike", TYPE_HELPER_STRIKE, allowOverride, parent?.strike, DivLineStyle.FROM_STRING),
                textColor = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "text_color", TYPE_HELPER_COLOR, allowOverride, parent?.textColor, STRING_TO_COLOR_INT),
                textShadow = JsonFieldParser.readOptionalField(context, logger, data, "text_shadow", allowOverride, parent?.textShadow, component.divShadowJsonTemplateParser),
                topOffset = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "top_offset", TYPE_HELPER_INT, allowOverride, parent?.topOffset, NUMBER_TO_INT, TOP_OFFSET_VALIDATOR),
                underline = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "underline", TYPE_HELPER_UNDERLINE, allowOverride, parent?.underline, DivLineStyle.FROM_STRING),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTextTemplate.RangeTemplate): JSONObject {
            val data = JSONObject()
            data.writeField(key = "actions", field = value.actions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "alignment_vertical", field = value.alignmentVertical, converter = DivTextAlignmentVertical.TO_STRING)
            data.writeField(key = "background", field = value.background, converter = component.divTextRangeBackgroundJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "border", field = value.border, converter = component.divTextRangeBorderJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "end", field = value.end)
            data.writeFieldWithExpression(key = "font_family", field = value.fontFamily)
            data.writeFieldWithExpression(key = "font_feature_settings", field = value.fontFeatureSettings)
            data.writeFieldWithExpression(key = "font_size", field = value.fontSize)
            data.writeFieldWithExpression(key = "font_size_unit", field = value.fontSizeUnit, converter = DivSizeUnit.TO_STRING)
            data.writeFieldWithExpression(key = "font_weight", field = value.fontWeight, converter = DivFontWeight.TO_STRING)
            data.writeFieldWithExpression(key = "font_weight_value", field = value.fontWeightValue)
            data.writeFieldWithExpression(key = "letter_spacing", field = value.letterSpacing)
            data.writeFieldWithExpression(key = "line_height", field = value.lineHeight)
            data.writeField(key = "mask", field = value.mask, converter = component.divTextRangeMaskJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "start", field = value.start)
            data.writeFieldWithExpression(key = "strike", field = value.strike, converter = DivLineStyle.TO_STRING)
            data.writeFieldWithExpression(key = "text_color", field = value.textColor, converter = COLOR_INT_TO_STRING)
            data.writeField(key = "text_shadow", field = value.textShadow, converter = component.divShadowJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "top_offset", field = value.topOffset)
            data.writeFieldWithExpression(key = "underline", field = value.underline, converter = DivLineStyle.TO_STRING)
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivTextTemplate.RangeTemplate, DivText.Range> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivTextTemplate.RangeTemplate, data: JSONObject): DivText.Range {
            val logger = context.logger
            return DivText.Range(
                actions = JsonFieldResolver.resolveOptionalList(context, logger, template.actions, data, "actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                alignmentVertical = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alignmentVertical, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivTextAlignmentVertical.FROM_STRING),
                background = JsonFieldResolver.resolveOptional(context, logger, template.background, data, "background", component.divTextRangeBackgroundJsonTemplateResolver, component.divTextRangeBackgroundJsonEntityParser),
                border = JsonFieldResolver.resolveOptional(context, logger, template.border, data, "border", component.divTextRangeBorderJsonTemplateResolver, component.divTextRangeBorderJsonEntityParser),
                end = JsonFieldResolver.resolveOptionalExpression(context, logger, template.end, data, "end", TYPE_HELPER_INT, NUMBER_TO_INT, END_VALIDATOR),
                fontFamily = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontFamily, data, "font_family", TYPE_HELPER_STRING),
                fontFeatureSettings = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontFeatureSettings, data, "font_feature_settings", TYPE_HELPER_STRING),
                fontSize = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontSize, data, "font_size", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_SIZE_VALIDATOR),
                fontSizeUnit = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontSizeUnit, data, "font_size_unit", TYPE_HELPER_FONT_SIZE_UNIT, DivSizeUnit.FROM_STRING, FONT_SIZE_UNIT_DEFAULT_VALUE) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                fontWeight = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontWeight, data, "font_weight", TYPE_HELPER_FONT_WEIGHT, DivFontWeight.FROM_STRING),
                fontWeightValue = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontWeightValue, data, "font_weight_value", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_WEIGHT_VALUE_VALIDATOR),
                letterSpacing = JsonFieldResolver.resolveOptionalExpression(context, logger, template.letterSpacing, data, "letter_spacing", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE),
                lineHeight = JsonFieldResolver.resolveOptionalExpression(context, logger, template.lineHeight, data, "line_height", TYPE_HELPER_INT, NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR),
                mask = JsonFieldResolver.resolveOptional(context, logger, template.mask, data, "mask", component.divTextRangeMaskJsonTemplateResolver, component.divTextRangeMaskJsonEntityParser),
                start = JsonFieldResolver.resolveOptionalExpression(context, logger, template.start, data, "start", TYPE_HELPER_INT, NUMBER_TO_INT, START_VALIDATOR, START_DEFAULT_VALUE) ?: START_DEFAULT_VALUE,
                strike = JsonFieldResolver.resolveOptionalExpression(context, logger, template.strike, data, "strike", TYPE_HELPER_STRIKE, DivLineStyle.FROM_STRING),
                textColor = JsonFieldResolver.resolveOptionalExpression(context, logger, template.textColor, data, "text_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
                textShadow = JsonFieldResolver.resolveOptional(context, logger, template.textShadow, data, "text_shadow", component.divShadowJsonTemplateResolver, component.divShadowJsonEntityParser),
                topOffset = JsonFieldResolver.resolveOptionalExpression(context, logger, template.topOffset, data, "top_offset", TYPE_HELPER_INT, NUMBER_TO_INT, TOP_OFFSET_VALIDATOR),
                underline = JsonFieldResolver.resolveOptionalExpression(context, logger, template.underline, data, "underline", TYPE_HELPER_UNDERLINE, DivLineStyle.FROM_STRING),
            )
        }
    }

    private companion object {

        @JvmField val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)
        @JvmField val START_DEFAULT_VALUE = Expression.constant(0L)

        @JvmField val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivTextAlignmentVertical.values().first()) { it is DivTextAlignmentVertical }
        @JvmField val TYPE_HELPER_FONT_SIZE_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }
        @JvmField val TYPE_HELPER_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }
        @JvmField val TYPE_HELPER_STRIKE = TypeHelper.from(default = DivLineStyle.values().first()) { it is DivLineStyle }
        @JvmField val TYPE_HELPER_UNDERLINE = TypeHelper.from(default = DivLineStyle.values().first()) { it is DivLineStyle }

        @JvmField val END_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
        @JvmField val FONT_SIZE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val FONT_WEIGHT_VALUE_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
        @JvmField val LINE_HEIGHT_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val START_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val TOP_OFFSET_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
    }
}

internal class DivTextImageJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivText.Image> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivText.Image {
            val logger = context.logger
            return DivText.Image(
                accessibility = JsonPropertyParser.readOptional(context, logger, data, "accessibility", component.divTextImageAccessibilityJsonEntityParser),
                alignmentVertical = JsonExpressionParser.readOptionalExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivTextAlignmentVertical.FROM_STRING, ALIGNMENT_VERTICAL_DEFAULT_VALUE) ?: ALIGNMENT_VERTICAL_DEFAULT_VALUE,
                height = JsonPropertyParser.readOptional(context, logger, data, "height", component.divFixedSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                indexingDirection = JsonExpressionParser.readOptionalExpression(context, logger, data, "indexing_direction", TYPE_HELPER_INDEXING_DIRECTION, DivText.Image.IndexingDirection.FROM_STRING, INDEXING_DIRECTION_DEFAULT_VALUE) ?: INDEXING_DIRECTION_DEFAULT_VALUE,
                preloadRequired = JsonExpressionParser.readOptionalExpression(context, logger, data, "preload_required", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, PRELOAD_REQUIRED_DEFAULT_VALUE) ?: PRELOAD_REQUIRED_DEFAULT_VALUE,
                start = JsonExpressionParser.readExpression(context, logger, data, "start", TYPE_HELPER_INT, NUMBER_TO_INT, START_VALIDATOR),
                tintColor = JsonExpressionParser.readOptionalExpression(context, logger, data, "tint_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
                tintMode = JsonExpressionParser.readOptionalExpression(context, logger, data, "tint_mode", TYPE_HELPER_TINT_MODE, DivBlendMode.FROM_STRING, TINT_MODE_DEFAULT_VALUE) ?: TINT_MODE_DEFAULT_VALUE,
                url = JsonExpressionParser.readExpression(context, logger, data, "url", TYPE_HELPER_URI, ANY_TO_URI),
                width = JsonPropertyParser.readOptional(context, logger, data, "width", component.divFixedSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivText.Image): JSONObject {
            val data = JSONObject()
            data.write(key = "accessibility", value = component.divTextImageAccessibilityJsonEntityParser.value.serialize(context, value.accessibility))
            data.writeExpression(key = "alignment_vertical", value = value.alignmentVertical, converter = DivTextAlignmentVertical.TO_STRING)
            data.write(key = "height", value = component.divFixedSizeJsonEntityParser.value.serialize(context, value.height))
            data.writeExpression(key = "indexing_direction", value = value.indexingDirection, converter = DivText.Image.IndexingDirection.TO_STRING)
            data.writeExpression(key = "preload_required", value = value.preloadRequired)
            data.writeExpression(key = "start", value = value.start)
            data.writeExpression(key = "tint_color", value = value.tintColor, converter = COLOR_INT_TO_STRING)
            data.writeExpression(key = "tint_mode", value = value.tintMode, converter = DivBlendMode.TO_STRING)
            data.writeExpression(key = "url", value = value.url, converter = URI_TO_STRING)
            data.write(key = "width", value = component.divFixedSizeJsonEntityParser.value.serialize(context, value.width))
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivTextTemplate.ImageTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivTextTemplate.ImageTemplate?, data: JSONObject): DivTextTemplate.ImageTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivTextTemplate.ImageTemplate(
                accessibility = JsonFieldParser.readOptionalField(context, logger, data, "accessibility", allowOverride, parent?.accessibility, component.divTextImageAccessibilityJsonTemplateParser),
                alignmentVertical = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, allowOverride, parent?.alignmentVertical, DivTextAlignmentVertical.FROM_STRING),
                height = JsonFieldParser.readOptionalField(context, logger, data, "height", allowOverride, parent?.height, component.divFixedSizeJsonTemplateParser),
                indexingDirection = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "indexing_direction", TYPE_HELPER_INDEXING_DIRECTION, allowOverride, parent?.indexingDirection, DivText.Image.IndexingDirection.FROM_STRING),
                preloadRequired = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "preload_required", TYPE_HELPER_BOOLEAN, allowOverride, parent?.preloadRequired, ANY_TO_BOOLEAN),
                start = JsonFieldParser.readFieldWithExpression(context, logger, data, "start", TYPE_HELPER_INT, allowOverride, parent?.start, NUMBER_TO_INT, START_VALIDATOR),
                tintColor = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "tint_color", TYPE_HELPER_COLOR, allowOverride, parent?.tintColor, STRING_TO_COLOR_INT),
                tintMode = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "tint_mode", TYPE_HELPER_TINT_MODE, allowOverride, parent?.tintMode, DivBlendMode.FROM_STRING),
                url = JsonFieldParser.readFieldWithExpression(context, logger, data, "url", TYPE_HELPER_URI, allowOverride, parent?.url, ANY_TO_URI),
                width = JsonFieldParser.readOptionalField(context, logger, data, "width", allowOverride, parent?.width, component.divFixedSizeJsonTemplateParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTextTemplate.ImageTemplate): JSONObject {
            val data = JSONObject()
            data.writeField(key = "accessibility", field = value.accessibility, converter = component.divTextImageAccessibilityJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "alignment_vertical", field = value.alignmentVertical, converter = DivTextAlignmentVertical.TO_STRING)
            data.writeField(key = "height", field = value.height, converter = component.divFixedSizeJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "indexing_direction", field = value.indexingDirection, converter = DivText.Image.IndexingDirection.TO_STRING)
            data.writeFieldWithExpression(key = "preload_required", field = value.preloadRequired)
            data.writeFieldWithExpression(key = "start", field = value.start)
            data.writeFieldWithExpression(key = "tint_color", field = value.tintColor, converter = COLOR_INT_TO_STRING)
            data.writeFieldWithExpression(key = "tint_mode", field = value.tintMode, converter = DivBlendMode.TO_STRING)
            data.writeFieldWithExpression(key = "url", field = value.url, converter = URI_TO_STRING)
            data.writeField(key = "width", field = value.width, converter = component.divFixedSizeJsonTemplateParser.value.asConverter(context))
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivTextTemplate.ImageTemplate, DivText.Image> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivTextTemplate.ImageTemplate, data: JSONObject): DivText.Image {
            val logger = context.logger
            return DivText.Image(
                accessibility = JsonFieldResolver.resolveOptional(context, logger, template.accessibility, data, "accessibility", component.divTextImageAccessibilityJsonTemplateResolver, component.divTextImageAccessibilityJsonEntityParser),
                alignmentVertical = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alignmentVertical, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivTextAlignmentVertical.FROM_STRING, ALIGNMENT_VERTICAL_DEFAULT_VALUE) ?: ALIGNMENT_VERTICAL_DEFAULT_VALUE,
                height = JsonFieldResolver.resolveOptional(context, logger, template.height, data, "height", component.divFixedSizeJsonTemplateResolver, component.divFixedSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                indexingDirection = JsonFieldResolver.resolveOptionalExpression(context, logger, template.indexingDirection, data, "indexing_direction", TYPE_HELPER_INDEXING_DIRECTION, DivText.Image.IndexingDirection.FROM_STRING, INDEXING_DIRECTION_DEFAULT_VALUE) ?: INDEXING_DIRECTION_DEFAULT_VALUE,
                preloadRequired = JsonFieldResolver.resolveOptionalExpression(context, logger, template.preloadRequired, data, "preload_required", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, PRELOAD_REQUIRED_DEFAULT_VALUE) ?: PRELOAD_REQUIRED_DEFAULT_VALUE,
                start = JsonFieldResolver.resolveExpression(context, logger, template.start, data, "start", TYPE_HELPER_INT, NUMBER_TO_INT, START_VALIDATOR),
                tintColor = JsonFieldResolver.resolveOptionalExpression(context, logger, template.tintColor, data, "tint_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
                tintMode = JsonFieldResolver.resolveOptionalExpression(context, logger, template.tintMode, data, "tint_mode", TYPE_HELPER_TINT_MODE, DivBlendMode.FROM_STRING, TINT_MODE_DEFAULT_VALUE) ?: TINT_MODE_DEFAULT_VALUE,
                url = JsonFieldResolver.resolveExpression(context, logger, template.url, data, "url", TYPE_HELPER_URI, ANY_TO_URI),
                width = JsonFieldResolver.resolveOptional(context, logger, template.width, data, "width", component.divFixedSizeJsonTemplateResolver, component.divFixedSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }
    }

    private companion object {

        @JvmField val ALIGNMENT_VERTICAL_DEFAULT_VALUE = Expression.constant(DivTextAlignmentVertical.CENTER)
        @JvmField val HEIGHT_DEFAULT_VALUE = DivFixedSize(value = Expression.constant(20L))
        @JvmField val INDEXING_DIRECTION_DEFAULT_VALUE = Expression.constant(DivText.Image.IndexingDirection.NORMAL)
        @JvmField val PRELOAD_REQUIRED_DEFAULT_VALUE = Expression.constant(false)
        @JvmField val TINT_MODE_DEFAULT_VALUE = Expression.constant(DivBlendMode.SOURCE_IN)
        @JvmField val WIDTH_DEFAULT_VALUE = DivFixedSize(value = Expression.constant(20L))

        @JvmField val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivTextAlignmentVertical.values().first()) { it is DivTextAlignmentVertical }
        @JvmField val TYPE_HELPER_INDEXING_DIRECTION = TypeHelper.from(default = DivText.Image.IndexingDirection.values().first()) { it is DivText.Image.IndexingDirection }
        @JvmField val TYPE_HELPER_TINT_MODE = TypeHelper.from(default = DivBlendMode.values().first()) { it is DivBlendMode }

        @JvmField val START_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
    }
}

internal class DivTextImageAccessibilityJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivText.Image.Accessibility> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivText.Image.Accessibility {
            val logger = context.logger
            return DivText.Image.Accessibility(
                description = JsonExpressionParser.readOptionalExpression(context, logger, data, "description", TYPE_HELPER_STRING),
                type = JsonPropertyParser.readOptional(context, logger, data, "type", DivText.Image.Accessibility.Type.FROM_STRING) ?: TYPE_DEFAULT_VALUE,
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivText.Image.Accessibility): JSONObject {
            val data = JSONObject()
            data.writeExpression(key = "description", value = value.description)
            data.write(key = "type", value = value.type, converter = DivText.Image.Accessibility.Type.TO_STRING)
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivTextTemplate.ImageTemplate.AccessibilityTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivTextTemplate.ImageTemplate.AccessibilityTemplate?, data: JSONObject): DivTextTemplate.ImageTemplate.AccessibilityTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivTextTemplate.ImageTemplate.AccessibilityTemplate(
                description = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "description", TYPE_HELPER_STRING, allowOverride, parent?.description),
                type = JsonFieldParser.readOptionalField(context, logger, data, "type", allowOverride, parent?.type, DivText.Image.Accessibility.Type.FROM_STRING),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTextTemplate.ImageTemplate.AccessibilityTemplate): JSONObject {
            val data = JSONObject()
            data.writeFieldWithExpression(key = "description", field = value.description)
            data.writeField(key = "type", field = value.type, converter = DivText.Image.Accessibility.Type.TO_STRING)
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivTextTemplate.ImageTemplate.AccessibilityTemplate, DivText.Image.Accessibility> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivTextTemplate.ImageTemplate.AccessibilityTemplate, data: JSONObject): DivText.Image.Accessibility {
            val logger = context.logger
            return DivText.Image.Accessibility(
                description = JsonFieldResolver.resolveOptionalExpression(context, logger, template.description, data, "description", TYPE_HELPER_STRING),
                type = JsonFieldResolver.resolveOptional(context, logger, template.type, data, "type", DivText.Image.Accessibility.Type.FROM_STRING) ?: TYPE_DEFAULT_VALUE,
            )
        }
    }

    private companion object {

        @JvmField val TYPE_DEFAULT_VALUE = DivText.Image.Accessibility.Type.AUTO
    }
}

internal class DivTextEllipsisJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivText.Ellipsis> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivText.Ellipsis {
            val logger = context.logger
            return DivText.Ellipsis(
                actions = JsonPropertyParser.readOptionalList(context, logger, data, "actions", component.divActionJsonEntityParser),
                images = JsonPropertyParser.readOptionalList(context, logger, data, "images", component.divTextImageJsonEntityParser),
                ranges = JsonPropertyParser.readOptionalList(context, logger, data, "ranges", component.divTextRangeJsonEntityParser),
                text = JsonExpressionParser.readExpression(context, logger, data, "text", TYPE_HELPER_STRING),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivText.Ellipsis): JSONObject {
            val data = JSONObject()
            data.write(key = "actions", value = component.divActionJsonEntityParser.value.serialize(context, value.actions))
            data.write(key = "images", value = component.divTextImageJsonEntityParser.value.serialize(context, value.images))
            data.write(key = "ranges", value = component.divTextRangeJsonEntityParser.value.serialize(context, value.ranges))
            data.writeExpression(key = "text", value = value.text)
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivTextTemplate.EllipsisTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivTextTemplate.EllipsisTemplate?, data: JSONObject): DivTextTemplate.EllipsisTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivTextTemplate.EllipsisTemplate(
                actions = JsonFieldParser.readOptionalListField(context, logger, data, "actions", allowOverride, parent?.actions, component.divActionJsonTemplateParser),
                images = JsonFieldParser.readOptionalListField(context, logger, data, "images", allowOverride, parent?.images, component.divTextImageJsonTemplateParser),
                ranges = JsonFieldParser.readOptionalListField(context, logger, data, "ranges", allowOverride, parent?.ranges, component.divTextRangeJsonTemplateParser),
                text = JsonFieldParser.readFieldWithExpression(context, logger, data, "text", TYPE_HELPER_STRING, allowOverride, parent?.text),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTextTemplate.EllipsisTemplate): JSONObject {
            val data = JSONObject()
            data.writeField(key = "actions", field = value.actions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "images", field = value.images, converter = component.divTextImageJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "ranges", field = value.ranges, converter = component.divTextRangeJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "text", field = value.text)
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivTextTemplate.EllipsisTemplate, DivText.Ellipsis> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivTextTemplate.EllipsisTemplate, data: JSONObject): DivText.Ellipsis {
            val logger = context.logger
            return DivText.Ellipsis(
                actions = JsonFieldResolver.resolveOptionalList(context, logger, template.actions, data, "actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                images = JsonFieldResolver.resolveOptionalList(context, logger, template.images, data, "images", component.divTextImageJsonTemplateResolver, component.divTextImageJsonEntityParser),
                ranges = JsonFieldResolver.resolveOptionalList(context, logger, template.ranges, data, "ranges", component.divTextRangeJsonTemplateResolver, component.divTextRangeJsonEntityParser),
                text = JsonFieldResolver.resolveExpression(context, logger, template.text, data, "text", TYPE_HELPER_STRING),
            )
        }
    }
}
