// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivVideoSourceJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivVideoSource> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivVideoSource {
            val logger = context.logger
            return DivVideoSource(
                bitrate = JsonExpressionParser.readOptionalExpression(context, logger, data, "bitrate", TYPE_HELPER_INT, NUMBER_TO_INT),
                mimeType = JsonExpressionParser.readExpression(context, logger, data, "mime_type", TYPE_HELPER_STRING),
                resolution = JsonPropertyParser.readOptional(context, logger, data, "resolution", component.divVideoSourceResolutionJsonEntityParser),
                url = JsonExpressionParser.readExpression(context, logger, data, "url", TYPE_HELPER_URI, ANY_TO_URI),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivVideoSource): JSONObject {
            val data = JSONObject()
            data.writeExpression(key = "bitrate", value = value.bitrate)
            data.writeExpression(key = "mime_type", value = value.mimeType)
            data.write(key = "resolution", value = component.divVideoSourceResolutionJsonEntityParser.value.serialize(context, value.resolution))
            data.write(key = "type", value = DivVideoSource.TYPE)
            data.writeExpression(key = "url", value = value.url, converter = URI_TO_STRING)
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivVideoSourceTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivVideoSourceTemplate?, data: JSONObject): DivVideoSourceTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivVideoSourceTemplate(
                bitrate = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "bitrate", TYPE_HELPER_INT, allowOverride, parent?.bitrate, NUMBER_TO_INT),
                mimeType = JsonFieldParser.readFieldWithExpression(context, logger, data, "mime_type", TYPE_HELPER_STRING, allowOverride, parent?.mimeType),
                resolution = JsonFieldParser.readOptionalField(context, logger, data, "resolution", allowOverride, parent?.resolution, component.divVideoSourceResolutionJsonTemplateParser),
                url = JsonFieldParser.readFieldWithExpression(context, logger, data, "url", TYPE_HELPER_URI, allowOverride, parent?.url, ANY_TO_URI),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivVideoSourceTemplate): JSONObject {
            val data = JSONObject()
            data.writeFieldWithExpression(key = "bitrate", field = value.bitrate)
            data.writeFieldWithExpression(key = "mime_type", field = value.mimeType)
            data.writeField(key = "resolution", field = value.resolution, converter = component.divVideoSourceResolutionJsonTemplateParser.value.asConverter(context))
            data.write(key = "type", value = DivVideoSource.TYPE)
            data.writeFieldWithExpression(key = "url", field = value.url, converter = URI_TO_STRING)
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivVideoSourceTemplate, DivVideoSource> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivVideoSourceTemplate, data: JSONObject): DivVideoSource {
            val logger = context.logger
            return DivVideoSource(
                bitrate = JsonFieldResolver.resolveOptionalExpression(context, logger, template.bitrate, data, "bitrate", TYPE_HELPER_INT, NUMBER_TO_INT),
                mimeType = JsonFieldResolver.resolveExpression(context, logger, template.mimeType, data, "mime_type", TYPE_HELPER_STRING),
                resolution = JsonFieldResolver.resolveOptional(context, logger, template.resolution, data, "resolution", component.divVideoSourceResolutionJsonTemplateResolver, component.divVideoSourceResolutionJsonEntityParser),
                url = JsonFieldResolver.resolveExpression(context, logger, template.url, data, "url", TYPE_HELPER_URI, ANY_TO_URI),
            )
        }
    }
}

internal class DivVideoSourceResolutionJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivVideoSource.Resolution> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivVideoSource.Resolution {
            val logger = context.logger
            return DivVideoSource.Resolution(
                height = JsonExpressionParser.readExpression(context, logger, data, "height", TYPE_HELPER_INT, NUMBER_TO_INT, HEIGHT_VALIDATOR),
                width = JsonExpressionParser.readExpression(context, logger, data, "width", TYPE_HELPER_INT, NUMBER_TO_INT, WIDTH_VALIDATOR),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivVideoSource.Resolution): JSONObject {
            val data = JSONObject()
            data.writeExpression(key = "height", value = value.height)
            data.write(key = "type", value = DivVideoSource.Resolution.TYPE)
            data.writeExpression(key = "width", value = value.width)
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivVideoSourceTemplate.ResolutionTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivVideoSourceTemplate.ResolutionTemplate?, data: JSONObject): DivVideoSourceTemplate.ResolutionTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivVideoSourceTemplate.ResolutionTemplate(
                height = JsonFieldParser.readFieldWithExpression(context, logger, data, "height", TYPE_HELPER_INT, allowOverride, parent?.height, NUMBER_TO_INT, HEIGHT_VALIDATOR),
                width = JsonFieldParser.readFieldWithExpression(context, logger, data, "width", TYPE_HELPER_INT, allowOverride, parent?.width, NUMBER_TO_INT, WIDTH_VALIDATOR),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivVideoSourceTemplate.ResolutionTemplate): JSONObject {
            val data = JSONObject()
            data.writeFieldWithExpression(key = "height", field = value.height)
            data.write(key = "type", value = DivVideoSource.Resolution.TYPE)
            data.writeFieldWithExpression(key = "width", field = value.width)
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivVideoSourceTemplate.ResolutionTemplate, DivVideoSource.Resolution> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivVideoSourceTemplate.ResolutionTemplate, data: JSONObject): DivVideoSource.Resolution {
            val logger = context.logger
            return DivVideoSource.Resolution(
                height = JsonFieldResolver.resolveExpression(context, logger, template.height, data, "height", TYPE_HELPER_INT, NUMBER_TO_INT, HEIGHT_VALIDATOR),
                width = JsonFieldResolver.resolveExpression(context, logger, template.width, data, "width", TYPE_HELPER_INT, NUMBER_TO_INT, WIDTH_VALIDATOR),
            )
        }
    }

    private companion object {

        @JvmField val HEIGHT_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
        @JvmField val WIDTH_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
    }
}
