/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.evaluable.function;

import com.yandex.div.evaluable.EvaluableException;
import com.yandex.div.evaluable.EvaluableExceptionKt;
import com.yandex.div.evaluable.EvaluableType;
import com.yandex.div.evaluable.Function;
import com.yandex.div.evaluable.FunctionArgument;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a\u001a\u0010\f\u001a\u00020\n*\u00020\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u00a8\u0006\r"}, d2={"getFunctionArgumentsException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "name", "", "args", "", "Lcom/yandex/div/evaluable/EvaluableType;", "conflictsWith", "", "Lcom/yandex/div/evaluable/Function;", "other", "withArgumentsValidation", "div-evaluable"})
public final class FunctionValidatorKt {
    private static final boolean conflictsWith(Function $this$conflictsWith, Function other) {
        List<FunctionArgument> longerArgumentList;
        if (!Intrinsics.areEqual((Object)$this$conflictsWith.getName(), (Object)other.getName())) {
            return false;
        }
        List<FunctionArgument> shorterArgumentList = $this$conflictsWith.getDeclaredArgs().size() < other.getDeclaredArgs().size() ? $this$conflictsWith.getDeclaredArgs() : other.getDeclaredArgs();
        List<FunctionArgument> list = longerArgumentList = Intrinsics.areEqual(shorterArgumentList, $this$conflictsWith.getDeclaredArgs()) ? other.getDeclaredArgs() : $this$conflictsWith.getDeclaredArgs();
        if (shorterArgumentList.isEmpty()) {
            FunctionArgument functionArgument = (FunctionArgument)CollectionsKt.firstOrNull(longerArgumentList);
            return functionArgument != null ? functionArgument.isVariadic() : false;
        }
        int n = CollectionsKt.getLastIndex(shorterArgumentList);
        for (int index = 0; index < n; ++index) {
            if (shorterArgumentList.get(index).getType() == longerArgumentList.get(index).getType()) continue;
            return false;
        }
        if (((FunctionArgument)CollectionsKt.last(shorterArgumentList)).isVariadic()) {
            EvaluableType varargType = ((FunctionArgument)CollectionsKt.last(shorterArgumentList)).getType();
            int n2 = longerArgumentList.size();
            for (int index = CollectionsKt.getLastIndex(shorterArgumentList); index < n2; ++index) {
                FunctionArgument argument = longerArgumentList.get(index);
                if (argument.getType() == varargType) continue;
                return false;
            }
            return true;
        }
        if (shorterArgumentList.size() == longerArgumentList.size()) {
            return ((FunctionArgument)CollectionsKt.last(shorterArgumentList)).getType() == ((FunctionArgument)CollectionsKt.last(longerArgumentList)).getType();
        }
        if (longerArgumentList.size() == shorterArgumentList.size() + 1) {
            return !((FunctionArgument)CollectionsKt.last(longerArgumentList)).isVariadic();
        }
        return false;
    }

    @NotNull
    public static final Function withArgumentsValidation(@NotNull Function $this$withArgumentsValidation, @NotNull List<? extends EvaluableType> args) {
        Intrinsics.checkNotNullParameter((Object)$this$withArgumentsValidation, (String)"<this>");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Function.MatchResult result = $this$withArgumentsValidation.matchesArguments$div_evaluable(args);
        if (result instanceof Function.MatchResult.Ok) {
            return $this$withArgumentsValidation;
        }
        if (result instanceof Function.MatchResult.ArgCountMismatch) {
            throw new EvaluableException(($this$withArgumentsValidation.getHasVarArg$div_evaluable() ? "At least" : "Exactly") + ' ' + ((Function.MatchResult.ArgCountMismatch)result).getExpected() + " argument(s) expected.", null, 2, null);
        }
        if (result instanceof Function.MatchResult.ArgTypeMismatch) {
            if (Intrinsics.areEqual((Object)$this$withArgumentsValidation.matchesArgumentsWithCast$div_evaluable(args), (Object)Function.MatchResult.Ok.INSTANCE)) {
                return $this$withArgumentsValidation;
            }
            throw new EvaluableException("Invalid argument type: expected " + (Object)((Object)((Function.MatchResult.ArgTypeMismatch)result).getExpected()) + ", got " + (Object)((Object)((Function.MatchResult.ArgTypeMismatch)result).getActual()) + '.', null, 2, null);
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public static final Exception getFunctionArgumentsException(@NotNull String name, @NotNull List<? extends EvaluableType> args) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        if (args.isEmpty()) {
            return new EvaluableException("Function requires non empty argument list.", null, 2, null);
        }
        return new EvaluableException("Function has no matching overload for given argument types: " + EvaluableExceptionKt.toMessageFormat(args) + '.', null, 2, null);
    }

    public static final /* synthetic */ boolean access$conflictsWith(Function $receiver, Function other) {
        return FunctionValidatorKt.conflictsWith($receiver, other);
    }
}

