/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.evaluable.internal;

import com.yandex.div.evaluable.EvaluableException;
import com.yandex.div.evaluable.TokenizingException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\nH\u0002J+\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\nH\u0002J#\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/yandex/div/evaluable/internal/LiteralsEscaper;", "", "()V", "BACKSLASH", "", "ESCAPE_LITERALS", "", "", "[Ljava/lang/String;", "countConsecutiveBackslashes", "", "string", "index", "escapeLiteral", "possibleLiterals", "(Ljava/lang/String;I[Ljava/lang/String;)Ljava/lang/String;", "isPossibleEscapeLiteral", "", "literal", "from", "process", "escapingLiterals", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "div-evaluable"})
public final class LiteralsEscaper {
    @NotNull
    public static final LiteralsEscaper INSTANCE = new LiteralsEscaper();
    private static final char BACKSLASH = '\\';
    @NotNull
    private static final String[] ESCAPE_LITERALS;

    private LiteralsEscaper() {
    }

    @NotNull
    public final String process(@NotNull String string, @NotNull String[] escapingLiterals) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)escapingLiterals, (String)"escapingLiterals");
        if (!StringsKt.contains$default((CharSequence)string, (char)'\\', (boolean)false, (int)2, null)) {
            return string;
        }
        StringBuilder literalBuilder = new StringBuilder(string.length());
        int index = 0;
        while (index < string.length()) {
            if (string.charAt(index) != '\\') {
                literalBuilder.append(string.charAt(index++));
                continue;
            }
            int countOfBackslashes = this.countConsecutiveBackslashes(string, index);
            index += countOfBackslashes;
            int n = countOfBackslashes / 2;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                literalBuilder.append('\\');
            }
            boolean remainsEscapingBackslash = countOfBackslashes % 2 == 1;
            if (!remainsEscapingBackslash) continue;
            String literalToReplace = this.escapeLiteral(string, index, escapingLiterals);
            literalBuilder.append(literalToReplace);
            index += literalToReplace.length();
        }
        String string2 = literalBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"literalBuilder.toString()");
        return string2;
    }

    public static /* synthetic */ String process$default(LiteralsEscaper literalsEscaper, String string, String[] stringArray, int n, Object object) {
        if ((n & 2) != 0) {
            stringArray = ESCAPE_LITERALS;
        }
        return literalsEscaper.process(string, stringArray);
    }

    private final int countConsecutiveBackslashes(String string, int index) {
        int currentIndex;
        for (currentIndex = index; currentIndex < string.length() && string.charAt(currentIndex) == '\\'; ++currentIndex) {
        }
        return currentIndex - index;
    }

    private final String escapeLiteral(String string, int index, String[] possibleLiterals) {
        if (index == string.length() || string.charAt(index) == ' ') {
            throw new TokenizingException("Alone backslash at " + (index - 1), null, 2, null);
        }
        for (String literal : possibleLiterals) {
            if (!this.isPossibleEscapeLiteral(literal, string, index)) continue;
            return literal;
        }
        throw new EvaluableException("Incorrect string escape", null, 2, null);
    }

    private final boolean isPossibleEscapeLiteral(String literal, String string, int from) {
        int n = literal.length();
        for (int literalIndex = 0; literalIndex < n; ++literalIndex) {
            int stringIndex = from + literalIndex;
            if (stringIndex < string.length() && string.charAt(stringIndex) == literal.charAt(literalIndex)) continue;
            return false;
        }
        return true;
    }

    static {
        String[] stringArray = new String[]{"'", "@{"};
        ESCAPE_LITERALS = stringArray;
    }
}

