/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.state;

import androidx.annotation.AnyThread;
import com.yandex.div.internal.Assert;
import com.yandex.div.internal.util.CompletedFuture;
import com.yandex.div.internal.util.SingleThreadExecutor;
import com.yandex.div.state.DivStateCache;
import com.yandex.div.state.DivStateDatabase;
import com.yandex.div.state.db.DivStateEntity;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\tH\u0017J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0017J \u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\t2\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000bH\u0007J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0017J*\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\t2\u0018\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u000bH\u0007J \u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0017R\u0097\u0001\u0010\u0007\u001a\u008a\u0001\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u00120\u0012.\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b \n*\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u0018\u00010\u000b0\u000b \n*D\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u00120\u0012.\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b \n*\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u0018\u00010\u000b0\u000b\u0018\u00010\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rn\u0010\r\u001ab\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\t \n*\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u000b0\u000b \n*0\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\t \n*\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u000b0\u000b\u0018\u00010\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/yandex/div/state/DivStateCacheImpl;", "Lcom/yandex/div/state/DivStateCache;", "divStateDatabase", "Lcom/yandex/div/state/DivStateDatabase;", "executorService", "Ljava/util/concurrent/ExecutorService;", "(Lcom/yandex/div/state/DivStateDatabase;Ljava/util/concurrent/ExecutorService;)V", "cache", "", "", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/Future;", "", "rootState", "singleThreadExecutor", "Lcom/yandex/div/state/DivStateCacheImpl$WorkerThreadExecutor;", "clear", "", "getRootState", "cardId", "getState", "path", "putRootState", "future", "stateId", "putState", "WorkerThreadExecutor", "div-states_release"})
public final class DivStateCacheImpl
implements DivStateCache {
    @NotNull
    private final DivStateDatabase divStateDatabase;
    @NotNull
    private final WorkerThreadExecutor singleThreadExecutor;
    private final Map<String, Future<Map<String, String>>> cache;
    private final Map<String, Future<String>> rootState;

    public DivStateCacheImpl(@NotNull DivStateDatabase divStateDatabase, @NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)divStateDatabase, (String)"divStateDatabase");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.divStateDatabase = divStateDatabase;
        this.singleThreadExecutor = new WorkerThreadExecutor(executorService);
        this.cache = Collections.synchronizedMap(new LinkedHashMap());
        this.rootState = Collections.synchronizedMap(new LinkedHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public final void putState(@NotNull String cardId, @NotNull Future<Map<String, String>> future) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Intrinsics.checkNotNullParameter(future, (String)"future");
        Map<String, Future<Map<String, String>>> map = this.cache;
        Intrinsics.checkNotNullExpressionValue(map, (String)"cache");
        synchronized (map) {
            boolean bl = false;
            if (!this.cache.containsKey(cardId)) {
                Map<String, Future<Map<String, String>>> map2 = this.cache;
                Intrinsics.checkNotNullExpressionValue(map2, (String)"cache");
                map2.put(cardId, future);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public final void putRootState(@NotNull String cardId, @NotNull Future<String> future) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Intrinsics.checkNotNullParameter(future, (String)"future");
        Map<String, Future<String>> map = this.rootState;
        Intrinsics.checkNotNullExpressionValue(map, (String)"rootState");
        synchronized (map) {
            boolean bl = false;
            if (!this.rootState.containsKey(cardId)) {
                Map<String, Future<String>> map2 = this.rootState;
                Intrinsics.checkNotNullExpressionValue(map2, (String)"rootState");
                map2.put(cardId, future);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AnyThread
    public void putState(@NotNull String cardId, @NotNull String path, @NotNull String stateId) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)stateId, (String)"stateId");
        Map<String, Future<Map<String, String>>> map = this.cache;
        Intrinsics.checkNotNullExpressionValue(map, (String)"cache");
        synchronized (map) {
            Future future;
            boolean bl = false;
            Map<String, Future<Map<String, String>>> map2 = this.cache;
            Intrinsics.checkNotNullExpressionValue(map2, (String)"cache");
            Map<String, Future<Map<String, String>>> $this$getOrPut$iv = map2;
            boolean $i$f$getOrPut = false;
            Future value$iv = $this$getOrPut$iv.get(cardId);
            if (value$iv == null) {
                boolean bl2 = false;
                Future answer$iv = (Future)new CompletedFuture((Object)new LinkedHashMap());
                $this$getOrPut$iv.put(cardId, answer$iv);
                future = answer$iv;
            } else {
                future = value$iv;
            }
            Map<String, String> map3 = future.get();
            Intrinsics.checkNotNullExpressionValue(map3, (String)"cache.getOrPut(cardId) {\u2026Of())\n            }.get()");
            map3.put(path, stateId);
            this.singleThreadExecutor.post(() -> DivStateCacheImpl.putState$lambda-4$lambda-3(this, cardId, path, stateId));
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AnyThread
    public void putRootState(@NotNull String cardId, @NotNull String stateId) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Intrinsics.checkNotNullParameter((Object)stateId, (String)"stateId");
        Map<String, Future<String>> map = this.rootState;
        Intrinsics.checkNotNullExpressionValue(map, (String)"rootState");
        synchronized (map) {
            boolean bl = false;
            Map<String, Future<String>> map2 = this.rootState;
            Intrinsics.checkNotNullExpressionValue(map2, (String)"rootState");
            CompletedFuture completedFuture = new CompletedFuture((Object)stateId);
            map2.put(cardId, (Future<String>)completedFuture);
            this.singleThreadExecutor.post(() -> DivStateCacheImpl.putRootState$lambda-6$lambda-5(this, cardId, stateId));
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    @AnyThread
    @Nullable
    public String getState(@NotNull String cardId, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            Future<Map<String, String>> future;
            Future<Map<String, String>> future2 = future = this.cache.get(cardId);
            if (future2 == null ? false : future2.isDone()) {
                Map<String, String> map = future.get();
                return map == null ? null : map.get(path);
            }
        }
        catch (ExecutionException e) {
            Assert.fail((String)"", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AnyThread
    @Nullable
    public String getRootState(@NotNull String cardId) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        try {
            Map<String, Future<String>> map = this.rootState;
            Intrinsics.checkNotNullExpressionValue(map, (String)"rootState");
            synchronized (map) {
                block7: {
                    Future<String> future;
                    boolean bl = false;
                    Future<String> future2 = future = this.rootState.get(cardId);
                    if (!(future2 == null ? false : future2.isDone())) break block7;
                    String result = future.get();
                    if (result == null) {
                        Map<String, Future<String>> map2 = this.rootState;
                        Intrinsics.checkNotNullExpressionValue(map2, (String)"rootState");
                        Object v = null;
                        map2.put(cardId, (Future<String>)v);
                    }
                    String string = result;
                    return string;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (ExecutionException e) {
            Assert.fail((String)"", (Throwable)e);
        }
        return null;
    }

    @AnyThread
    public final void clear() {
        this.cache.clear();
        this.rootState.clear();
    }

    private static final void putState$lambda-4$lambda-3(DivStateCacheImpl this$0, String $cardId, String $path, String $stateId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$cardId, (String)"$cardId");
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$stateId, (String)"$stateId");
        this$0.divStateDatabase.getDivStateDao$div_states_release().updateState(new DivStateEntity(0, $cardId, $path, $stateId, System.currentTimeMillis()));
    }

    private static final void putRootState$lambda-6$lambda-5(DivStateCacheImpl this$0, String $cardId, String $stateId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$cardId, (String)"$cardId");
        Intrinsics.checkNotNullParameter((Object)$stateId, (String)"$stateId");
        this$0.divStateDatabase.getDivStateDao$div_states_release().deleteCardRootState($cardId);
        this$0.divStateDatabase.getDivStateDao$div_states_release().updateState(new DivStateEntity(0, $cardId, "/", $stateId, System.currentTimeMillis()));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/yandex/div/state/DivStateCacheImpl$WorkerThreadExecutor;", "Lcom/yandex/div/internal/util/SingleThreadExecutor;", "executor", "Ljava/util/concurrent/Executor;", "(Ljava/util/concurrent/Executor;)V", "handleError", "", "e", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "div-states_release"})
    private static final class WorkerThreadExecutor
    extends SingleThreadExecutor {
        public WorkerThreadExecutor(@NotNull Executor executor) {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            super(executor, "DivStateCache");
        }

        protected void handleError(@NotNull RuntimeException e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Assert.fail((String)"", (Throwable)e);
        }
    }
}

