/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.internal.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.collection.ArrayMap;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PermissionUtils {
    private static final String PREFS_NAME = "PermissionUtils.Prefs";
    private static final String PREFS_KEY_ANSWERED_PERMISSION_SET = "prefs_key_answered_permission_set";

    private PermissionUtils() {
    }

    public static boolean hasPermission(@NonNull Context context, @NonNull String permission) {
        return ContextCompat.checkSelfPermission((Context)context, (String)permission) == 0;
    }

    public static void requestPermissions(@NonNull Activity activity, int requestCode, @NonNull String[] permissions) {
        ActivityCompat.requestPermissions((Activity)activity, (String[])permissions, (int)requestCode);
    }

    @NonNull
    public static GrantResults parseGrantResults(@NonNull String[] permissions, @NonNull int[] grantResults) {
        ArrayMap resultMap = new ArrayMap();
        if (grantResults.length == 0 || permissions.length != grantResults.length) {
            return new GrantResults((Map<String, Boolean>)resultMap);
        }
        for (int i = 0; i < permissions.length; ++i) {
            String permission = permissions[i];
            int grantResult = grantResults[i];
            boolean isGranted = grantResult == 0;
            resultMap.put(permission, isGranted);
        }
        return new GrantResults((Map<String, Boolean>)resultMap);
    }

    public static boolean isDeniedWithDontAsk(@NonNull Activity activity, @NonNull String permission) {
        return !PermissionUtils.hasPermission((Context)activity, permission) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, Collections.singleton(permission)) && PermissionUtils.userEverAnswered((Context)activity, permission);
    }

    public static void markUserAnswered(@NonNull Context context, @NonNull String[] permissions) {
        HashSet<String> answeredPermissions = new HashSet<String>(PermissionUtils.getAnsweredPermissions(context));
        for (String permission : permissions) {
            if (answeredPermissions.contains(permission)) continue;
            answeredPermissions.add(permission);
        }
        context.getSharedPreferences(PREFS_NAME, 0).edit().putStringSet(PREFS_KEY_ANSWERED_PERMISSION_SET, answeredPermissions).apply();
    }

    public static boolean userEverAnswered(@NonNull Context context, @NonNull String permission) {
        return PermissionUtils.getAnsweredPermissions(context).contains(permission);
    }

    private static Set<String> getAnsweredPermissions(@NonNull Context context) {
        return context.getSharedPreferences(PREFS_NAME, 0).getStringSet(PREFS_KEY_ANSWERED_PERMISSION_SET, Collections.EMPTY_SET);
    }

    public static boolean shouldShowRequestPermissionRationale(@NonNull Activity activity, @NonNull Iterable<String> permissions) {
        for (String permission : permissions) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission)) continue;
            return true;
        }
        return false;
    }

    public static void openSettings(@NonNull Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS").setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null)).addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static class GrantResults {
        @NonNull
        private final Map<String, Boolean> mResultMap;

        GrantResults(@NonNull Map<String, Boolean> resultMap) {
            this.mResultMap = resultMap;
        }

        public boolean contains(@NonNull String permission) {
            return this.mResultMap.containsKey(permission);
        }

        public boolean isPermissionGranted(@NonNull String permission) {
            if (!this.mResultMap.containsKey(permission)) {
                return false;
            }
            return this.mResultMap.get(permission);
        }

        public boolean isDeniedWithDontAsk(@NonNull Activity activity, @NonNull String permission) {
            return !this.isPermissionGranted(permission) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, Collections.singleton(permission)) && PermissionUtils.userEverAnswered((Context)activity, permission);
        }

        public boolean areAllPermissionsGranted() {
            if (this.mResultMap.isEmpty()) {
                return false;
            }
            for (boolean isGranted : this.mResultMap.values()) {
                if (isGranted) continue;
                return false;
            }
            return true;
        }

        public boolean isAnyPermissionDeniedWithDontAsk(@NonNull Activity activity) {
            for (Map.Entry<String, Boolean> entry : this.mResultMap.entrySet()) {
                Boolean isGranted = entry.getValue();
                if (isGranted.booleanValue() || PermissionUtils.shouldShowRequestPermissionRationale(activity, Collections.singleton(entry.getKey()))) continue;
                return true;
            }
            return false;
        }

        public Collection<String> allPermissions() {
            return this.mResultMap.keySet();
        }
    }
}

