/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.install;

import android.content.Intent;
import android.net.Uri;
import com.yanzhenjie.permission.Action;
import com.yanzhenjie.permission.AndPermission;
import com.yanzhenjie.permission.Rationale;
import com.yanzhenjie.permission.install.InstallRequest;
import com.yanzhenjie.permission.source.Source;
import java.io.File;

class NRequest
implements InstallRequest {
    private Source mSource;
    private File mFile;
    private Action<File> mGranted;

    NRequest(Source source) {
        this.mSource = source;
    }

    @Override
    public InstallRequest file(File file) {
        this.mFile = file;
        return this;
    }

    @Override
    public InstallRequest rationale(Rationale<File> rationale) {
        return this;
    }

    @Override
    public InstallRequest onGranted(Action<File> granted) {
        this.mGranted = granted;
        return this;
    }

    public InstallRequest onDenied(Action denied) {
        return this;
    }

    @Override
    public void start() {
        this.callbackSucceed();
        this.install();
    }

    private void install() {
        Intent intent = new Intent("android.intent.action.INSTALL_PACKAGE");
        intent.setFlags(0x10000000);
        intent.addFlags(1);
        Uri uri = AndPermission.getFileUri(this.mSource.getContext(), this.mFile);
        intent.setDataAndType(uri, "application/vnd.android.package-archive");
        this.mSource.startActivity(intent);
    }

    private void callbackSucceed() {
        if (this.mGranted != null) {
            this.mGranted.onAction(this.mFile);
        }
    }
}

