/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.install;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.yanzhenjie.permission.Action;
import com.yanzhenjie.permission.AndPermission;
import com.yanzhenjie.permission.PermissionActivity;
import com.yanzhenjie.permission.Rationale;
import com.yanzhenjie.permission.RequestExecutor;
import com.yanzhenjie.permission.install.InstallRequest;
import com.yanzhenjie.permission.source.Source;
import com.yanzhenjie.permission.util.MainExecutor;
import java.io.File;

class ORequest
implements InstallRequest,
RequestExecutor,
PermissionActivity.RequestListener {
    private static final MainExecutor EXECUTOR = new MainExecutor();
    private Source mSource;
    private File mFile;
    private Rationale<File> mRationale = new Rationale<File>(){

        @Override
        public void showRationale(Context context, File data, RequestExecutor executor) {
            executor.execute();
        }
    };
    private Action<File> mGranted;
    private Action<File> mDenied;

    ORequest(Source source) {
        this.mSource = source;
    }

    @Override
    public InstallRequest file(File file) {
        this.mFile = file;
        return this;
    }

    @Override
    public InstallRequest rationale(Rationale<File> rationale) {
        this.mRationale = rationale;
        return this;
    }

    @Override
    public InstallRequest onGranted(Action<File> granted) {
        this.mGranted = granted;
        return this;
    }

    @Override
    public InstallRequest onDenied(Action<File> denied) {
        this.mDenied = denied;
        return this;
    }

    @Override
    public void start() {
        if (this.mSource.canRequestPackageInstalls()) {
            this.callbackSucceed();
            this.install();
        } else {
            this.mRationale.showRationale(this.mSource.getContext(), this.mFile, this);
        }
    }

    @Override
    public void execute() {
        PermissionActivity.requestInstall(this.mSource.getContext(), this);
    }

    @Override
    public void cancel() {
        this.callbackFailed();
    }

    @Override
    public void onRequestCallback() {
        EXECUTOR.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (ORequest.this.mSource.canRequestPackageInstalls()) {
                    ORequest.this.callbackSucceed();
                    ORequest.this.install();
                } else {
                    ORequest.this.callbackFailed();
                }
            }
        }, 100L);
    }

    private void install() {
        Intent intent = new Intent("android.intent.action.INSTALL_PACKAGE");
        intent.setFlags(0x10000000);
        intent.addFlags(1);
        Uri uri = AndPermission.getFileUri(this.mSource.getContext(), this.mFile);
        intent.setDataAndType(uri, "application/vnd.android.package-archive");
        this.mSource.startActivity(intent);
    }

    private void callbackSucceed() {
        if (this.mGranted != null) {
            this.mGranted.onAction(this.mFile);
        }
    }

    private void callbackFailed() {
        if (this.mDenied != null) {
            this.mDenied.onAction(this.mFile);
        }
    }
}

