/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.overlay;

import android.app.Dialog;
import android.content.Context;
import com.yanzhenjie.permission.Action;
import com.yanzhenjie.permission.PermissionActivity;
import com.yanzhenjie.permission.R;
import com.yanzhenjie.permission.Rationale;
import com.yanzhenjie.permission.RequestExecutor;
import com.yanzhenjie.permission.overlay.OverlayRequest;
import com.yanzhenjie.permission.source.Source;
import com.yanzhenjie.permission.util.MainExecutor;

class LRequest
implements OverlayRequest,
RequestExecutor,
PermissionActivity.RequestListener {
    private static final MainExecutor EXECUTOR = new MainExecutor();
    private Source mSource;
    private Rationale<Void> mRationale = new Rationale<Void>(){

        @Override
        public void showRationale(Context context, Void data, RequestExecutor executor) {
            executor.execute();
        }
    };
    private Action<Void> mGranted;
    private Action<Void> mDenied;

    LRequest(Source source) {
        this.mSource = source;
    }

    @Override
    public OverlayRequest rationale(Rationale<Void> rationale) {
        this.mRationale = rationale;
        return this;
    }

    @Override
    public OverlayRequest onGranted(Action<Void> granted) {
        this.mGranted = granted;
        return this;
    }

    @Override
    public OverlayRequest onDenied(Action<Void> denied) {
        this.mDenied = denied;
        return this;
    }

    @Override
    public void start() {
        if (this.hasPermission()) {
            this.callbackSucceed();
        } else {
            this.mRationale.showRationale(this.mSource.getContext(), null, this);
        }
    }

    @Override
    public void execute() {
        PermissionActivity.requestAlertWindow(this.mSource.getContext(), this);
    }

    @Override
    public void cancel() {
        this.callbackFailed();
    }

    @Override
    public void onRequestCallback() {
        EXECUTOR.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (LRequest.this.hasPermission()) {
                    LRequest.this.callbackSucceed();
                } else {
                    LRequest.this.callbackFailed();
                }
            }
        }, 100L);
    }

    private void callbackSucceed() {
        if (this.mGranted != null) {
            this.mGranted.onAction(null);
        }
    }

    private void callbackFailed() {
        if (this.mDenied != null) {
            this.mDenied.onAction(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasPermission() {
        Dialog dialog = new Dialog(this.mSource.getContext(), R.style.Permission_Theme_Dialog);
        dialog.getWindow().setType(2003);
        try {
            dialog.show();
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (dialog.isShowing()) {
                dialog.dismiss();
            }
        }
        return true;
    }
}

