/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.runtime;

import android.os.Build;
import com.yanzhenjie.permission.Setting;
import com.yanzhenjie.permission.runtime.LRequestFactory;
import com.yanzhenjie.permission.runtime.MRequestFactory;
import com.yanzhenjie.permission.runtime.PermissionRequest;
import com.yanzhenjie.permission.runtime.setting.RuntimeSetting;
import com.yanzhenjie.permission.source.Source;
import java.util.ArrayList;
import java.util.Arrays;

public class Runtime {
    private static final PermissionRequestFactory FACTORY = Build.VERSION.SDK_INT >= 23 ? new MRequestFactory() : new LRequestFactory();
    private Source mSource;

    public Runtime(Source source) {
        this.mSource = source;
    }

    public PermissionRequest permission(String ... permissions) {
        return FACTORY.create(this.mSource).permission(permissions);
    }

    public PermissionRequest permission(String[] ... groups) {
        ArrayList<String> permissionList = new ArrayList<String>();
        for (String[] group : groups) {
            permissionList.addAll(Arrays.asList(group));
        }
        String[] permissions = permissionList.toArray(new String[permissionList.size()]);
        return FACTORY.create(this.mSource).permission(permissions);
    }

    public Setting setting() {
        return new RuntimeSetting(this.mSource);
    }

    public static interface PermissionRequestFactory {
        public PermissionRequest create(Source var1);
    }
}

