/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.runtime.setting;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import com.yanzhenjie.permission.source.Source;

public class RuntimeSettingPage {
    private static final String MARK = Build.MANUFACTURER.toLowerCase();
    private Source mSource;

    public RuntimeSettingPage(Source source) {
        this.mSource = source;
    }

    public void start(int requestCode) {
        Intent intent = MARK.contains("huawei") ? RuntimeSettingPage.huaweiApi(this.mSource.getContext()) : (MARK.contains("xiaomi") ? RuntimeSettingPage.xiaomiApi(this.mSource.getContext()) : (MARK.contains("oppo") ? RuntimeSettingPage.oppoApi(this.mSource.getContext()) : (MARK.contains("vivo") ? RuntimeSettingPage.vivoApi(this.mSource.getContext()) : (MARK.contains("meizu") ? RuntimeSettingPage.meizuApi(this.mSource.getContext()) : RuntimeSettingPage.defaultApi(this.mSource.getContext())))));
        try {
            this.mSource.startActivityForResult(intent, requestCode);
        }
        catch (Exception e) {
            intent = RuntimeSettingPage.defaultApi(this.mSource.getContext());
            this.mSource.startActivityForResult(intent, requestCode);
        }
    }

    private static Intent defaultApi(Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null));
        return intent;
    }

    private static Intent huaweiApi(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return RuntimeSettingPage.defaultApi(context);
        }
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.huawei.systemmanager", "com.huawei.permissionmanager.ui.MainActivity"));
        return intent;
    }

    private static Intent xiaomiApi(Context context) {
        Intent intent = new Intent("miui.intent.action.APP_PERM_EDITOR");
        intent.putExtra("extra_pkgname", context.getPackageName());
        return intent;
    }

    private static Intent vivoApi(Context context) {
        Intent intent = new Intent();
        intent.putExtra("packagename", context.getPackageName());
        intent.setComponent(new ComponentName("com.vivo.permissionmanager", "com.vivo.permissionmanager.activity.SoftPermissionDetailActivity"));
        return intent;
    }

    private static Intent oppoApi(Context context) {
        Intent intent = new Intent();
        intent.putExtra("packageName", context.getPackageName());
        intent.setComponent(new ComponentName("com.color.safecenter", "com.color.safecenter.permission.PermissionManagerActivity"));
        return intent;
    }

    private static Intent meizuApi(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            return RuntimeSettingPage.defaultApi(context);
        }
        Intent intent = new Intent("com.meizu.safe.security.SHOW_APPSEC");
        intent.putExtra("packageName", context.getPackageName());
        intent.setComponent(new ComponentName("com.meizu.safe", "com.meizu.safe.security.AppSecActivity"));
        return intent;
    }
}

