/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.source;

import android.app.AppOpsManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.provider.Settings;

public abstract class Source {
    private PackageManager mPackageManager;
    private AppOpsManager mAppOpsManager;

    public abstract Context getContext();

    public abstract void startActivity(Intent var1);

    public abstract void startActivityForResult(Intent var1, int var2);

    public abstract boolean isShowRationalePermission(String var1);

    public final boolean canRequestPackageInstalls() {
        if (Build.VERSION.SDK_INT >= 26) {
            if (this.mPackageManager == null) {
                this.mPackageManager = this.getContext().getPackageManager();
            }
            return this.mPackageManager.canRequestPackageInstalls();
        }
        return true;
    }

    public final boolean canDrawOverlays() {
        if (Build.VERSION.SDK_INT >= 23) {
            int result;
            Context context = this.getContext();
            if (!Settings.canDrawOverlays((Context)context)) {
                return false;
            }
            if (this.mAppOpsManager == null) {
                this.mAppOpsManager = (AppOpsManager)context.getSystemService("appops");
            }
            if ((result = this.mAppOpsManager.checkOpNoThrow("android:system_alert_window", Process.myUid(), context.getPackageName())) != 0) {
                return false;
            }
        }
        return true;
    }
}

