package com.yodo1.common;

import com.yodo1.android.ops.net.Yodo1HttpManage;
import com.yodo1.common.collection.BuildConfig;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.sdk.base.android.Yodo1BaseUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.other.YKitUtils;
import com.yodo1.sensor.Yodo1Sensor;

/**
 * @author huangguofeng
 * desc 管理本库的版本 底层库版本
 */
public class Yodo1CommonManager {

    private static Yodo1CommonManager manager = new Yodo1CommonManager();

    private Yodo1CommonManager() {

    }

    public static Yodo1CommonManager get() {
        return manager;
    }

    /**
     * 当前framework版本号
     */
    public String getCommonManagerVersion() {
        return BuildConfig.VERSION_NAME;
    }

    /**
     * log底层库的版本号
     */
    public void queryLibsVersion() {
        YLog.d("Kit          lib version: " + YKitUtils.getKitVersion());
        YLog.d("NoHttp       lib version: " + Yodo1HttpManage.getNoHttpVersion());
        YLog.d("Sensor       lib version: " + Yodo1Sensor.getSensorVersion());
        YLog.d("OnLineConfig lib version: " + Yodo1OnlineConfig.getOnlineConfigVersion());
        YLog.d("support      lib version: " + Yodo1BaseUtils.getSupportAndroidXVersion());
    }
}
